/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.render;

import cofh.core.block.BlockCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.render.RenderUtils;
import cofh.lib.render.RenderHelper;
import cofh.repack.codechicken.lib.lighting.LightModel;
import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.uv.UVTransformation;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Scale;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.core.TDProps;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.render.ModelHelper;
import cofh.thermalfoundation.fluid.TFFluids;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderDuct
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final RenderDuct instance = new RenderDuct();
    static final int[] INV_CONNECTIONS = new int[]{BlockDuct.ConnectionTypes.DUCT.ordinal(), BlockDuct.ConnectionTypes.DUCT.ordinal(), 0, 0, 0, 0};
    static int[] connections = new int[6];
    static IIcon textureCenterLine;
    public static IIcon coverBase;
    public static IIcon signalTexture;
    public static IIcon[] servoTexture;
    public static IIcon[] retrieverTexture;
    public static IIcon[] filterTexture;
    public static IIcon sideDucts;
    static CCModel[][] modelFluid;
    public static CCModel[][] modelConnection;
    static CCModel modelCenter;
    static CCModel[] modelLine;
    static CCModel modelLineCenter;
    static CCModel[] modelFrameConnection;
    static CCModel[] modelFrame;
    public static float smallInnerModelScaling;
    public static float largeInnerModelScaling;
    public static CCModel[] modelOpaqueTubes;
    public static CCModel[] modelTransTubes;
    private static CCModel[] modelFluidTubes;
    private static CCModel[] modelLargeTubes;

    public static void initialize() {
        int n;
        RenderDuct.generateFluidModels();
        RenderDuct.generateModels();
        for (n = 0; n < 10; ++n) {
            RenderDuct.servoTexture[n] = IconRegistry.getIcon((String)("ServoBase" + n));
            RenderDuct.retrieverTexture[n] = IconRegistry.getIcon((String)("RetrieverBase" + n));
        }
        for (n = 0; n < 5; ++n) {
            RenderDuct.filterTexture[n] = IconRegistry.getIcon((String)("FilterBase" + n));
        }
        coverBase = IconRegistry.getIcon((String)"CoverBase");
        sideDucts = IconRegistry.getIcon((String)"SideDucts");
        signalTexture = IconRegistry.getIcon((String)"Signaller");
        textureCenterLine = TFFluids.fluidSteam.getIcon();
    }

    private static void generateFluidModels() {
        for (int i = 1; i < 7; ++i) {
            double d = 0.47 - 0.025 * (double)i;
            double d2 = 0.53 + 0.025 * (double)i;
            double d3 = 0.32 + 0.06 * (double)i;
            double d4 = 0.32;
            double d5 = 0.68;
            double[][] dArrayArray = new double[][]{{d, 0.0, d, d2, d4, d2}, {d, d3, d, d2, 1.0, d2}, {d4, d4, 0.0, d5, d3, d4}, {d4, d4, d5, d5, d3, 1.0}, {0.0, d4, d4, d4, d3, d5}, {d5, d4, d4, 1.0, d3, d5}, {d4, d4, d4, d5, d3, d5}};
            for (int j = 0; j < 7; ++j) {
                RenderDuct.modelFluid[i - 1][j] = CCModel.quadModel((int)24).generateBlock(0, dArrayArray[j][0], dArrayArray[j][1], dArrayArray[j][2], dArrayArray[j][3], dArrayArray[j][4], dArrayArray[j][5]).computeNormals();
            }
        }
    }

    private static void generateModels() {
        int n;
        modelCenter = CCModel.quadModel((int)48).generateBox(0, -3.0, -3.0, -3.0, 6.0, 6.0, 6.0, 0.0, 0.0, 32.0, 32.0, 16.0);
        RenderDuct.modelConnection[0][1] = CCModel.quadModel((int)48).generateBlock(0, new Cuboid6(0.3125, 0.6875, 0.3125, 0.6875, 1.0, 0.6875).expand(-9.765625E-4));
        RenderDuct.modelConnection[1][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 4.0, -4.0, 8.0, 3.9990234375, 8.0, 0.0, 0.0, 32.0, 32.0, 16.0).computeNormals();
        RenderDuct.modelConnection[2][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 4.0, -4.0, 8.0, 3.9990234375, 8.0, 0.0, 16.0, 32.0, 32.0, 16.0).computeNormals();
        double d = 0.4;
        modelLineCenter = CCModel.quadModel((int)24).generateBlock(0, d, d, d, 1.0 - d, 1.0 - d, 1.0 - d).computeNormals();
        RenderDuct.modelLine[1] = CCModel.quadModel((int)16).generateBlock(0, d, 1.0 - d, d, 1.0 - d, 1.0, 1.0 - d, 3).computeNormals();
        CCModel.generateSidedModels((CCModel[])modelLine, (int)1, (Vector3)Vector3.center);
        modelOpaqueTubes = ModelHelper.StandardTubes.genModels(0.1875f, true);
        modelTransTubes = ModelHelper.StandardTubes.genModels(0.1875f, false);
        modelFluidTubes = ModelHelper.StandardTubes.genModels(0.1875f * smallInnerModelScaling, false, false);
        modelLargeTubes = ModelHelper.StandardTubes.genModels(0.21875f, true);
        modelFrameConnection = new ModelHelper.OctagonalTubeGen(0.375, 0.1812, true).generateModels();
        modelFrame = new ModelHelper.OctagonalTubeGen(0.375 * (double)largeInnerModelScaling, 0.1812, false).generateModels();
        CCModel.generateBackface((CCModel)modelCenter, (int)0, (CCModel)modelCenter, (int)24, (int)24);
        CCModel.generateBackface((CCModel)modelConnection[0][1], (int)0, (CCModel)modelConnection[0][1], (int)24, (int)24);
        modelConnection[0][1].apply((Transformation)RenderUtils.getRenderVector((double)-0.5, (double)-0.5, (double)-0.5).translation());
        for (int i = 0; i < modelConnection.length; ++i) {
            CCModel.generateSidedModels((CCModel[])modelConnection[i], (int)1, (Vector3)Vector3.zero);
        }
        Scale[] scaleArray = new Scale[]{new Scale(1.0, -1.0, 1.0), new Scale(1.0, 1.0, -1.0), new Scale(-1.0, 1.0, 1.0)};
        for (int i = 0; i < modelConnection.length; ++i) {
            CCModel[] cCModelArray = modelConnection[i];
            for (n = 2; n < 6; n += 2) {
                cCModelArray[n] = cCModelArray[0].sidedCopy(0, n, Vector3.zero);
            }
            for (n = 1; n < 6; n += 2) {
                cCModelArray[n] = cCModelArray[n - 1].backfacedCopy().apply((Transformation)scaleArray[n / 2]);
            }
        }
        modelCenter.computeNormals().computeLighting(LightModel.standardLightModel).shrinkUVs(9.765625E-4);
        CCModel[][] cCModelArray = modelConnection;
        int n2 = cCModelArray.length;
        for (n = 0; n < n2; ++n) {
            CCModel[] cCModelArray2;
            for (CCModel cCModel : cCModelArray2 = cCModelArray[n]) {
                cCModel.computeNormals().computeLighting(LightModel.standardLightModel).shrinkUVs(9.765625E-4);
            }
        }
    }

    public boolean renderBase(boolean bl, int n, int[] nArray, double d, double d2, double d3, IIcon iIcon) {
        Translation translation = RenderUtils.getRenderVector((double)(d += 0.5), (double)(d2 += 0.5), (double)(d3 += 0.5)).translation();
        int n2 = 0;
        Duct duct = TDDucts.ductList.get(n);
        for (int i = 0; i < 6; ++i) {
            RenderUtils.ScaledIconTransformation scaledIconTransformation;
            if (!BlockDuct.ConnectionTypes.values()[nArray[i]].renderDuct()) continue;
            if (BlockDuct.ConnectionTypes.values()[nArray[i]] == BlockDuct.ConnectionTypes.STRUCTURE) {
                scaledIconTransformation = RenderUtils.getIconTransformation((IIcon)TDDucts.structure.iconBaseTexture);
                modelConnection[0][i].render(8, 24, new CCRenderState.IVertexOperation[]{translation, scaledIconTransformation});
                modelConnection[0][i].render(32, 48, new CCRenderState.IVertexOperation[]{translation, scaledIconTransformation});
                if (duct.iconConnectionTexture == null) continue;
                modelConnection[1][i].render(new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)duct.iconConnectionTexture)});
                continue;
            }
            n2 |= 1 << i;
            if (bl) {
                scaledIconTransformation = RenderUtils.getIconTransformation((IIcon)TDDucts.structureInvis.iconBaseTexture);
                modelConnection[0][i].render(4, 8, new CCRenderState.IVertexOperation[]{translation, scaledIconTransformation});
            }
            if (nArray[i] != BlockDuct.ConnectionTypes.TILECONNECTION.ordinal() || duct.iconConnectionTexture == null) continue;
            modelConnection[1][i].render(new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)duct.iconConnectionTexture)});
        }
        RenderUtils.ScaledIconTransformation scaledIconTransformation = RenderUtils.getIconTransformation((IIcon)iIcon);
        (duct.opaque ? modelOpaqueTubes[n2] : modelTransTubes[n2]).render(new CCRenderState.IVertexOperation[]{translation, scaledIconTransformation});
        if (duct.iconFluidTexture != null && duct.fluidTransparency == -1) {
            modelFluidTubes[n2].render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)duct.iconFluidTexture));
        }
        if (duct.frameType == 1) {
            this.renderSideTubes(0, nArray, d - 0.5, d2 - 0.5, d3 - 0.5, sideDucts);
        } else if (duct.frameType == 2 && duct.iconFrameTexture != null) {
            n2 = 0;
            for (int i = 0; i < 6; ++i) {
                if (!BlockDuct.ConnectionTypes.values()[nArray[i]].renderDuct() || nArray[i] == BlockDuct.ConnectionTypes.STRUCTURE.ordinal()) continue;
                n2 |= 1 << i;
                if (!bl && nArray[i] == BlockDuct.ConnectionTypes.DUCT.ordinal()) continue;
                modelFrameConnection[64 + i].render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)duct.iconFrameBandTexture));
                modelFrame[70 + i].render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)duct.iconFrameTexture));
            }
            if (RenderDuct.modelFrameConnection[n2].verts.length != 0) {
                modelFrameConnection[n2].render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)duct.iconFrameTexture));
            }
        } else if (duct.frameType == 3 && duct.iconFrameTexture != null) {
            modelLargeTubes[n2].render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)duct.iconFrameTexture));
        }
        return true;
    }

    public boolean renderSideTubes(int n, int[] nArray, double d, double d2, double d3, IIcon iIcon) {
        CCModel[] cCModelArray = n == 0 ? ModelHelper.SideTubeGen.standardTubes : ModelHelper.SideTubeGen.standardTubesInner;
        int n2 = 0;
        for (int i = 0; i < 6; ++i) {
            if (!BlockDuct.ConnectionTypes.values()[nArray[i]].renderDuct() || nArray[i] == BlockDuct.ConnectionTypes.CLEANDUCT.ordinal()) continue;
            n2 |= 1 << i;
            if (nArray[i] == BlockDuct.ConnectionTypes.DUCT.ordinal()) continue;
            cCModelArray[64 + i].render(d + 0.5, d2 + 0.5, d3 + 0.5, (UVTransformation)RenderUtils.getIconTransformation((IIcon)iIcon));
        }
        if (cCModelArray[n2].verts.length == 0) {
            return false;
        }
        cCModelArray[n2].render(d + 0.5, d2 + 0.5, d3 + 0.5, (UVTransformation)RenderUtils.getIconTransformation((IIcon)iIcon));
        return true;
    }

    public boolean renderWorldExtra(boolean bl, TileTDBase tileTDBase, int n, int[] nArray, double d, double d2, double d3) {
        int n2;
        int n3;
        Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
        Duct duct = TDDucts.ductList.get(n);
        IIcon iIcon = duct.iconFluidTexture;
        boolean bl2 = false;
        if (iIcon != null && duct.fluidTransparency != -1) {
            n3 = 0;
            for (n2 = 0; n2 < 6; ++n2) {
                if (!BlockDuct.ConnectionTypes.values()[nArray[n2]].renderDuct() || nArray[n2] == BlockDuct.ConnectionTypes.STRUCTURE.ordinal()) continue;
                n3 |= 1 << n2;
            }
            modelFluidTubes[n3].render(d + 0.5, d2 + 0.5, d3 + 0.5, (UVTransformation)RenderUtils.getIconTransformation((IIcon)iIcon));
            bl2 = true;
        }
        if (duct.frameType == 1 && duct.iconFrameFluidTexture != null) {
            boolean bl3 = bl2 = this.renderSideTubes(1, nArray, d, d2, d3, duct.iconFrameFluidTexture) || bl2;
        }
        if (duct.frameType == 2 && duct.iconFrameFluidTexture != null) {
            n3 = 0;
            for (n2 = 0; n2 < 6; ++n2) {
                if (!BlockDuct.ConnectionTypes.values()[nArray[n2]].renderDuct() || nArray[n2] == BlockDuct.ConnectionTypes.STRUCTURE.ordinal()) continue;
                n3 |= 1 << n2;
                if (!bl && nArray[n2] == BlockDuct.ConnectionTypes.DUCT.ordinal()) continue;
                modelFrame[70 + n2].render(d + 0.5, d2 + 0.5, d3 + 0.5, (UVTransformation)RenderUtils.getIconTransformation((IIcon)duct.iconFrameFluidTexture));
            }
            if (RenderDuct.modelFrame[n3].verts.length != 0) {
                modelFrame[n3].render(d + 0.5, d2 + 0.5, d3 + 0.5, (UVTransformation)RenderUtils.getIconTransformation((IIcon)duct.iconFrameFluidTexture));
                bl2 = true;
            }
        }
        return bl2;
    }

    public void renderFluid(FluidStack fluidStack, int[] nArray, int n, double d, double d2, double d3) {
        if (fluidStack == null || fluidStack.amount <= 0 || n <= 0) {
            return;
        }
        GL11.glBlendFunc((int)770, (int)771);
        CCRenderState.startDrawing();
        Fluid fluid = fluidStack.getFluid();
        RenderUtils.setFluidRenderColor((FluidStack)fluidStack);
        RenderHelper.bindTexture((ResourceLocation)RenderHelper.MC_BLOCK_SHEET);
        IIcon iIcon = RenderHelper.getFluidTexture((FluidStack)fluidStack);
        if (n > 6) {
            n = 6;
        }
        if (fluid.isGaseous(fluidStack)) {
            CCRenderState.setColour((int)(RenderUtils.getFluidRenderColor((FluidStack)fluidStack) << 8 | 32 + 36 * n));
            n = 6;
        }
        if (n != 6) {
            CCModel[] cCModelArray = modelFluid[n - 1];
            for (int i = 0; i < 6; ++i) {
                if (!BlockDuct.ConnectionTypes.values()[nArray[i]].renderDuct() || nArray[i] == BlockDuct.ConnectionTypes.STRUCTURE.ordinal()) continue;
                cCModelArray[i].render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)iIcon));
            }
            cCModelArray[6].render(d, d2, d3, (UVTransformation)RenderUtils.getIconTransformation((IIcon)iIcon));
        } else {
            int n2 = 0;
            for (int i = 0; i < 6; ++i) {
                if (!BlockDuct.ConnectionTypes.values()[nArray[i]].renderDuct() || nArray[i] == BlockDuct.ConnectionTypes.STRUCTURE.ordinal()) continue;
                n2 |= 1 << i;
            }
            modelFluidTubes[n2].render(d + 0.5, d2 + 0.5, d3 + 0.5, (UVTransformation)RenderUtils.getIconTransformation((IIcon)iIcon));
        }
        CCRenderState.draw();
    }

    public void getDuctConnections(TileTDBase tileTDBase) {
        for (int i = 0; i < 6; ++i) {
            RenderDuct.connections[i] = tileTDBase.getConnectionType(i).ordinal();
        }
    }

    public void renderInventoryBlock(Block block, int n, int n2, RenderBlocks renderBlocks) {
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (!(tileEntity instanceof TileTDBase)) {
            return false;
        }
        TileTDBase tileTDBase = (TileTDBase)tileEntity;
        RenderUtils.preWorldRender((IBlockAccess)iBlockAccess, (int)n, (int)n2, (int)n3);
        this.getDuctConnections(tileTDBase);
        boolean bl = false;
        for (Attachment attachment : tileTDBase.attachments) {
            if (attachment == null) continue;
            bl = attachment.render(BlockCoFHBase.renderPass, renderBlocks) || bl;
        }
        for (Attachment attachment : tileTDBase.covers) {
            if (attachment == null) continue;
            bl = ((Cover)attachment).render(BlockCoFHBase.renderPass, renderBlocks) || bl;
        }
        int n5 = TDDucts.getDuct((int)(((BlockDuct)block).offset + iBlockAccess.func_72805_g((int)n, (int)n2, (int)n3))).id;
        if (BlockCoFHBase.renderPass == 0) {
            this.renderBase(false, n5, connections, n, n2, n3, tileTDBase.getBaseIcon());
            bl = true;
        } else {
            bl = this.renderWorldExtra(false, tileTDBase, n5, connections, n, n2, n3) || bl;
        }
        bl = tileTDBase.renderAdditional(n5, connections, BlockCoFHBase.renderPass) || bl;
        return bl;
    }

    public boolean shouldRender3DInInventory(int n) {
        return true;
    }

    public int getRenderId() {
        return TDProps.renderDuctId;
    }

    public boolean handleRenderType(ItemStack itemStack, IItemRenderer.ItemRenderType itemRenderType) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, IItemRenderer.ItemRendererHelper itemRendererHelper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, Object ... objectArray) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        Duct duct = TDDucts.getDuct(((BlockDuct)block).offset + itemStack.func_77960_j());
        int n = duct.id;
        boolean bl = false;
        GL11.glPushMatrix();
        double d = -0.5;
        if (itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED || itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            d = 0.0;
        }
        RenderHelper.setBlockTextureSheet();
        RenderUtils.preItemRender();
        GL11.glDepthMask((boolean)true);
        CCRenderState.startDrawing();
        this.renderBase(true, n, INV_CONNECTIONS, d, d, d, duct.getBaseTexture(itemStack));
        CCRenderState.draw();
        GL11.glDepthMask((boolean)false);
        CCRenderState.startDrawing();
        this.renderWorldExtra(true, null, n, INV_CONNECTIONS, d, d - 9.765625E-4, d);
        CCRenderState.draw();
        GL11.glDepthMask((boolean)true);
        CCRenderState.useNormals = false;
        RenderHelper.setItemTextureSheet();
        RenderUtils.postItemRender();
        GL11.glPopMatrix();
    }

    static {
        servoTexture = new IIcon[10];
        retrieverTexture = new IIcon[10];
        filterTexture = new IIcon[5];
        modelFluid = new CCModel[6][7];
        modelConnection = new CCModel[3][6];
        modelLine = new CCModel[6];
        modelFrameConnection = new CCModel[64];
        modelFrame = new CCModel[64];
        smallInnerModelScaling = 0.99f;
        largeInnerModelScaling = 0.99f;
        TDProps.renderDuctId = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        RenderDuct.generateModels();
        RenderDuct.generateFluidModels();
    }
}

