/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.item;

import cofh.api.inventory.IInventoryConnection;
import cofh.api.transport.IItemDuct;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.repack.codechicken.lib.vec.BlockCoord;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.core.TickHandlerClient;
import cofh.thermaldynamics.debughelper.ErrorHelper;
import cofh.thermaldynamics.duct.DuctItem;
import cofh.thermaldynamics.duct.attachments.IStuffable;
import cofh.thermaldynamics.duct.attachments.filter.IFilterAttachment;
import cofh.thermaldynamics.duct.attachments.filter.IFilterItems;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.item.ItemGrid;
import cofh.thermaldynamics.duct.item.SimulatedInv;
import cofh.thermaldynamics.duct.item.StackMap;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.IMultiBlockRoute;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.multiblock.RouteCache;
import com.google.common.collect.Iterables;
import gnu.trove.iterator.TObjectIntIterator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileItemDuct
extends TileTDBase
implements IMultiBlockRoute,
IItemDuct {
    public ItemGrid internalGrid;
    public List<TravelingItem> myItems = new LinkedList<TravelingItem>();
    public List<TravelingItem> itemsToRemove = new LinkedList<TravelingItem>();
    public List<TravelingItem> itemsToAdd = new LinkedList<TravelingItem>();
    public byte pathWeightType = 0;
    static int[] _PIPE_LEN = new int[]{40, 10, 60, 40};
    static int[] _PIPE_HALF_LEN = new int[]{_PIPE_LEN[0] / 2, _PIPE_LEN[1] / 2, _PIPE_LEN[2] / 2, _PIPE_LEN[3] / 2};
    static float[] _PIPE_TICK_LEN = new float[]{1.0f / (float)_PIPE_LEN[0], 1.0f / (float)_PIPE_LEN[1], 1.0f / (float)_PIPE_LEN[2], 1.0f / (float)_PIPE_LEN[3]};
    static float[][][] _SIDE_MODS = new float[4][6][3];
    static int INSERT_SIZE = 8;
    public IFilterItems[] filterCache;
    public IInventory[] cache;
    public ISidedInventory[] cache2;
    public IDeepStorageUnit[] cache3;
    public CacheType[] cacheType;
    public static final RouteInfo noRoute;
    public byte ticksExisted = 0;
    public static final byte maxTicksExistedBeforeFindAlt = 2;
    public static final byte maxTicksExistedBeforeStuff = 6;
    public static final byte maxTicksExistedBeforeDump = 10;
    boolean wasVisited = false;
    public boolean hasChanged = false;
    public static final int maxCenterLine = 10;
    public int centerLine = 0;
    public int[] centerLineSub = new int[6];

    public ItemStack insertItem(ForgeDirection forgeDirection, ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (!(this.neighborTypes[forgeDirection.ordinal()] == TileTDBase.NeighborTypes.INPUT || this.neighborTypes[forgeDirection.ordinal()] == TileTDBase.NeighborTypes.OUTPUT && this.connectionTypes[forgeDirection.ordinal()].allowTransfer)) {
            return itemStack;
        }
        if (this.internalGrid == null) {
            return itemStack;
        }
        Attachment attachment = this.attachments[forgeDirection.ordinal()];
        if (attachment == null) {
            ItemStack itemStack2 = ItemHelper.cloneStack((ItemStack)itemStack);
            TravelingItem travelingItem = ServoItem.findRouteForItem(ItemHelper.cloneStack((ItemStack)itemStack, (int)Math.min(INSERT_SIZE, itemStack.field_77994_a)), this.getCache((boolean)false).outputRoutes, this, forgeDirection.ordinal(), ServoItem.range[0], (byte)1);
            if (travelingItem == null) {
                return itemStack;
            }
            itemStack2.field_77994_a -= travelingItem.stack.field_77994_a;
            this.insertNewItem(travelingItem);
            return itemStack2.field_77994_a > 0 ? itemStack2 : null;
        }
        if (attachment.getId() != 2) {
            return itemStack;
        }
        return ((ServoItem)attachment).insertItem(itemStack);
    }

    public Route getRoute(IMultiBlockRoute iMultiBlockRoute) {
        for (Route route : this.getCache().outputRoutes) {
            if (route.endPoint != iMultiBlockRoute && (route.endPoint.x() != iMultiBlockRoute.x() || route.endPoint.y() != iMultiBlockRoute.y() || route.endPoint.z() != iMultiBlockRoute.z())) continue;
            return route;
        }
        return null;
    }

    @Override
    public boolean isSignificantTile(TileEntity tileEntity, int n) {
        Object object;
        if (!(tileEntity instanceof IInventory)) {
            return false;
        }
        if (tileEntity instanceof IInventoryConnection) {
            object = ((IInventoryConnection)tileEntity).canConnectInventory(ForgeDirection.VALID_DIRECTIONS[n ^ 1]);
            if (object == IInventoryConnection.ConnectionType.DENY) {
                return false;
            }
            if (object == IInventoryConnection.ConnectionType.FORCE) {
                return true;
            }
        }
        if (((IInventory)tileEntity).func_70302_i_() == 0) {
            return false;
        }
        if (tileEntity instanceof ISidedInventory) {
            object = ((ISidedInventory)tileEntity).func_94128_d(n ^ 1);
            if (object == null) {
                ErrorHelper.reportProblemOnce(tileEntity.getClass().getName() + " - returns null from getAccessibleSlotsFromSide() with side=" + (n ^ 1));
                return false;
            }
            if (((IInventoryConnection.ConnectionType)object).length == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setGrid(MultiBlockGrid multiBlockGrid) {
        super.setGrid(multiBlockGrid);
        this.internalGrid = (ItemGrid)multiBlockGrid;
    }

    @Override
    public MultiBlockGrid getNewGrid() {
        return new ItemGrid(((TileEntity)this).field_145850_b);
    }

    @Override
    public boolean tickPass(int n) {
        if (!super.tickPass(n)) {
            return false;
        }
        if (n == 0) {
            if (this.ticksExisted < 10) {
                this.ticksExisted = (byte)(this.ticksExisted + 1);
            }
            this.tickItems();
        }
        return true;
    }

    @Override
    public int getWeight() {
        if (this.pathWeightType == 1) {
            return 1000;
        }
        if (this.pathWeightType == 2) {
            return -1000;
        }
        return this.getDuctType().pathWeight;
    }

    @Override
    public IIcon getBaseIcon() {
        if (this.pathWeightType == 1) {
            return ((DuctItem)this.getDuctType()).iconBaseTextureDense;
        }
        if (this.pathWeightType == 2) {
            return ((DuctItem)this.getDuctType()).iconBaseTextureVacuum;
        }
        return super.getBaseIcon();
    }

    @Override
    public boolean isOutput() {
        return this.isOutput;
    }

    @Override
    public boolean canStuffItem() {
        for (Attachment attachment : this.attachments) {
            if (!(attachment instanceof IStuffable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxRange() {
        return Integer.MAX_VALUE;
    }

    @Override
    public TileTDBase.NeighborTypes getCachedSideType(byte by) {
        return this.neighborTypes[by];
    }

    @Override
    public TileTDBase.ConnectionTypes getConnectionType(byte by) {
        return this.connectionTypes[by];
    }

    @Override
    public IMultiBlock getCachedTile(byte by) {
        return this.neighborMultiBlocks[by];
    }

    @Override
    public int x() {
        return ((TileEntity)this).field_145851_c;
    }

    @Override
    public int y() {
        return ((TileEntity)this).field_145848_d;
    }

    @Override
    public int z() {
        return ((TileEntity)this).field_145849_e;
    }

    public boolean shouldRenderInPass(int n) {
        return n == 0 && (!this.myItems.isEmpty() || !this.itemsToAdd.isEmpty() || this.centerLine > 0);
    }

    public RouteCache getCache() {
        return this.getCache(true);
    }

    public RouteCache getCache(boolean bl) {
        return bl ? this.internalGrid.getRoutesFromOutput(this) : this.internalGrid.getRoutesFromOutputNonUrgent(this);
    }

    public void pulseLineDo(int n) {
        if (!this.getDuctType().opaque) {
            PacketTileInfo packetTileInfo = PacketTileInfo.newPacket((TileEntity)this);
            packetTileInfo.addByte(0);
            packetTileInfo.addByte((byte)5);
            packetTileInfo.addByte(n);
            PacketHandler.sendToAllAround((PacketBase)packetTileInfo, (TileEntity)this);
        }
    }

    public void pulseLine(byte by) {
        this.pulseLineDo(1 << by);
    }

    public void pulseLine(byte by, byte by2) {
        this.pulseLineDo(1 << by | 1 << by2);
    }

    public void pulseLine() {
        this.pulseLineDo(63);
    }

    public int getPipeLength() {
        return _PIPE_LEN[this.getDuctType().type];
    }

    public int getPipeHalfLength() {
        return _PIPE_HALF_LEN[this.getDuctType().type];
    }

    public float[][] getSideCoordsModifier() {
        return _SIDE_MODS[this.getDuctType().type];
    }

    public void stuffItem(TravelingItem travelingItem) {
        Attachment attachment = this.attachments[travelingItem.direction];
        if (attachment instanceof IStuffable) {
            this.signalRepoll();
            ((IStuffable)((Object)attachment)).stuffItem(travelingItem.stack);
        }
    }

    public boolean acceptingItems() {
        return true;
    }

    public void insertNewItem(TravelingItem travelingItem) {
        this.internalGrid.poll(travelingItem);
        this.transferItem(travelingItem);
    }

    public void transferItem(TravelingItem travelingItem) {
        this.itemsToAdd.add(travelingItem);
    }

    public void tickItems() {
        if (this.itemsToAdd.size() > 0) {
            this.myItems.addAll(this.itemsToAdd);
            this.itemsToAdd.clear();
            this.hasChanged = true;
        }
        if (this.myItems.size() > 0) {
            for (TravelingItem travelingItem : this.myItems) {
                travelingItem.tickForward(this);
                if (!this.internalGrid.repoll) continue;
                this.internalGrid.poll(travelingItem);
            }
            if (this.itemsToRemove.size() > 0) {
                this.myItems.removeAll(this.itemsToRemove);
                this.itemsToRemove.clear();
                this.hasChanged = true;
            }
        }
        if (this.hasChanged) {
            this.sendTravelingItemsPacket();
            this.hasChanged = false;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.itemsToAdd.clear();
        this.myItems.clear();
        if (nBTTagCompound.func_150297_b("TravellingItems", 9)) {
            NBTTagList nBTTagList = nBTTagCompound.func_150295_c("TravellingItems", 10);
            for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
                this.myItems.add(new TravelingItem(nBTTagCompound2));
            }
        }
        this.pathWeightType = nBTTagCompound.func_74771_c("Weight");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        NBTTagList nBTTagList = new NBTTagList();
        for (TravelingItem travelingItem : Iterables.concat(this.itemsToAdd, this.myItems)) {
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            travelingItem.toNBT(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        if (nBTTagList.func_74745_c() > 0) {
            nBTTagCompound.func_74782_a("TravellingItems", (NBTBase)nBTTagList);
        }
        if (this.pathWeightType != 0) {
            nBTTagCompound.func_74774_a("Weight", this.pathWeightType);
        }
    }

    public void sendTravelingItemsPacket() {
        if (!this.getDuctType().opaque) {
            PacketTileInfo packetTileInfo = PacketTileInfo.newPacket((TileEntity)this);
            packetTileInfo.addByte(0);
            packetTileInfo.addByte((byte)2);
            int n = this.myItems.size();
            n = Math.min(n, 6);
            packetTileInfo.addByte(n);
            for (int i = 0; i < n; ++i) {
                this.myItems.get(i).writePacket((PacketCoFHBase)packetTileInfo);
            }
            PacketHandler.sendToAllAround((PacketBase)packetTileInfo, (TileEntity)this);
        }
    }

    @Override
    public void handleInfoPacket(PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
        byte by = packetCoFHBase.getByte();
        this.handlePacketType(packetCoFHBase, by);
    }

    @Override
    public boolean cachesExist() {
        return this.cache != null;
    }

    @Override
    public void createCaches() {
        this.filterCache = new IFilterItems[]{IFilterItems.nullFilter, IFilterItems.nullFilter, IFilterItems.nullFilter, IFilterItems.nullFilter, IFilterItems.nullFilter, IFilterItems.nullFilter};
        this.cache = new IInventory[6];
        this.cache2 = new ISidedInventory[6];
        this.cache3 = new IDeepStorageUnit[6];
        this.cacheType = new CacheType[]{CacheType.NONE, CacheType.NONE, CacheType.NONE, CacheType.NONE, CacheType.NONE, CacheType.NONE};
    }

    public void handlePacketType(PacketCoFHBase packetCoFHBase, int n) {
        if (n == 5) {
            byte by = packetCoFHBase.getByte();
            for (int i = 0; i < 6; ++i) {
                if ((by & 1 << i) == 0) continue;
                this.centerLineSub[i] = 10;
            }
            this.centerLine = 10;
            if (!TickHandlerClient.tickBlocks.contains(this) && !TickHandlerClient.tickBlocksToAdd.contains(this)) {
                TickHandlerClient.tickBlocksToAdd.add(this);
            }
        } else if (n == 2) {
            this.myItems.clear();
            byte by = packetCoFHBase.getByte();
            if (by > 0) {
                for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                    this.myItems.add(TravelingItem.fromPacket(packetCoFHBase, this));
                }
                if (!TickHandlerClient.tickBlocks.contains(this) && !TickHandlerClient.tickBlocksToAdd.contains(this)) {
                    TickHandlerClient.tickBlocksToAdd.add(this);
                }
            }
        }
    }

    @Override
    public void cacheImportant(TileEntity tileEntity, int n) {
        this.cache[n] = (IInventory)tileEntity;
        if (tileEntity instanceof IDeepStorageUnit) {
            this.cache3[n] = (IDeepStorageUnit)tileEntity;
        }
        if (tileEntity instanceof ISidedInventory) {
            this.cache2[n] = (ISidedInventory)tileEntity;
            this.cacheType[n] = CacheType.ISIDEDINV;
        } else {
            this.cacheType[n] = CacheType.IINV;
        }
        if (this.attachments[n] instanceof IFilterAttachment) {
            this.filterCache[n] = ((IFilterAttachment)((Object)this.attachments[n])).getItemFilter();
        }
    }

    @Override
    public void clearCache(int n) {
        this.filterCache[n] = IFilterItems.nullFilter;
        this.cache[n] = null;
        this.cache2[n] = null;
        this.cache3[n] = null;
        this.cacheType[n] = CacheType.NONE;
    }

    public void removeItem(TravelingItem travelingItem, boolean bl) {
        if (bl) {
            this.signalRepoll();
        }
        this.itemsToRemove.add(travelingItem);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte(this.pathWeightType);
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.pathWeightType = packetCoFHBase.getByte();
        }
    }

    @Override
    public void onPlacedBy(EntityLivingBase entityLivingBase, ItemStack itemStack) {
        byte by;
        super.onPlacedBy(entityLivingBase, itemStack);
        if (itemStack.func_77942_o() && ((by = itemStack.func_77978_p().func_74771_c("DenseType")) == 1 || by == 2)) {
            this.pathWeightType = by;
        }
        this.ticksExisted = (byte)10;
    }

    @Override
    public void dropAdditional(ArrayList<ItemStack> arrayList) {
        for (TravelingItem travelingItem : Iterables.concat(this.myItems, this.itemsToAdd)) {
            arrayList.add(travelingItem.stack);
        }
        super.dropAdditional(arrayList);
    }

    @Override
    public ItemStack getDrop() {
        ItemStack itemStack = super.getDrop();
        if (this.pathWeightType != 0) {
            if (itemStack.field_77990_d == null) {
                itemStack.field_77990_d = new NBTTagCompound();
            }
            itemStack.field_77990_d.func_74774_a("DenseType", this.pathWeightType);
        }
        return itemStack;
    }

    public void tickItemsClient() {
        int n;
        if (this.centerLine > 0) {
            --this.centerLine;
            for (n = 0; n < 6; ++n) {
                if (this.centerLineSub[n] <= 0) continue;
                int n2 = n;
                this.centerLineSub[n2] = this.centerLineSub[n2] - 1;
            }
        }
        if (this.itemsToAdd.size() > 0) {
            this.myItems.addAll(this.itemsToAdd);
            this.itemsToAdd.clear();
        }
        if (this.myItems.size() > 0) {
            for (n = 0; n < this.myItems.size(); ++n) {
                this.myItems.get(n).tickClientForward(this);
            }
            if (this.itemsToRemove.size() > 0) {
                this.myItems.removeAll(this.itemsToRemove);
                this.itemsToRemove.clear();
            }
        } else if (this.centerLine == 0) {
            TickHandlerClient.tickBlocksToRemove.add(this);
        }
    }

    @Override
    public boolean isConnectable(TileEntity tileEntity, int n) {
        return tileEntity instanceof TileItemDuct;
    }

    @Override
    public RouteInfo canRouteItem(ItemStack itemStack) {
        int n;
        ItemStack itemStack2;
        byte by;
        if (this.internalGrid == null || !this.cachesExist()) {
            return noRoute;
        }
        for (by = this.internalSideCounter; by < ForgeDirection.VALID_DIRECTIONS.length; by = (byte)(by + 1)) {
            if (this.neighborTypes[by] != TileTDBase.NeighborTypes.OUTPUT || !this.connectionTypes[by].allowTransfer || !this.itemPassesFiltering(by, itemStack) || this.cache[by] == null) continue;
            itemStack2 = itemStack.func_77946_l();
            itemStack2.field_77994_a = Math.min(this.getMoveStackSize(by), itemStack2.field_77994_a);
            if (itemStack2.field_77994_a <= 0) continue;
            n = this.simTransferI(by, itemStack2.func_77946_l());
            if ((n = itemStack.field_77994_a - itemStack2.field_77994_a + n) >= itemStack.field_77994_a) continue;
            this.tickInternalSideCounter(by + 1);
            return new RouteInfo(n, by);
        }
        for (by = 0; by < this.internalSideCounter; by = (byte)(by + 1)) {
            if (this.neighborTypes[by] != TileTDBase.NeighborTypes.OUTPUT || !this.connectionTypes[by].allowTransfer || !this.itemPassesFiltering(by, itemStack) || this.cache[by] == null) continue;
            itemStack2 = itemStack.func_77946_l();
            itemStack2.field_77994_a = Math.min(this.getMoveStackSize(by), itemStack2.field_77994_a);
            if (itemStack2.field_77994_a <= 0) continue;
            n = this.simTransferI(by, itemStack2.func_77946_l());
            if ((n = itemStack.field_77994_a - itemStack2.field_77994_a + n) >= itemStack.field_77994_a) continue;
            this.tickInternalSideCounter(by + 1);
            return new RouteInfo(n, by);
        }
        return noRoute;
    }

    public int simTransferI(int n, ItemStack itemStack) {
        ItemStack itemStack2 = this.simTransfer(n, itemStack);
        return itemStack2 == null ? 0 : itemStack2.field_77994_a;
    }

    public ItemStack simTransfer(int n, ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (this.internalGrid == null || !this.cachesExist()) {
            return itemStack;
        }
        boolean bl = this.filterCache[n].shouldIncRouteItems();
        int n2 = this.filterCache[n].getMaxStock();
        if (this.cache3[n] != null) {
            StackMap stackMap;
            int n3;
            ItemStack itemStack2 = this.cache3[n].getStoredItemType();
            if (itemStack2 != null && !ItemHelper.itemsIdentical((ItemStack)itemStack2, (ItemStack)itemStack)) {
                return itemStack;
            }
            int n4 = itemStack2 != null ? itemStack2.field_77994_a : 0;
            if (n4 >= (n3 = Math.min(this.cache3[n].getMaxStoredCount(), n2))) {
                return itemStack;
            }
            if (bl && (stackMap = this.internalGrid.travelingItems.get(new BlockCoord((TileEntity)this).offset(n))) != null && !stackMap.isEmpty()) {
                StackMap.IteratorItemstack iteratorItemstack = stackMap.getItems();
                while (n4 < n3 && iteratorItemstack.hasNext()) {
                    ItemStack itemStack3 = (ItemStack)iteratorItemstack.next();
                    boolean bl2 = ItemHelper.itemsIdentical((ItemStack)itemStack, (ItemStack)itemStack3);
                    if (itemStack2 == null && !bl2) {
                        return itemStack;
                    }
                    if (!bl2) continue;
                    n4 += itemStack3.field_77994_a;
                }
                if (n4 >= n3) {
                    return itemStack;
                }
            }
            itemStack.field_77994_a -= n3 - n4;
            if (itemStack.field_77994_a <= 0) {
                return null;
            }
            return itemStack;
        }
        if (!bl) {
            return TileItemDuct.simulateInsertItemStackIntoInventory(this.cache[n], itemStack, n ^ 1, n2);
        }
        StackMap stackMap = this.internalGrid.travelingItems.get(new BlockCoord((TileEntity)this).offset(n));
        if (stackMap == null || stackMap.isEmpty()) {
            return TileItemDuct.simulateInsertItemStackIntoInventory(this.cache[n], itemStack, n ^ 1, n2);
        }
        if (stackMap.size() == 1) {
            if (ItemHelper.itemsIdentical((ItemStack)itemStack, (ItemStack)stackMap.getItems().next())) {
                itemStack.field_77994_a += stackMap.getItems().next().field_77994_a;
                return TileItemDuct.simulateInsertItemStackIntoInventory(this.cache[n], itemStack, n ^ 1, n2);
            }
        } else {
            int n5 = 0;
            for (ItemStack itemStack4 : stackMap.getItems()) {
                if (!ItemHelper.itemsIdentical((ItemStack)itemStack, (ItemStack)itemStack4)) {
                    n5 = -1;
                    break;
                }
                n5 += itemStack4.field_77994_a;
            }
            if (n5 >= 0) {
                itemStack.field_77994_a += n5;
                return TileItemDuct.simulateInsertItemStackIntoInventory(this.cache[n], itemStack, n ^ 1, n2);
            }
        }
        SimulatedInv simulatedInv = this.cacheType[n] == CacheType.ISIDEDINV ? SimulatedInv.wrapInvSided(this.cache2[n]) : SimulatedInv.wrapInv(this.cache[n]);
        TObjectIntIterator tObjectIntIterator = stackMap.iterator();
        while (tObjectIntIterator.hasNext()) {
            tObjectIntIterator.advance();
            if (InventoryHelper.insertItemStackIntoInventory((IInventory)simulatedInv, (ItemStack)((StackMap.ItemEntry)tObjectIntIterator.key()).toItemStack(tObjectIntIterator.value()), (int)(((StackMap.ItemEntry)tObjectIntIterator.key()).side ^ 1)) == null || !ItemHelper.itemsIdentical((ItemStack)itemStack, (ItemStack)((StackMap.ItemEntry)tObjectIntIterator.key()).toItemStack(tObjectIntIterator.value()))) continue;
            return itemStack;
        }
        itemStack = TileItemDuct.simulateInsertItemStackIntoInventory(simulatedInv, itemStack, n ^ 1, n2);
        simulatedInv.clear();
        return itemStack;
    }

    @Override
    public byte getStuffedSide() {
        byte by;
        for (by = 0; by < 6; by = (byte)((byte)(by + 1))) {
            if (!(this.attachments[by] instanceof IStuffable) || !((IStuffable)((Object)this.attachments[by])).canStuff()) continue;
            return by;
        }
        for (by = 0; by < 6; by = (byte)(by + 1)) {
            if (!(this.attachments[by] instanceof IStuffable)) continue;
            return by;
        }
        throw new RuntimeException("IStuffable disappeared during calculation!");
    }

    @Override
    public boolean acceptingStuff() {
        for (int n = 0; n < 6; n = (int)((byte)(n + 1))) {
            if (!(this.attachments[n] instanceof IStuffable)) continue;
            return ((IStuffable)((Object)this.attachments[n])).canStuff();
        }
        return false;
    }

    private boolean stuffed() {
        return false;
    }

    private boolean itemPassesFiltering(byte by, ItemStack itemStack) {
        return this.filterCache[by].matchesFilter(itemStack);
    }

    public int getMoveStackSize(byte by) {
        return 64;
    }

    public int insertIntoInventory(ItemStack itemStack, int n) {
        if (!this.cachesExist() || this.cache[n] == null) {
            return itemStack.field_77994_a;
        }
        if (!this.filterCache[n].matchesFilter(itemStack)) {
            return itemStack.field_77994_a;
        }
        return this.insertIntoInventory_do(itemStack, n);
    }

    public void signalRepoll() {
        if (this.internalGrid != null) {
            this.internalGrid.shouldRepoll = true;
        }
    }

    public int insertIntoInventory_do(ItemStack itemStack, int n) {
        this.signalRepoll();
        itemStack = TileItemDuct.insertItemStackIntoInventory(this.cache[n], itemStack, n ^ 1, this.filterCache[n].getMaxStock());
        return itemStack == null ? 0 : itemStack.field_77994_a;
    }

    public static int getNumItems(IInventory iInventory, int n, ItemStack itemStack, int n2) {
        if (iInventory instanceof IDeepStorageUnit) {
            ItemStack itemStack2 = ((IDeepStorageUnit)iInventory).getStoredItemType();
            if (ItemHelper.itemsIdentical((ItemStack)itemStack2, (ItemStack)itemStack)) {
                return itemStack2.field_77994_a;
            }
            return 0;
        }
        int n3 = 0;
        if (iInventory instanceof ISidedInventory) {
            ISidedInventory iSidedInventory = (ISidedInventory)iInventory;
            for (int n4 : iSidedInventory.func_94128_d(n)) {
                ItemStack itemStack3 = iSidedInventory.func_70301_a(n4);
                if (!ItemHelper.itemsIdentical((ItemStack)itemStack3, (ItemStack)itemStack) || (n3 += itemStack3.field_77994_a) < n2) continue;
                return n3;
            }
            return n3;
        }
        for (int i = 0; i < iInventory.func_70302_i_(); ++i) {
            ItemStack itemStack4 = iInventory.func_70301_a(i);
            if (!ItemHelper.itemsIdentical((ItemStack)itemStack4, (ItemStack)itemStack) || (n3 += itemStack4.field_77994_a) < n2) continue;
            return n3;
        }
        return n3;
    }

    public static ItemStack insertItemStackIntoInventory(IInventory iInventory, ItemStack itemStack, int n, int n2) {
        if (n2 < 0 || n2 == Integer.MAX_VALUE) {
            return InventoryHelper.insertItemStackIntoInventory((IInventory)iInventory, (ItemStack)itemStack, (int)n);
        }
        int n3 = n2 - TileItemDuct.getNumItems(iInventory, n, itemStack, n2);
        if (n3 <= 0) {
            return itemStack;
        }
        if (itemStack.field_77994_a < n3) {
            return InventoryHelper.insertItemStackIntoInventory((IInventory)iInventory, (ItemStack)itemStack, (int)n);
        }
        ItemStack itemStack2 = InventoryHelper.insertItemStackIntoInventory((IInventory)iInventory, (ItemStack)itemStack.func_77979_a(n3), (int)n);
        if (itemStack2 != null) {
            itemStack.field_77994_a += itemStack2.field_77994_a;
        }
        return itemStack;
    }

    public static ItemStack simulateInsertItemStackIntoInventory(IInventory iInventory, ItemStack itemStack, int n, int n2) {
        if (n2 < 0 || n2 == Integer.MAX_VALUE) {
            return InventoryHelper.simulateInsertItemStackIntoInventory((IInventory)iInventory, (ItemStack)itemStack, (int)n);
        }
        int n3 = n2 - TileItemDuct.getNumItems(iInventory, n, itemStack, n2);
        if (n3 <= 0) {
            return itemStack;
        }
        if (itemStack.field_77994_a <= n3) {
            return InventoryHelper.simulateInsertItemStackIntoInventory((IInventory)iInventory, (ItemStack)itemStack, (int)n);
        }
        ItemStack itemStack2 = InventoryHelper.simulateInsertItemStackIntoInventory((IInventory)iInventory, (ItemStack)itemStack.func_77979_a(n3), (int)n);
        if (itemStack2 != null) {
            itemStack.field_77994_a += itemStack2.field_77994_a;
        }
        return itemStack;
    }

    static {
        for (int i = 0; i < 4; ++i) {
            float f = _PIPE_TICK_LEN[i];
            TileItemDuct._SIDE_MODS[i][0] = new float[]{0.0f, -f, 0.0f};
            TileItemDuct._SIDE_MODS[i][1] = new float[]{0.0f, f, 0.0f};
            TileItemDuct._SIDE_MODS[i][2] = new float[]{0.0f, 0.0f, -f};
            TileItemDuct._SIDE_MODS[i][3] = new float[]{0.0f, 0.0f, f};
            TileItemDuct._SIDE_MODS[i][4] = new float[]{-f, 0.0f, 0.0f};
            TileItemDuct._SIDE_MODS[i][5] = new float[]{f, 0.0f, 0.0f};
        }
        noRoute = new RouteInfo();
    }

    public class TileInfoPackets {
        public static final byte GUI_BUTTON = 0;
        public static final byte STUFFED_UPDATE = 1;
        public static final byte TRAVELING_ITEMS = 2;
        public static final byte STUFFED_ITEMS = 3;
        public static final byte REQUEST_STUFFED_ITEMS = 4;
        public static final byte PULSE_LINE = 5;
        public static final byte ENDER_POWER = 6;
    }

    public static class RouteInfo {
        public boolean canRoute = false;
        public int stackSize = -1;
        public byte side = (byte)-1;

        public RouteInfo(int n, byte by) {
            this.canRoute = true;
            this.stackSize = n;
            this.side = by;
        }

        public RouteInfo() {
        }
    }

    public static enum CacheType {
        NONE,
        IINV,
        ISIDEDINV;

    }
}

