/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct;

import cofh.core.item.ItemBlockBase;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.DuctItem;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.energy.EnergyGrid;
import cofh.thermaldynamics.duct.energy.subgrid.SubTileEnergyRedstone;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;

public class ItemBlockDuct
extends ItemBlockBase {
    int offset;

    public ItemBlockDuct(Block block) {
        super(block);
        this.offset = ((BlockDuct)block).offset;
    }

    public String func_77667_c(ItemStack itemStack) {
        return TDDucts.isValid(this.id(itemStack)) ? "tile.thermaldynamics.duct." + TDDucts.getType((int)this.id((ItemStack)itemStack)).unlocalizedName + ".name" : super.func_77667_c(itemStack);
    }

    public String func_77653_i(ItemStack itemStack) {
        if (TDDucts.isValid(this.id(itemStack))) {
            StringBuilder stringBuilder = new StringBuilder();
            Duct duct = TDDucts.getType(this.id(itemStack));
            if (duct instanceof DuctItem && itemStack.field_77990_d != null) {
                if (itemStack.field_77990_d.func_74771_c("DenseType") == 1) {
                    stringBuilder.append(StringHelper.localize((String)"tile.thermaldynamics.duct.dense.name")).append(" ");
                } else if (itemStack.field_77990_d.func_74771_c("DenseType") == 2) {
                    stringBuilder.append(StringHelper.localize((String)"tile.thermaldynamics.duct.vacuum.name")).append(" ");
                }
            }
            stringBuilder.append(super.func_77653_i(itemStack));
            if (duct.opaque) {
                stringBuilder.append(" ").append(StringHelper.localize((String)"tile.thermaldynamics.duct.opaque.name"));
            }
            return stringBuilder.toString();
        }
        return super.func_77653_i(itemStack);
    }

    public int id(ItemStack itemStack) {
        return this.offset + itemStack.func_77960_j();
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        int n = this.id(itemStack);
        if (TDDucts.isValid(n)) {
            return TDDucts.getType((int)n).rarity;
        }
        return EnumRarity.uncommon;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        super.func_77624_a(itemStack, entityPlayer, list, bl);
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            if (ItemHelper.itemsIdentical((ItemStack)itemStack, (ItemStack)TDDucts.structure.itemStack)) {
                list.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.cover"));
            }
            return;
        }
        int n = this.id(itemStack);
        if (!TDDucts.isValid(n)) {
            return;
        }
        Duct duct = TDDucts.getType(n);
        switch (duct.ductType) {
            case ENERGY: {
                list.add(StringHelper.localize((String)"info.thermaldynamics.duct.energy"));
                if (duct != TDDucts.energySuperCond) {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.transfer") + ": " + "\u00a7e" + EnergyGrid.NODE_TRANSFER[duct.type] + "\u00a77" + " RF/t.");
                } else {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.transfer") + ": " + "\u00a7b" + StringHelper.localize((String)"info.cofh.infinite") + "\u00a77" + " RF/t.");
                    list.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.energySupercond.info"));
                }
                list.add(StringHelper.getNoticeText((String)"info.thermaldynamics.transferConnection"));
                break;
            }
            case FLUID: {
                list.add(StringHelper.localize((String)"info.thermaldynamics.duct.fluid"));
                if (duct.type != 3) {
                    list.add(StringHelper.getNoticeText((String)"info.thermaldynamics.transferFluid"));
                }
                if (duct.type == 0) {
                    list.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.fluidBasic.info"));
                    break;
                }
                if (duct.type == 1) {
                    list.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.fluidHardened.info"));
                    break;
                }
                if (duct.type == 2) {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.duct.energy"));
                    list.add(StringHelper.localize((String)"info.thermaldynamics.transfer") + ": " + "\u00a7e" + SubTileEnergyRedstone.NODE_TRANSFER + "\u00a77" + " RF/t.");
                    break;
                }
                if (duct.type != 3) break;
                list.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.fluidSuper.info"));
                break;
            }
            case ITEM: {
                list.add(StringHelper.localize((String)"info.thermaldynamics.duct.item"));
                if (duct.type != 0) {
                    if (duct.type == 1) {
                        list.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.itemFast.info"));
                    } else if (duct.type == 2) {
                        list.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.itemEnder.info"));
                    } else if (duct.type == 3) {
                        list.add(StringHelper.localize((String)"info.thermaldynamics.duct.energy"));
                        list.add(StringHelper.localize((String)"info.thermaldynamics.transfer") + ": " + "\u00a7e" + SubTileEnergyRedstone.NODE_TRANSFER + "\u00a77" + " RF/t.");
                        list.add(StringHelper.getNoticeText((String)"info.thermaldynamics.transferConnection"));
                    }
                }
                if (!itemStack.func_77942_o()) break;
                byte by = itemStack.field_77990_d.func_74771_c("DenseType");
                if (by == 1) {
                    list.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.dense"));
                    break;
                }
                if (by != 2) break;
                list.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.vacuum"));
                break;
            }
            case STRUCTURAL: {
                if (duct == TDDucts.structure) {
                    list.add(StringHelper.localize((String)"info.thermaldynamics.duct.structure"));
                    list.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.cover"));
                    break;
                }
                if (duct != TDDucts.lightDuct) break;
                list.add(StringHelper.localize((String)"info.thermaldynamics.duct.structure"));
                list.add(StringHelper.localize((String)"info.thermaldynamics.duct.light"));
                break;
            }
            case CRAFTING: {
                list.add(StringHelper.localize((String)"info.thermaldynamics.duct.crafting"));
                break;
            }
        }
    }
}

