/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct;

import cofh.api.block.IBlockAppearance;
import cofh.api.core.IInitializer;
import cofh.core.block.BlockCoFHBase;
import cofh.core.block.TileCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.render.hitbox.CustomHitBox;
import cofh.core.render.hitbox.ICustomHitBox;
import cofh.core.render.hitbox.RenderHitbox;
import cofh.core.util.CoreUtils;
import cofh.repack.codechicken.lib.raytracer.RayTracer;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.BlockTDBase;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.core.TDProps;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.ItemBlockDuct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.TileStructuralDuct;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.energy.EnergyGrid;
import cofh.thermaldynamics.duct.energy.TileEnergyDuct;
import cofh.thermaldynamics.duct.energy.TileEnergyDuctSuper;
import cofh.thermaldynamics.duct.energy.subgrid.SubTileEnergyRedstone;
import cofh.thermaldynamics.duct.fluid.TileFluidDuct;
import cofh.thermaldynamics.duct.fluid.TileFluidDuctFlux;
import cofh.thermaldynamics.duct.fluid.TileFluidDuctFragile;
import cofh.thermaldynamics.duct.fluid.TileFluidDuctSuper;
import cofh.thermaldynamics.duct.item.TileItemDuct;
import cofh.thermaldynamics.duct.item.TileItemDuctEnder;
import cofh.thermaldynamics.duct.item.TileItemDuctFlux;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDuct
extends BlockTDBase
implements IInitializer,
IBlockAppearance {
    public int offset;

    public BlockDuct(int n) {
        super(Material.field_151592_s);
        this.func_149711_c(1.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c("thermaldynamics.duct");
        this.func_149647_a(ThermalDynamics.tab);
        this.offset = n * 16;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < 16; ++i) {
            if (!TDDucts.isValid(i + this.offset)) continue;
            list.add(TDDucts.getDuct((int)(i + this.offset)).itemStack.func_77946_l());
        }
    }

    public boolean hasTileEntity(int n) {
        return TDDucts.isValid(n + this.offset);
    }

    @Override
    public TileEntity func_149915_a(World world, int n) {
        Duct duct = TDDucts.getType(n + this.offset);
        return duct.factory.createTileEntity(duct, world);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int n, int n2) {
        return TDDucts.getType((int)(n2 + this.offset)).iconBaseTexture;
    }

    public int func_149692_a(int n) {
        return n;
    }

    public boolean canCreatureSpawn(EnumCreatureType enumCreatureType, IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent drawBlockHighlightEvent) {
        if (drawBlockHighlightEvent.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && drawBlockHighlightEvent.player.field_70170_p.func_147439_a(drawBlockHighlightEvent.target.field_72311_b, drawBlockHighlightEvent.target.field_72312_c, drawBlockHighlightEvent.target.field_72309_d).func_149739_a().equals(this.func_149739_a())) {
            RayTracer.retraceBlock((World)drawBlockHighlightEvent.player.field_70170_p, (EntityPlayer)drawBlockHighlightEvent.player, (int)drawBlockHighlightEvent.target.field_72311_b, (int)drawBlockHighlightEvent.target.field_72312_c, (int)drawBlockHighlightEvent.target.field_72309_d);
            ICustomHitBox iCustomHitBox = (ICustomHitBox)drawBlockHighlightEvent.player.field_70170_p.func_147438_o(drawBlockHighlightEvent.target.field_72311_b, drawBlockHighlightEvent.target.field_72312_c, drawBlockHighlightEvent.target.field_72309_d);
            if (iCustomHitBox.shouldRenderCustomHitBox(drawBlockHighlightEvent.target.subHit, drawBlockHighlightEvent.player)) {
                drawBlockHighlightEvent.setCanceled(true);
                RenderHitbox.drawSelectionBox((EntityPlayer)drawBlockHighlightEvent.player, (MovingObjectPosition)drawBlockHighlightEvent.target, (float)drawBlockHighlightEvent.partialTicks, (CustomHitBox)iCustomHitBox.getCustomHitBox(drawBlockHighlightEvent.target.subHit, drawBlockHighlightEvent.player));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        int n;
        if (this.offset != 0) {
            return;
        }
        for (n = 0; n < 5; ++n) {
            for (int i = 0; i < 2; ++i) {
                IconRegistry.addIcon((String)("ServoBase" + (n * 2 + i)), (String)("thermaldynamics:duct/attachment/servo/ServoBase" + n + "" + i), (IIconRegister)iIconRegister);
                IconRegistry.addIcon((String)("RetrieverBase" + (n * 2 + i)), (String)("thermaldynamics:duct/attachment/retriever/RetrieverBase" + n + "" + i), (IIconRegister)iIconRegister);
            }
        }
        IconRegistry.addIcon((String)"Signaller", (String)"thermaldynamics:duct/attachment/signallers/Signaller", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"CoverBase", (String)"thermaldynamics:duct/attachment/cover/support", (IIconRegister)iIconRegister);
        for (n = 0; n < 5; ++n) {
            IconRegistry.addIcon((String)("FilterBase" + n), (String)("thermaldynamics:duct/attachment/filter/Filter" + n + "0"), (IIconRegister)iIconRegister);
        }
        IconRegistry.addIcon((String)"SideDucts", (String)"thermaldynamics:duct/sideDucts", (IIconRegister)iIconRegister);
        for (n = 0; n < TDDucts.ductList.size(); ++n) {
            if (!TDDucts.isValid(n)) continue;
            TDDucts.ductList.get(n).registerIcons(iIconRegister);
        }
        TDDucts.structureInvis.registerIcons(iIconRegister);
    }

    public ItemStack getPickBlock(MovingObjectPosition movingObjectPosition, World world, int n, int n2, int n3) {
        ItemStack itemStack;
        TileTDBase tileTDBase;
        if (movingObjectPosition.subHit >= 14 && movingObjectPosition.subHit < 20) {
            tileTDBase = (TileTDBase)world.func_147438_o(n, n2, n3);
            itemStack = tileTDBase.attachments[movingObjectPosition.subHit - 14].getPickBlock();
            if (itemStack != null) {
                return itemStack;
            }
        }
        if (movingObjectPosition.subHit >= 20 && movingObjectPosition.subHit < 26) {
            tileTDBase = (TileTDBase)world.func_147438_o(n, n2, n3);
            itemStack = tileTDBase.covers[movingObjectPosition.subHit - 20].getPickBlock();
            if (itemStack != null) {
                return itemStack;
            }
        }
        return super.getPickBlock(movingObjectPosition, world, n, n2, n3);
    }

    public int func_149645_b() {
        return TDProps.renderDuctId;
    }

    public boolean canRenderInPass(int n) {
        BlockCoFHBase.renderPass = n;
        return n < 2;
    }

    public int func_149701_w() {
        return 1;
    }

    public Block getVisualBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        Cover cover;
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileTDBase && (cover = ((TileTDBase)tileEntity).covers[forgeDirection.ordinal()]) != null) {
            return cover.block;
        }
        return this;
    }

    public int getVisualMeta(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        Cover cover;
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileTDBase && (cover = ((TileTDBase)tileEntity).covers[forgeDirection.ordinal()]) != null) {
            return cover.meta;
        }
        return iBlockAccess.func_72805_g(n, n2, n3);
    }

    public boolean supportsVisualConnections() {
        return true;
    }

    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileTDBase) {
            ((TileTDBase)tileEntity).onPlacedBy(entityLivingBase, itemStack);
        }
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound, World world, int n, int n2, int n3, boolean bl, boolean bl2) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        int n4 = world.func_72805_g(n, n2, n3);
        ItemStack itemStack = tileEntity instanceof TileTDBase ? ((TileTDBase)tileEntity).getDrop() : new ItemStack((Block)this, 1, n4);
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        arrayList.add(itemStack);
        if (tileEntity instanceof TileTDBase) {
            TileTDBase tileTDBase = (TileTDBase)tileEntity;
            for (Attachment object : tileTDBase.attachments) {
                if (object == null) continue;
                arrayList.addAll(object.getDrops());
            }
            for (Cover cover : tileTDBase.covers) {
                if (cover == null) continue;
                arrayList.addAll(cover.getDrops());
            }
            tileTDBase.dropAdditional(arrayList);
        }
        if (nBTTagCompound != null) {
            itemStack.func_77982_d(nBTTagCompound);
        }
        if (!bl2) {
            if (tileEntity instanceof TileCoFHBase) {
                ((TileCoFHBase)tileEntity).blockDismantled();
            }
            world.func_147468_f(n, n2, n3);
            if (!bl) {
                float f = 0.3f;
                for (ItemStack itemStack2 : arrayList) {
                    double d = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d3 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityItem = new EntityItem(world, (double)n + d, (double)n2 + d2, (double)n3 + d3, itemStack2);
                    entityItem.field_145804_b = 10;
                    world.func_72838_d((Entity)entityItem);
                }
                if (entityPlayer != null) {
                    CoreUtils.dismantleLog((String)entityPlayer.func_70005_c_(), (Block)this, (int)n4, (double)n, (double)n2, (double)n3);
                }
            }
        }
        return arrayList;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int n, int n2, int n3, Random random) {
        super.func_149734_b(world, n, n2, n3, random);
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileTDBase) {
            ((TileTDBase)tileEntity).randomDisplayTick();
        }
    }

    @Override
    public float getSize(World world, int n, int n2, int n3) {
        return TDDucts.getDuct(this.offset + world.func_72805_g(n, n2, n3)).isLargeTube() ? 0.05f : super.getSize(world, n, n2, n3);
    }

    public boolean preInit() {
        GameRegistry.registerBlock((Block)this, ItemBlockDuct.class, (String)("ThermalDynamics_" + this.offset));
        for (int i = 0; i < 16; ++i) {
            if (!TDDucts.isValid(this.offset + i)) continue;
            TDDucts.getType((int)(this.offset + i)).itemStack = new ItemStack((Block)this, 1, i);
        }
        return true;
    }

    public boolean initialize() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (this.offset != 0) {
            return true;
        }
        GameRegistry.registerTileEntity(TileEnergyDuct.class, (String)"thermaldynamics.FluxDuct");
        GameRegistry.registerTileEntity(TileEnergyDuctSuper.class, (String)"thermaldynamics.FluxDuctSuperConductor");
        EnergyGrid.initialize();
        SubTileEnergyRedstone.initialize();
        GameRegistry.registerTileEntity(TileFluidDuct.class, (String)"thermaldynamics.FluidDuct");
        GameRegistry.registerTileEntity(TileFluidDuctFragile.class, (String)"thermaldynamics.FluidDuctFragile");
        GameRegistry.registerTileEntity(TileFluidDuctFlux.class, (String)"thermaldynamics.FluidDuctFlux");
        GameRegistry.registerTileEntity(TileFluidDuctSuper.class, (String)"thermaldynamics.FluidDuctSuper");
        GameRegistry.registerTileEntity(TileItemDuct.class, (String)"thermaldynamics.ItemDuct");
        GameRegistry.registerTileEntity(TileItemDuctEnder.class, (String)"thermaldynamics.ItemDuctEnder");
        GameRegistry.registerTileEntity(TileItemDuctFlux.class, (String)"thermaldynamics.ItemDuctFlux");
        GameRegistry.registerTileEntity(TileStructuralDuct.class, (String)"thermaldynamics.StructuralDuct");
        return true;
    }

    public boolean postInit() {
        return true;
    }

    public int func_149709_b(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        TileTDBase tileTDBase = (TileTDBase)iBlockAccess.func_147438_o(n, n2, n3);
        if (tileTDBase != null && tileTDBase.attachments[n4 ^ 1] != null) {
            return tileTDBase.attachments[n4 ^ 1].getRSOutput();
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        if (n4 == -1) {
            return false;
        }
        int n5 = n4 == 0 ? 2 : (n4 == 1 ? 5 : (n4 == 2 ? 3 : 4));
        TileTDBase tileTDBase = (TileTDBase)iBlockAccess.func_147438_o(n, n2, n3);
        return tileTDBase != null && tileTDBase.attachments[n5] != null && tileTDBase.attachments[n5].shouldRSConnect();
    }

    public static enum ConnectionTypes {
        NONE(false),
        DUCT,
        TILECONNECTION,
        STRUCTURE,
        CLEANDUCT;

        private final boolean renderDuct;

        private ConnectionTypes() {
            this.renderDuct = true;
        }

        private ConnectionTypes(boolean bl) {
            this.renderDuct = bl;
        }

        public boolean renderDuct() {
            return this.renderDuct;
        }
    }
}

