/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.block;

import cofh.api.tileentity.IPortableData;
import cofh.core.block.TileCoFHBase;
import cofh.core.network.ITileInfoPacketHandler;
import cofh.core.network.ITilePacketHandler;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.hitbox.CustomHitBox;
import cofh.core.render.hitbox.ICustomHitBox;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.position.BlockPosition;
import cofh.repack.codechicken.lib.raytracer.IndexedCuboid6;
import cofh.repack.codechicken.lib.raytracer.RayTracer;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.AttachmentRegistry;
import cofh.thermaldynamics.block.SubTileMultiBlock;
import cofh.thermaldynamics.core.TickHandler;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.attachments.relay.Relay;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockFormer;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.util.Utils;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.Facing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.StringUtils;

public abstract class TileTDBase
extends TileCoFHBase
implements IMultiBlock,
ITilePacketHandler,
ICustomHitBox,
ITileInfoPacketHandler,
IPortableData {
    public static Cuboid6[] subSelection;
    public static Cuboid6 selection;
    public int facadeMask;
    public boolean isValid = true;
    public boolean isNode = false;
    public MultiBlockGrid myGrid;
    public IMultiBlock[] neighborMultiBlocks = new IMultiBlock[ForgeDirection.VALID_DIRECTIONS.length];
    public NeighborTypes[] neighborTypes = new NeighborTypes[]{NeighborTypes.NONE, NeighborTypes.NONE, NeighborTypes.NONE, NeighborTypes.NONE, NeighborTypes.NONE, NeighborTypes.NONE};
    public ConnectionTypes[] connectionTypes = new ConnectionTypes[]{ConnectionTypes.NORMAL, ConnectionTypes.NORMAL, ConnectionTypes.NORMAL, ConnectionTypes.NORMAL, ConnectionTypes.NORMAL, ConnectionTypes.NORMAL, ConnectionTypes.BLOCKED};
    public byte internalSideCounter = 0;
    public Attachment[] attachments = new Attachment[]{null, null, null, null, null, null};
    public Cover[] covers = new Cover[6];
    LinkedList<Attachment> tickingAttachments = new LinkedList();
    public static final SubTileMultiBlock[] blankSubTiles;
    public SubTileMultiBlock[] subTiles = blankSubTiles;
    public long lastUpdateTime = -1L;
    public int hashCode = 0;
    public LinkedList<WeakReference<Chunk>> neighbourChunks = new LinkedList();
    Duct duct = null;
    public boolean isOutput = false;
    public boolean isInput = false;

    private static void genSelectionBoxes(Cuboid6[] cuboid6Array, int n, double d, double d2, double d3) {
        cuboid6Array[n] = new Cuboid6(d2, 0.0, d2, d3, d, d3);
        cuboid6Array[n + 1] = new Cuboid6(d2, 1.0 - d, d2, d3, 1.0, d3);
        cuboid6Array[n + 2] = new Cuboid6(d2, d2, 0.0, d3, d3, d);
        cuboid6Array[n + 3] = new Cuboid6(d2, d2, 1.0 - d, d3, d3, 1.0);
        cuboid6Array[n + 4] = new Cuboid6(0.0, d2, d2, d, d3, d3);
        cuboid6Array[n + 5] = new Cuboid6(1.0 - d, d2, d2, 1.0, d3, d3);
    }

    public void onChunkUnload() {
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            for (SubTileMultiBlock subTileMultiBlock : this.subTiles) {
                subTileMultiBlock.onChunkUnload();
            }
            if (this.myGrid != null) {
                this.tileUnloading();
                this.myGrid.removeBlock(this);
            }
        }
        super.func_145843_s();
    }

    public void tileUnloading() {
    }

    @Override
    public World world() {
        return this.func_145831_w();
    }

    @Override
    public int x() {
        return ((TileEntity)this).field_145851_c;
    }

    @Override
    public int y() {
        return ((TileEntity)this).field_145848_d;
    }

    @Override
    public int z() {
        return ((TileEntity)this).field_145849_e;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            for (SubTileMultiBlock subTileMultiBlock : this.subTiles) {
                subTileMultiBlock.invalidate();
            }
            if (this.myGrid != null) {
                this.myGrid.removeBlock(this);
            }
        }
    }

    @Override
    public void setInvalidForForming() {
        this.isValid = false;
    }

    @Override
    public void setValidForForming() {
        this.isValid = true;
    }

    @Override
    public boolean isValidForForming() {
        return this.isValid;
    }

    @Override
    public abstract MultiBlockGrid getNewGrid();

    @Override
    public MultiBlockGrid getGrid() {
        return this.myGrid;
    }

    @Override
    public void setGrid(MultiBlockGrid multiBlockGrid) {
        this.myGrid = multiBlockGrid;
    }

    @Override
    public IMultiBlock getConnectedSide(byte by) {
        if (by >= this.neighborMultiBlocks.length) {
            return null;
        }
        return this.neighborMultiBlocks[by];
    }

    @Override
    public boolean isBlockedSide(int n) {
        return this.connectionTypes[n] == ConnectionTypes.BLOCKED || this.attachments[n] != null && !this.attachments[n].allowPipeConnection();
    }

    @Override
    public boolean isSideConnected(byte by) {
        if (by >= this.neighborMultiBlocks.length) {
            return false;
        }
        IMultiBlock iMultiBlock = this.neighborMultiBlocks[by];
        return iMultiBlock != null && !this.isBlockedSide(by) && !iMultiBlock.isBlockedSide(by ^ 1);
    }

    @Override
    public void setNotConnected(byte by) {
        TileEntity tileEntity = BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)ForgeDirection.getOrientation((int)by));
        if (this.isSignificantTile(tileEntity, by)) {
            this.neighborMultiBlocks[by] = null;
            this.neighborTypes[by] = NeighborTypes.OUTPUT;
            if (!this.isNode) {
                this.isNode = true;
                if (this.myGrid != null) {
                    this.myGrid.addBlock(this);
                }
            }
        } else if (this.isStructureTile(tileEntity, by)) {
            this.neighborMultiBlocks[by] = null;
            this.neighborTypes[by] = NeighborTypes.STRUCTURE;
        } else {
            this.neighborTypes[by] = NeighborTypes.NONE;
            this.neighborMultiBlocks[by] = null;
            this.connectionTypes[by] = ConnectionTypes.BLOCKED;
        }
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        for (SubTileMultiBlock subTileMultiBlock : this.subTiles) {
            subTileMultiBlock.onNeighbourChange();
        }
    }

    public boolean isStructureTile(TileEntity tileEntity, int n) {
        return false;
    }

    public boolean removeAttachment(Attachment attachment) {
        if (attachment == null) {
            return false;
        }
        this.attachments[attachment.side] = null;
        this.tickingAttachments.remove(attachment);
        this.connectionTypes[attachment.side] = ConnectionTypes.NORMAL;
        ((TileEntity)this).field_145850_b.func_147459_d(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, this.func_145838_q());
        this.onNeighborBlockChange();
        if (this.myGrid != null) {
            this.myGrid.destroyAndRecreate();
        }
        for (SubTileMultiBlock subTileMultiBlock : this.subTiles) {
            subTileMultiBlock.destroyAndRecreate();
        }
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        return true;
    }

    public boolean addAttachment(Attachment attachment) {
        if (this.attachments[attachment.side] != null || !attachment.canAddToTile(this)) {
            return false;
        }
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return true;
        }
        this.attachments[attachment.side] = attachment;
        if (attachment.doesTick()) {
            this.tickingAttachments.add(attachment);
        }
        this.connectionTypes[attachment.side] = ConnectionTypes.BLOCKED;
        ((TileEntity)this).field_145850_b.func_147459_d(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, this.func_145838_q());
        this.onNeighborBlockChange();
        if (this.myGrid != null) {
            this.myGrid.destroyAndRecreate();
        }
        for (SubTileMultiBlock subTileMultiBlock : this.subTiles) {
            subTileMultiBlock.destroyAndRecreate();
        }
        return true;
    }

    public void blockPlaced() {
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            TickHandler.addMultiBlockToCalculate(this);
        }
    }

    @Override
    public void onNeighborBlockChange() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b) && this.lastUpdateTime == ((TileEntity)this).field_145850_b.func_82737_E()) {
            return;
        }
        if (this.func_145837_r()) {
            return;
        }
        boolean bl = this.isNode;
        this.isNode = false;
        boolean bl2 = this.isInput;
        this.isInput = false;
        boolean bl3 = this.isOutput;
        this.isOutput = false;
        for (int n = 0; n < ForgeDirection.VALID_DIRECTIONS.length; n = (int)((byte)(n + 1))) {
            this.handleSideUpdate(n);
        }
        if (bl != this.isNode && this.myGrid != null) {
            this.myGrid.addBlock(this);
        } else if (this.myGrid != null && (this.isOutput != bl3 || this.isInput != bl2)) {
            this.myGrid.onMajorGridChange();
        }
        for (SubTileMultiBlock subTileMultiBlock : this.subTiles) {
            subTileMultiBlock.onNeighbourChange();
        }
        for (Attachment attachment : this.tickingAttachments) {
            attachment.postNeighbourChange();
        }
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            this.rebuildChunkCache();
        }
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    public void handleSideUpdate(int n) {
        if (this.cachesExist()) {
            this.clearCache(n);
        }
        if (this.attachments[n] != null) {
            this.attachments[n].onNeighborChange();
            this.neighborMultiBlocks[n] = null;
            this.neighborTypes[n] = this.attachments[n].getNeighborType();
            if (this.neighborTypes[n] == NeighborTypes.MULTIBLOCK) {
                TileEntity tileEntity = this.getAdjTileEntitySafe(n);
                if (this.isConnectable(tileEntity, n) && this.isUnblocked(tileEntity, n)) {
                    this.neighborMultiBlocks[n] = (IMultiBlock)tileEntity;
                } else {
                    this.neighborTypes[n] = NeighborTypes.NONE;
                }
            } else if (this.neighborTypes[n] == NeighborTypes.OUTPUT) {
                TileEntity tileEntity = this.getAdjTileEntitySafe(n);
                if (this.isSignificantTile(tileEntity, n)) {
                    if (!this.cachesExist()) {
                        this.createCaches();
                    }
                    this.cacheImportant(tileEntity, n);
                }
                this.isOutput = true;
            } else if (this.neighborTypes[n] == NeighborTypes.INPUT) {
                TileEntity tileEntity = this.getAdjTileEntitySafe(n);
                if (tileEntity != null) {
                    if (!this.cachesExist()) {
                        this.createCaches();
                    }
                    this.cacheInputTile(tileEntity, n);
                }
                this.isInput = true;
            } else {
                this.neighborMultiBlocks[n] = null;
            }
            this.connectionTypes[n] = ConnectionTypes.NORMAL;
            this.isNode = this.attachments[n].isNode();
        } else {
            TileEntity tileEntity = this.getAdjTileEntitySafe(n);
            if (tileEntity == null) {
                this.neighborMultiBlocks[n] = null;
                this.neighborTypes[n] = NeighborTypes.NONE;
                this.connectionTypes[n] = ConnectionTypes.NORMAL;
            } else if (this.isConnectable(tileEntity, n) && this.isUnblocked(tileEntity, n)) {
                this.neighborMultiBlocks[n] = (IMultiBlock)tileEntity;
                this.neighborTypes[n] = NeighborTypes.MULTIBLOCK;
            } else if (this.connectionTypes[n].allowTransfer && this.isSignificantTile(tileEntity, n)) {
                this.neighborMultiBlocks[n] = null;
                this.neighborTypes[n] = NeighborTypes.OUTPUT;
                if (!this.cachesExist()) {
                    this.createCaches();
                }
                this.cacheImportant(tileEntity, n);
                this.isNode = true;
                this.isOutput = true;
            } else if (this.connectionTypes[n].allowTransfer && this.isStructureTile(tileEntity, n)) {
                this.neighborMultiBlocks[n] = null;
                this.neighborTypes[n] = NeighborTypes.STRUCTURE;
                if (!this.cachesExist()) {
                    this.createCaches();
                }
                this.cacheStructural(tileEntity, n);
                this.isNode = true;
            } else {
                this.neighborMultiBlocks[n] = null;
                this.neighborTypes[n] = NeighborTypes.NONE;
            }
        }
    }

    public void cacheInputTile(TileEntity tileEntity, int n) {
    }

    public TileEntity getAdjTileEntitySafe(int n) {
        return n < 2 || ((TileEntity)this).field_145850_b.func_72899_e(this.x() + Facing.field_71586_b[n], this.y(), this.z() + Facing.field_71585_d[n]) ? BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)n) : null;
    }

    public boolean checkForChunkUnload() {
        if (this.neighbourChunks.isEmpty()) {
            return false;
        }
        for (WeakReference weakReference : this.neighbourChunks) {
            Object t = weakReference.get();
            if (t == null || ((Chunk)t).field_76636_d) continue;
            this.onNeighborBlockChange();
            this.neighbourChunks.clear();
            return true;
        }
        return false;
    }

    public void rebuildChunkCache() {
        if (!this.neighbourChunks.isEmpty()) {
            this.neighbourChunks.clear();
        }
        if (!this.isNode) {
            return;
        }
        Chunk chunk = ((TileEntity)this).field_145850_b.func_72938_d(this.x(), this.y());
        for (int n = 0; n < 6; n = (int)((byte)(n + 1))) {
            Chunk chunk2;
            if (this.neighborTypes[n] != NeighborTypes.INPUT && this.neighborTypes[n] != NeighborTypes.OUTPUT || (chunk2 = ((TileEntity)this).field_145850_b.func_72938_d(this.x() + Facing.field_71586_b[n], this.z() + Facing.field_71585_d[n])) == chunk) continue;
            this.neighbourChunks.add(new WeakReference<Chunk>(chunk2));
        }
    }

    public void cacheStructural(TileEntity tileEntity, int n) {
    }

    public void onNeighborTileChange(int n, int n2, int n3) {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b) && this.lastUpdateTime == ((TileEntity)this).field_145850_b.func_82737_E()) {
            return;
        }
        if (this.func_145837_r()) {
            return;
        }
        int n4 = BlockHelper.determineAdjacentSide((TileEntity)this, (int)n, (int)n2, (int)n3);
        boolean bl = this.isNode;
        boolean bl2 = this.isInput;
        boolean bl3 = this.isOutput;
        this.handleSideUpdate(n4);
        for (SubTileMultiBlock subTileMultiBlock : this.subTiles) {
            subTileMultiBlock.onNeighbourChange();
        }
        this.checkIsNode();
        if (bl != this.isNode && this.myGrid != null) {
            this.myGrid.addBlock(this);
        } else if (this.myGrid != null && (this.isOutput != bl3 || this.isInput != bl2)) {
            this.myGrid.onMajorGridChange();
        }
        for (Attachment attachment : this.tickingAttachments) {
            attachment.postNeighbourChange();
        }
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            this.rebuildChunkCache();
        }
    }

    private void checkIsNode() {
        this.isNode = false;
        for (int n = 0; n < ForgeDirection.VALID_DIRECTIONS.length; n = (int)((byte)(n + 1))) {
            if (this.neighborTypes[n] == NeighborTypes.OUTPUT || this.neighborTypes[n] == NeighborTypes.STRUCTURE || this.attachments[n] != null && this.attachments[n].isNode()) {
                this.isNode = true;
            }
            if (this.neighborTypes[n] == NeighborTypes.OUTPUT) {
                this.isOutput = true;
            }
            if (this.neighborTypes[n] != NeighborTypes.INPUT) continue;
            this.isInput = true;
        }
    }

    public void tickInternalSideCounter(int n) {
        int n2;
        for (n2 = n; n2 < this.neighborTypes.length; ++n2) {
            if (this.neighborTypes[n2] != NeighborTypes.OUTPUT || this.connectionTypes[n2] != ConnectionTypes.NORMAL) continue;
            this.internalSideCounter = (byte)n2;
            return;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (this.neighborTypes[n2] != NeighborTypes.OUTPUT || this.connectionTypes[n2] != ConnectionTypes.NORMAL) continue;
            this.internalSideCounter = (byte)n2;
            return;
        }
    }

    public boolean isConnectable(TileEntity tileEntity, int n) {
        return tileEntity instanceof TileTDBase;
    }

    public boolean isUnblocked(TileEntity tileEntity, int n) {
        return !this.isBlockedSide(n) && !((TileTDBase)tileEntity).isBlockedSide(n ^ 1);
    }

    public boolean isSignificantTile(TileEntity tileEntity, int n) {
        return false;
    }

    public String getName() {
        return "tile.thermaldynamics.multiblock.name";
    }

    public int getType() {
        return 0;
    }

    @Override
    public void tickMultiBlock() {
        if (this.func_145837_r()) {
            return;
        }
        this.onNeighborBlockChange();
        this.formGrid();
        for (SubTileMultiBlock subTileMultiBlock : this.subTiles) {
            subTileMultiBlock.onNeighbourChange();
            subTileMultiBlock.formGrid();
        }
    }

    public void formGrid() {
        if (this.myGrid == null && ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            new MultiBlockFormer().formGrid(this);
        }
    }

    @Override
    public boolean tickPass(int n) {
        if (this.checkForChunkUnload()) {
            return false;
        }
        if (!this.tickingAttachments.isEmpty()) {
            for (Attachment attachment : this.tickingAttachments) {
                attachment.tick(n);
            }
        }
        return true;
    }

    @Override
    public boolean isNode() {
        return this.isNode;
    }

    @Override
    public boolean existsYet() {
        return ((TileEntity)this).field_145850_b != null && ((TileEntity)this).field_145850_b.func_72899_e(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e) && ((TileEntity)this).field_145850_b.func_147439_a(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e) instanceof BlockDuct;
    }

    @Override
    public IMultiBlock[] getSubTiles() {
        return this.subTiles;
    }

    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        byte by;
        super.func_145839_a(nBTTagCompound);
        for (by = 0; by < 6; by = (byte)(by + 1)) {
            NBTTagCompound nBTTagCompound2;
            if (nBTTagCompound.func_150297_b("attachment" + by, 10)) {
                nBTTagCompound2 = nBTTagCompound.func_74775_l("attachment" + by);
                short s = nBTTagCompound2.func_74765_d("id");
                this.attachments[by] = AttachmentRegistry.createAttachment(this, by, s);
                if (this.attachments[by] != null) {
                    this.attachments[by].readFromNBT(nBTTagCompound2);
                    if (this.attachments[by].doesTick()) {
                        this.tickingAttachments.add(this.attachments[by]);
                    }
                }
            } else {
                this.attachments[by] = null;
            }
            if (nBTTagCompound.func_150297_b("facade" + by, 10)) {
                nBTTagCompound2 = nBTTagCompound.func_74775_l("facade" + by);
                this.covers[by] = new Cover(this, by);
                this.covers[by].readFromNBT(nBTTagCompound2);
            } else {
                this.covers[by] = null;
            }
            this.connectionTypes[by] = ConnectionTypes.values()[nBTTagCompound.func_74771_c("conTypes" + by)];
        }
        this.recalcFacadeMask();
        for (by = 0; by < this.subTiles.length; ++by) {
            this.subTiles[by].readFromNBT(nBTTagCompound.func_74775_l("subTile" + by));
        }
        TickHandler.addMultiBlockToCalculate(this);
    }

    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        Object object;
        int n;
        super.func_145841_b(nBTTagCompound);
        for (n = 0; n < 6; ++n) {
            if (this.attachments[n] != null) {
                object = new NBTTagCompound();
                object.func_74777_a("id", (short)this.attachments[n].getId());
                this.attachments[n].writeToNBT((NBTTagCompound)object);
                nBTTagCompound.func_74782_a("attachment" + n, (NBTBase)object);
            }
            if (this.covers[n] != null) {
                object = new NBTTagCompound();
                this.covers[n].writeToNBT((NBTTagCompound)object);
                nBTTagCompound.func_74782_a("facade" + n, (NBTBase)object);
            }
            nBTTagCompound.func_74774_a("conTypes" + n, (byte)this.connectionTypes[n].ordinal());
        }
        for (n = 0; n < this.subTiles.length; ++n) {
            object = this.subTiles[n];
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            ((SubTileMultiBlock)object).writeToNBT(nBTTagCompound2);
            nBTTagCompound.func_74782_a("subTile" + n, (NBTBase)nBTTagCompound2);
        }
    }

    public boolean openGui(EntityPlayer entityPlayer) {
        MovingObjectPosition movingObjectPosition = RayTracer.retraceBlock((World)((TileEntity)this).field_145850_b, (EntityPlayer)entityPlayer, (int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e);
        if (movingObjectPosition == null) {
            return false;
        }
        int n = movingObjectPosition.subHit;
        if (n > 13 && n < 20) {
            return this.attachments[n - 14].openGui(entityPlayer);
        }
        return super.openGui(entityPlayer);
    }

    public Duct getDuctType() {
        if (this.duct == null) {
            this.duct = TDDucts.getDuct(((BlockDuct)this.func_145838_q()).offset + this.func_145832_p());
        }
        return this.duct;
    }

    public void addTraceableCuboids(List<IndexedCuboid6> list) {
        Vector3 vector3 = new Vector3((double)((TileEntity)this).field_145851_c, (double)((TileEntity)this).field_145848_d, (double)((TileEntity)this).field_145849_e);
        for (int i = 0; i < 6; ++i) {
            if (this.attachments[i] != null) {
                list.add(new IndexedCuboid6((Object)(i + 14), this.attachments[i].getCuboid().add(vector3)));
                if (this.neighborTypes[i] != NeighborTypes.NONE) {
                    list.add(new IndexedCuboid6((Object)(i + 14), subSelection[i + 6].copy().add(vector3)));
                }
            }
            if (this.covers[i] != null) {
                list.add(new IndexedCuboid6((Object)(i + 20), this.covers[i].getCuboid().add(vector3)));
            }
            if (this.neighborTypes[i] == NeighborTypes.OUTPUT) {
                list.add(new IndexedCuboid6((Object)i, subSelection[i].copy().add(vector3)));
                continue;
            }
            if (this.neighborTypes[i] == NeighborTypes.MULTIBLOCK) {
                list.add(new IndexedCuboid6((Object)(i + 6), subSelection[i + 6].copy().add(vector3)));
                continue;
            }
            if (this.neighborTypes[i] != NeighborTypes.STRUCTURE) continue;
            list.add(new IndexedCuboid6((Object)i, subSelection[i + 6].copy().add(vector3)));
        }
        list.add(new IndexedCuboid6((Object)13, selection.copy().add(vector3)));
    }

    public boolean shouldRenderCustomHitBox(int n, EntityPlayer entityPlayer) {
        return n == 13 || n > 5 && n < 13 && !Utils.isHoldingUsableWrench(entityPlayer, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    public CustomHitBox getCustomHitBox(int n, EntityPlayer entityPlayer) {
        CustomHitBox customHitBox = new CustomHitBox(0.4, 0.4, 0.4, (double)((TileEntity)this).field_145851_c + 0.3, (double)((TileEntity)this).field_145848_d + 0.3, (double)((TileEntity)this).field_145849_e + 0.3);
        for (int i = 0; i < this.neighborTypes.length; ++i) {
            if (this.neighborTypes[i] == NeighborTypes.MULTIBLOCK) {
                customHitBox.drawSide(i, true);
                customHitBox.setSideLength(i, 0.3);
                continue;
            }
            if (this.neighborTypes[i] == NeighborTypes.NONE) continue;
            customHitBox.drawSide(i, true);
            customHitBox.setSideLength(i, 0.04);
        }
        return customHitBox;
    }

    public boolean onWrench(EntityPlayer entityPlayer, int n) {
        if (Utils.isHoldingUsableWrench(entityPlayer, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e)) {
            MovingObjectPosition movingObjectPosition = RayTracer.retraceBlock((World)((TileEntity)this).field_145850_b, (EntityPlayer)entityPlayer, (int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e);
            if (movingObjectPosition == null) {
                return false;
            }
            int n2 = movingObjectPosition.subHit;
            if (n2 >= 0 && n2 <= 13) {
                int n3 = n2 == 13 ? n : (n2 < 6 ? n2 : n2 - 6);
                this.onNeighborBlockChange();
                this.connectionTypes[n3] = this.connectionTypes[n3].next();
                TileEntity tileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)n3);
                if (this.isConnectable(tileEntity, n3)) {
                    ((TileTDBase)tileEntity).connectionTypes[n3 ^ 1] = this.connectionTypes[n3];
                }
                ((TileEntity)this).field_145850_b.func_147459_d(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, this.func_145838_q());
                if (this.myGrid != null) {
                    this.myGrid.destroyAndRecreate();
                }
                for (SubTileMultiBlock subTileMultiBlock : this.subTiles) {
                    subTileMultiBlock.destroyAndRecreate();
                }
                ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
                return true;
            }
            if (n2 > 13 && n2 < 20) {
                return this.attachments[n2 - 14].onWrenched();
            }
            if (n2 >= 20 && n2 < 26) {
                return this.covers[n2 - 20].onWrenched();
            }
        }
        return false;
    }

    public void doDebug(EntityPlayer entityPlayer) {
        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Neighbors: " + StringUtils.join((Object[])this.neighborTypes, (String)",")));
        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Connections: " + StringUtils.join((Object[])this.connectionTypes, (String)",")));
        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("isNode: " + this.isNode));
        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Grid Nodes: " + this.myGrid.nodeSet.size()));
    }

    public boolean addFacade(Cover cover) {
        if (this.covers[cover.side] != null) {
            return false;
        }
        this.covers[cover.side] = cover;
        this.recalcFacadeMask();
        this.func_145831_w().func_147459_d(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, this.func_145838_q());
        this.onNeighborBlockChange();
        this.func_145831_w().func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        return true;
    }

    public void removeFacade(Cover cover) {
        this.covers[cover.side] = null;
        this.recalcFacadeMask();
        this.func_145831_w().func_147459_d(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, this.func_145838_q());
        this.onNeighborBlockChange();
        this.func_145831_w().func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    public void recalcFacadeMask() {
        this.facadeMask = 0;
        for (int n = 0; n < 6; n = (int)((byte)(n + 1))) {
            if (this.covers[n] == null) continue;
            this.facadeMask |= 1 << n;
        }
    }

    public PacketCoFHBase getPacket() {
        int n;
        PacketCoFHBase packetCoFHBase = super.getPacket();
        int n2 = 0;
        this.recalcFacadeMask();
        for (n = 0; n < this.neighborTypes.length; n = (int)((byte)(n + 1))) {
            packetCoFHBase.addByte(this.neighborTypes[n].ordinal());
            packetCoFHBase.addByte(this.connectionTypes[n].ordinal());
            if (this.attachments[n] == null) continue;
            n2 |= 1 << n;
        }
        packetCoFHBase.addBool(this.isNode);
        packetCoFHBase.addByte(n2);
        for (n = 0; n < 6; n = (int)((byte)(n + 1))) {
            if (this.attachments[n] == null) continue;
            packetCoFHBase.addByte(this.attachments[n].getId());
            this.attachments[n].addDescriptionToPacket(packetCoFHBase);
        }
        packetCoFHBase.addByte(this.facadeMask);
        for (n = 0; n < 6; n = (int)((byte)(n + 1))) {
            if (this.covers[n] == null) continue;
            this.covers[n].addDescriptionToPacket(packetCoFHBase);
        }
        packetCoFHBase.addInt(this.myGrid == null ? 0 : this.myGrid.hashCode());
        return packetCoFHBase;
    }

    public void handleTileInfoPacket(PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
        byte by = packetCoFHBase.getByte();
        if (by == 0) {
            this.handleInfoPacket(packetCoFHBase, bl, entityPlayer);
        } else if (by >= 1 && by <= 6) {
            this.attachments[by - 1].handleInfoPacket(packetCoFHBase, bl, entityPlayer);
        }
    }

    public void handleInfoPacket(PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
    }

    public abstract boolean cachesExist();

    public abstract void createCaches();

    public abstract void cacheImportant(TileEntity var1, int var2);

    public abstract void clearCache(int var1);

    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        if (!bl) {
            byte by;
            int n;
            for (n = 0; n < this.neighborTypes.length; n = (int)((byte)(n + 1))) {
                this.neighborTypes[n] = NeighborTypes.values()[packetCoFHBase.getByte()];
                this.connectionTypes[n] = ConnectionTypes.values()[packetCoFHBase.getByte()];
            }
            this.isNode = packetCoFHBase.getBool();
            n = packetCoFHBase.getByte();
            for (by = 0; by < 6; by = (byte)(by + 1)) {
                if ((n & 1 << by) != 0) {
                    this.attachments[by] = AttachmentRegistry.createAttachment(this, by, packetCoFHBase.getByte());
                    this.attachments[by].getDescriptionFromPacket(packetCoFHBase);
                    continue;
                }
                this.attachments[by] = null;
            }
            this.facadeMask = packetCoFHBase.getByte();
            for (by = 0; by < 6; by = (byte)(by + 1)) {
                if ((this.facadeMask & 1 << by) != 0) {
                    this.covers[by] = new Cover(this, by);
                    this.covers[by].getDescriptionFromPacket(packetCoFHBase);
                    continue;
                }
                this.covers[by] = null;
            }
            this.recalcFacadeMask();
            this.hashCode = packetCoFHBase.getInt();
            ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            this.lastUpdateTime = ((TileEntity)this).field_145850_b.func_82737_E();
        }
    }

    public BlockDuct.ConnectionTypes getConnectionType(int n) {
        if (this.attachments[n] != null) {
            return this.attachments[n].getRenderConnectionType();
        }
        return TileTDBase.getDefaultConnectionType(this.neighborTypes[n], this.connectionTypes[n]);
    }

    public static BlockDuct.ConnectionTypes getDefaultConnectionType(NeighborTypes neighborTypes, ConnectionTypes connectionTypes) {
        if (neighborTypes == NeighborTypes.STRUCTURE) {
            return BlockDuct.ConnectionTypes.STRUCTURE;
        }
        if (neighborTypes == NeighborTypes.INPUT) {
            return BlockDuct.ConnectionTypes.DUCT;
        }
        if (neighborTypes == NeighborTypes.NONE || connectionTypes == ConnectionTypes.BLOCKED || connectionTypes == ConnectionTypes.REJECTED) {
            return BlockDuct.ConnectionTypes.NONE;
        }
        if (neighborTypes == NeighborTypes.OUTPUT) {
            return BlockDuct.ConnectionTypes.TILECONNECTION;
        }
        return BlockDuct.ConnectionTypes.DUCT;
    }

    public void randomDisplayTick() {
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean renderAdditional(int n, int[] nArray, int n2) {
        return false;
    }

    public boolean isSubNode() {
        return false;
    }

    public IIcon getBaseIcon() {
        return this.getDuctType().iconBaseTexture;
    }

    public ItemStack getDrop() {
        return new ItemStack(this.func_145838_q(), 1, this.func_145832_p());
    }

    public void onPlacedBy(EntityLivingBase entityLivingBase, ItemStack itemStack) {
    }

    public void dropAdditional(ArrayList<ItemStack> arrayList) {
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)((TileEntity)this).field_145851_c, (double)((TileEntity)this).field_145848_d, (double)((TileEntity)this).field_145849_e, (double)(((TileEntity)this).field_145851_c + 1), (double)(((TileEntity)this).field_145848_d + 1), (double)(((TileEntity)this).field_145849_e + 1));
    }

    public String getDataType() {
        return "tile.thermaldynamics.duct";
    }

    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!nBTTagCompound.func_150297_b("AttachmentType", 8)) {
            return;
        }
        MovingObjectPosition movingObjectPosition = RayTracer.retraceBlock((World)((TileEntity)this).field_145850_b, (EntityPlayer)entityPlayer, (int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e);
        if (movingObjectPosition == null) {
            return;
        }
        int n = movingObjectPosition.subHit;
        if (n <= 13 || n >= 20) {
            return;
        }
        if (!(this.attachments[n - 14] instanceof IPortableData)) {
            return;
        }
        IPortableData iPortableData = (IPortableData)this.attachments[n - 14];
        if (nBTTagCompound.func_74779_i("AttachmentType").equals(iPortableData.getDataType())) {
            iPortableData.readPortableData(entityPlayer, nBTTagCompound);
        }
    }

    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        MovingObjectPosition movingObjectPosition = RayTracer.retraceBlock((World)((TileEntity)this).field_145850_b, (EntityPlayer)entityPlayer, (int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e);
        if (movingObjectPosition == null) {
            return;
        }
        int n = movingObjectPosition.subHit;
        if (n <= 13 || n >= 20) {
            return;
        }
        if (!(this.attachments[n - 14] instanceof IPortableData)) {
            return;
        }
        IPortableData iPortableData = (IPortableData)this.attachments[n - 14];
        iPortableData.writePortableData(entityPlayer, nBTTagCompound);
        if (!nBTTagCompound.func_82582_d()) {
            nBTTagCompound.func_74778_a("AttachmentType", iPortableData.getDataType());
        }
    }

    public void cofh_invalidate() {
        this.markChunkDirty();
    }

    @Override
    public void addSignallers() {
        for (Attachment attachment : this.attachments) {
            if (attachment == null) continue;
            if (attachment.getId() == 7) {
                Relay relay = (Relay)attachment;
                if (relay.isInput()) {
                    this.myGrid.addSignalInput(relay);
                    continue;
                }
                this.myGrid.addSignalOutput(attachment);
                continue;
            }
            if (!attachment.respondsToSignallum()) continue;
            this.myGrid.addSignalOutput(attachment);
        }
    }

    static {
        GameRegistry.registerTileEntityWithAlternatives(TileTDBase.class, (String)"thermaldynamics.Duct", (String[])new String[]{"thermaldynamics.multiblock"});
        subSelection = new Cuboid6[12];
        TileTDBase.genSelectionBoxes(subSelection, 0, 0.25, 0.2, 0.8);
        TileTDBase.genSelectionBoxes(subSelection, 6, 0.3, 0.3, 0.7);
        selection = new Cuboid6(0.3, 0.3, 0.3, 0.7, 0.7, 0.7);
        blankSubTiles = new SubTileMultiBlock[0];
    }

    public static enum ConnectionTypes {
        NORMAL(true),
        ONEWAY(true),
        REJECTED(false),
        BLOCKED(false);

        public final boolean allowTransfer;

        private ConnectionTypes(boolean bl) {
            this.allowTransfer = bl;
        }

        public ConnectionTypes next() {
            if (this == NORMAL) {
                return BLOCKED;
            }
            return NORMAL;
        }
    }

    public static enum NeighborTypes {
        NONE,
        MULTIBLOCK,
        OUTPUT(true),
        INPUT(true),
        STRUCTURE(true),
        DUCT_ATTACHMENT;

        public final boolean attachedToNeightbour;

        private NeighborTypes() {
            this(false);
        }

        private NeighborTypes(boolean bl) {
            this.attachedToNeightbour = bl;
        }
    }
}

