/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.decoration;

import cofh.api.world.IGeneratorParser;
import cofh.core.world.FeatureParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenStalactite;
import cofh.lib.world.WorldGenStalagmite;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class StalagmiteParser
implements IGeneratorParser {
    private final boolean stalactite;

    public StalagmiteParser(boolean bl) {
        this.stalactite = bl;
    }

    @Override
    public WorldGenerator parseGenerator(String string, JsonObject jsonObject, Logger logger, List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        WorldGenStalagmite worldGenStalagmite;
        ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
        if (!jsonObject.has("genBody")) {
            logger.info("Entry does not specify genBody for 'stalagmite' generator. Using air.");
            arrayList.add(new WeightedRandomBlock(Blocks.field_150350_a));
        } else if (!FeatureParser.parseResList(jsonObject.get("genBody"), arrayList, false)) {
            logger.warn("Entry specifies invalid genBody for 'stalagmite' generator! Using air!");
            arrayList.clear();
            arrayList.add(new WeightedRandomBlock(Blocks.field_150350_a));
        }
        WorldGenStalagmite worldGenStalagmite2 = worldGenStalagmite = this.stalactite ? new WorldGenStalactite(list, list2, arrayList) : new WorldGenStalagmite(list, list2, arrayList);
        if (jsonObject.has("minHeight")) {
            worldGenStalagmite.minHeight = jsonObject.get("minHeight").getAsInt();
        }
        if (jsonObject.has("heightVariance")) {
            worldGenStalagmite.heightVariance = jsonObject.get("heightVariance").getAsInt();
        }
        if (jsonObject.has("sizeVariance")) {
            worldGenStalagmite.sizeVariance = jsonObject.get("sizeVariance").getAsInt();
        }
        if (jsonObject.has("heightMod")) {
            worldGenStalagmite.heightMod = jsonObject.get("heightMod").getAsInt();
        }
        if (jsonObject.has("genSize")) {
            worldGenStalagmite.genSize = jsonObject.get("genSize").getAsInt();
        }
        if (jsonObject.has("smooth")) {
            worldGenStalagmite.smooth = jsonObject.get("smooth").getAsBoolean();
        }
        if (jsonObject.has("fat")) {
            worldGenStalagmite.fat = jsonObject.get("fat").getAsBoolean();
        }
        if (jsonObject.has("altSinc")) {
            worldGenStalagmite.altSinc = jsonObject.get("altSinc").getAsBoolean();
        }
        return worldGenStalagmite;
    }
}

