/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world;

import cofh.CoFHCore;
import cofh.core.world.WorldHandler;
import cofh.lib.util.position.ChunkCoord;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.Random;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class TickHandlerWorld {
    public static TickHandlerWorld instance = new TickHandlerWorld();
    public static TIntObjectHashMap<ArrayDeque<RetroChunkCoord>> chunksToGen = new TIntObjectHashMap();
    public static TIntObjectHashMap<ArrayDeque<ChunkCoord>> chunksToPreGen = new TIntObjectHashMap();

    @SubscribeEvent
    public void tickEnd(TickEvent.WorldTickEvent worldTickEvent) {
        if (worldTickEvent.side != Side.SERVER) {
            return;
        }
        World world = worldTickEvent.world;
        int n = world.field_73011_w.field_76574_g;
        if (worldTickEvent.phase == TickEvent.Phase.END) {
            ArrayDeque arrayDeque = (ArrayDeque)chunksToGen.get(n);
            if (arrayDeque != null && arrayDeque.size() > 0) {
                RetroChunkCoord retroChunkCoord = (RetroChunkCoord)arrayDeque.pollFirst();
                ChunkCoord chunkCoord = retroChunkCoord.coord;
                CoFHCore.log.info("RetroGening " + chunkCoord.toString() + ".");
                long l = world.func_72905_C();
                Random random = new Random(l);
                long l2 = random.nextLong() >> 3;
                long l3 = random.nextLong() >> 3;
                random.setSeed(l2 * (long)chunkCoord.chunkX + l3 * (long)chunkCoord.chunkZ ^ l);
                WorldHandler.instance.generateWorld(random, retroChunkCoord, world, false);
                chunksToGen.put(n, (Object)arrayDeque);
            } else if (arrayDeque != null) {
                chunksToGen.remove(n);
            }
        } else {
            ArrayDeque arrayDeque = (ArrayDeque)chunksToPreGen.get(n);
            if (arrayDeque != null && arrayDeque.size() > 0) {
                ChunkCoord chunkCoord = (ChunkCoord)arrayDeque.pollFirst();
                CoFHCore.log.info("PreGening " + chunkCoord.toString() + ".");
                world.func_72964_e(chunkCoord.chunkX, chunkCoord.chunkZ);
            } else if (arrayDeque != null) {
                chunksToPreGen.remove(n);
            }
        }
    }

    public static class RetroChunkCoord {
        private static final THashSet<String> emptySet = new THashSet(0);
        public final ChunkCoord coord;
        public final THashSet<String> generatedFeatures;

        public RetroChunkCoord(ChunkCoord chunkCoord, NBTTagList nBTTagList) {
            this.coord = chunkCoord;
            if (nBTTagList == null) {
                this.generatedFeatures = emptySet;
            } else {
                int n = nBTTagList.func_74745_c();
                this.generatedFeatures = new THashSet(n);
                for (int i = 0; i < n; ++i) {
                    this.generatedFeatures.add((Object)nBTTagList.func_150307_f(i));
                }
            }
        }
    }
}

