/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.render;

import cofh.lib.util.ItemWrapper;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class ItemRenderRegistry {
    public static Map<ItemWrapper, IItemRenderer> itemRenders = new THashMap();

    public static boolean addItemRenderer(ItemStack itemStack, IItemRenderer iItemRenderer) {
        if (ItemRenderRegistry.validItem(itemStack)) {
            return false;
        }
        itemRenders.put(ItemWrapper.fromItemStack(itemStack), iItemRenderer);
        return true;
    }

    public static IItemRenderer getItemRenderer(ItemStack itemStack) {
        return itemRenders.get(ItemWrapper.fromItemStack(itemStack));
    }

    public static boolean validItem(ItemStack itemStack) {
        return itemRenders.containsKey(ItemWrapper.fromItemStack(itemStack));
    }

    public static void refreshMap() {
        THashMap tHashMap = new THashMap(itemRenders.size());
        for (Map.Entry<ItemWrapper, IItemRenderer> entry : itemRenders.entrySet()) {
            ItemWrapper itemWrapper = new ItemWrapper(entry.getKey().item, entry.getKey().metadata);
            tHashMap.put(itemWrapper, entry.getValue());
        }
        itemRenders.clear();
        itemRenders = tHashMap;
    }
}

