/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.teleport;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageAddEffects;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.PositionHelper;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class TeleportEntity {
    public static void addTeleportSoundsAndParticles(World world, double x, double y, double z) {
        if (!world.field_72995_K) {
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAddEffects(1, 3, x, y, z), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, 24.0));
        }
    }

    public static boolean canTeleportEntity(Entity entity) {
        return !EntityUtils.doesEntityStackHaveBlacklistedEntities(entity);
    }

    public static void teleportEntityRandomly(EntityLivingBase entity, double maxDist) {
        if (entity == null || !TeleportEntity.canTeleportEntity((Entity)entity) || entity.field_70170_p.field_72995_K) {
            return;
        }
        TeleportEntity.addTeleportSoundsAndParticles(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        double deltaYaw = 0.0;
        double deltaPitch = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        maxDist -= Math.random() * maxDist / 2.0;
        for (int i = 0; i < 10; ++i) {
            deltaYaw = Math.random() * 360.0 / 180.0 * Math.PI;
            deltaPitch = Math.random() * 90.0 / 180.0 * Math.PI;
            x = entity.field_70165_t;
            y = entity.field_70163_u;
            z = entity.field_70161_v;
            x += Math.cos(deltaPitch) * Math.cos(deltaYaw) * maxDist;
            z += Math.cos(deltaPitch) * Math.sin(deltaYaw) * maxDist;
            y += Math.sin(deltaPitch) * maxDist;
            if (!entity.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty()) continue;
            entity.func_70634_a(x, y, z);
            TeleportEntity.addTeleportSoundsAndParticles(entity.field_70170_p, x, y, z);
            return;
        }
    }

    public static boolean entityTeleportWithProjectile(Entity entity, Entity projectile, MovingObjectPosition mop, float teleportDamage, boolean allowMounts, boolean allowRiders) {
        Entity entNew;
        if (!TeleportEntity.canTeleportEntity(entity)) {
            return false;
        }
        PositionHelper pos = new PositionHelper(mop, projectile);
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mop.field_72307_f != null) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)mop.field_72310_e);
            pos.posX += (double)((float)dir.offsetX * entity.field_70130_N / 2.0f);
            pos.posZ += (double)((float)dir.offsetZ * entity.field_70130_N / 2.0f);
            if (dir.equals((Object)ForgeDirection.DOWN)) {
                pos.posY -= (double)entity.field_70131_O;
            }
        }
        if ((entNew = TeleportEntity.teleportEntity(entity, pos.posX, pos.posY, pos.posZ, projectile.field_71093_bK, allowMounts, allowRiders)) != null) {
            Entity bottom;
            if (teleportDamage != 0.0f && (bottom = EntityUtils.getBottomEntity(entNew)) instanceof EntityLivingBase) {
                bottom.func_70097_a(DamageSource.field_76379_h, teleportDamage);
            }
            entNew.field_70143_R = 0.0f;
            return true;
        }
        return false;
    }

    public static NBTHelperTarget adjustTargetPosition(NBTHelperTarget target, Entity entity) {
        if (target == null || target.blockFace < 0) {
            return target;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)target.blockFace);
        float widthAdj = 0.5f;
        float heightAdj = 1.0f;
        if (entity != null) {
            widthAdj = entity.field_70130_N / 2.0f;
            heightAdj = entity.field_70131_O;
        }
        target.dPosX += (double)((float)dir.offsetX * widthAdj);
        target.dPosZ += (double)((float)dir.offsetZ * widthAdj);
        if (dir.equals((Object)ForgeDirection.DOWN)) {
            target.dPosY -= (double)heightAdj;
        }
        return target;
    }

    public static Entity teleportEntityUsingModularItem(Entity entity, ItemStack stack) {
        return TeleportEntity.teleportEntityUsingModularItem(entity, stack, true, true);
    }

    public static Entity teleportEntityUsingModularItem(Entity entity, ItemStack stack, boolean allowMounts, boolean allowRiders) {
        return TeleportEntity.teleportEntityUsingItem(entity, UtilItemModular.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL), allowMounts, allowRiders);
    }

    public static Entity teleportEntityUsingItem(Entity entity, ItemStack stack) {
        return TeleportEntity.teleportEntityUsingItem(entity, stack, true, true);
    }

    public static Entity teleportEntityUsingItem(Entity entity, ItemStack stack, boolean allowMounts, boolean allowRiders) {
        NBTHelperTarget target = NBTHelperTarget.getTargetFromItem(stack);
        if (target != null) {
            TeleportEntity.adjustTargetPosition(target, entity);
            if (target.hasAngle && entity != null) {
                entity.func_70080_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, target.yaw, target.pitch);
            }
            return TeleportEntity.teleportEntity(entity, target.dPosX, target.dPosY, target.dPosZ, target.dimension, allowMounts, allowRiders);
        }
        return null;
    }

    public static Entity teleportEntity(Entity entity, double x, double y, double z, int dimDst, boolean allowMounts, boolean allowRiders) {
        if (entity == null || entity.field_70170_p == null || entity.field_70170_p.field_72995_K) {
            return null;
        }
        if (!allowMounts && entity.field_70154_o != null) {
            return null;
        }
        if (!allowRiders && entity.field_70153_n != null) {
            return null;
        }
        if (!TeleportEntity.canTeleportEntity(entity)) {
            return null;
        }
        Entity ret = null;
        boolean reCreate = EntityUtils.doesEntityStackHavePlayers(entity);
        Entity previous = null;
        Entity current = EntityUtils.getBottomEntity(entity);
        while (current != null) {
            Entity teleported;
            Entity riddenBy = current.field_70153_n;
            if (current.field_70153_n != null) {
                current.field_70153_n.func_70078_a((Entity)null);
            }
            if (current == entity) {
                ret = teleported = TeleportEntity.teleportEntity(current, x, y, z, dimDst, reCreate);
            } else {
                teleported = TeleportEntity.teleportEntity(current, x, y, z, dimDst, reCreate);
            }
            if (teleported == null) break;
            if (previous != null) {
                teleported.func_70078_a(previous);
            }
            teleported.field_70143_R = 0.0f;
            current = riddenBy;
            previous = teleported;
        }
        return ret;
    }

    private static Entity teleportEntity(Entity entity, double x, double y, double z, int dimDst, boolean forceRecreate) {
        EnderTeleportEvent etpEvent;
        if (entity == null || entity.field_70128_L || !TeleportEntity.canTeleportEntity(entity) || entity.field_70170_p.field_72995_K) {
            return null;
        }
        if (entity instanceof EntityLivingBase && MinecraftForge.EVENT_BUS.post((Event)(etpEvent = new EnderTeleportEvent((EntityLivingBase)entity, x, y, z, 0.0f)))) {
            return null;
        }
        TeleportEntity.addTeleportSoundsAndParticles(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (!entity.field_70170_p.field_72995_K && entity.field_70170_p instanceof WorldServer) {
            MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
            WorldServer worldServerDst = minecraftserver.func_71218_a(dimDst);
            if (worldServerDst == null) {
                EnderUtilities.logger.warn("teleportEntity(): worldServerDst == null");
                return null;
            }
            IChunkProvider chunkProvider = worldServerDst.func_72863_F();
            if (chunkProvider == null) {
                return null;
            }
            if (!chunkProvider.func_73149_a((int)x >> 4, (int)z >> 4)) {
                chunkProvider.func_73158_c((int)x >> 4, (int)z >> 4);
            }
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70657_f(0.0f);
                ((EntityLiving)entity).func_70661_as().func_75499_g();
            }
            if (entity.field_71093_bK != dimDst || entity.field_70170_p instanceof WorldServer && entity.field_70170_p != worldServerDst) {
                entity = TeleportEntity.transferEntityToDimension(entity, dimDst, x, y, z);
            } else if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_70634_a(x, y, z);
            } else if (forceRecreate) {
                entity = TeleportEntity.reCreateEntity(entity, x, y, z);
            } else if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70634_a(x, y, z);
            } else {
                entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            }
        }
        if (entity != null) {
            TeleportEntity.addTeleportSoundsAndParticles(entity.field_70170_p, x, y, z);
        }
        return entity;
    }

    public static Entity reCreateEntity(Entity entitySrc, double x, double y, double z) {
        if (entitySrc.field_70170_p.field_72995_K) {
            return null;
        }
        WorldServer worldServerDst = MinecraftServer.func_71276_C().func_71218_a(entitySrc.field_71093_bK);
        if (worldServerDst == null) {
            EnderUtilities.logger.warn("reCreateEntity(): worldServerDst == null");
            return null;
        }
        Entity entityDst = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entitySrc), (World)worldServerDst);
        if (entityDst == null) {
            return null;
        }
        entitySrc.field_70170_p.func_72900_e(entitySrc);
        entitySrc.field_70128_L = false;
        entityDst.func_82141_a(entitySrc, true);
        if (entityDst instanceof EntityLivingBase) {
            ((EntityLivingBase)entityDst).func_70634_a(x, y, z);
        } else {
            entityDst.func_70012_b(x, y, z, entitySrc.field_70177_z, entitySrc.field_70125_A);
        }
        worldServerDst.func_72838_d(entityDst);
        worldServerDst.func_82742_i();
        entitySrc.field_70128_L = true;
        return entityDst;
    }

    public static Entity transferEntityToDimension(Entity entitySrc, int dimDst, double x, double y, double z) {
        if (entitySrc == null || entitySrc.field_70128_L || entitySrc.field_71093_bK == dimDst || entitySrc.field_70170_p.field_72995_K) {
            return null;
        }
        if (entitySrc instanceof EntityPlayerMP) {
            return TeleportEntity.transferPlayerToDimension((EntityPlayerMP)entitySrc, dimDst, x, y, z);
        }
        WorldServer worldServerSrc = MinecraftServer.func_71276_C().func_71218_a(entitySrc.field_71093_bK);
        WorldServer worldServerDst = MinecraftServer.func_71276_C().func_71218_a(dimDst);
        if (worldServerSrc == null || worldServerDst == null) {
            EnderUtilities.logger.warn("transferEntityToDimension(): worldServer[Src|Dst] == null");
            return null;
        }
        entitySrc.func_70078_a((Entity)null);
        if (entitySrc.field_70153_n != null) {
            entitySrc.field_70153_n.func_70078_a((Entity)null);
        }
        entitySrc.field_71093_bK = dimDst;
        Entity entityDst = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entitySrc), (World)worldServerDst);
        if (entityDst == null) {
            return null;
        }
        entityDst.func_82141_a(entitySrc, true);
        if (entitySrc instanceof EntityMinecartContainer) {
            entitySrc.field_70128_L = true;
        } else {
            entitySrc.field_70170_p.func_72900_e(entitySrc);
        }
        x = MathHelper.func_151237_a((double)x, (double)-3.0E7, (double)3.0E7);
        z = MathHelper.func_151237_a((double)z, (double)-3.0E7, (double)3.0E7);
        entityDst.func_70012_b(x, y, z, entitySrc.field_70177_z, entitySrc.field_70125_A);
        worldServerDst.func_72838_d(entityDst);
        worldServerDst.func_72866_a(entityDst, false);
        entityDst.func_70029_a((World)worldServerDst);
        entitySrc.field_70128_L = true;
        worldServerSrc.func_82742_i();
        worldServerDst.func_82742_i();
        return entityDst;
    }

    public static EntityPlayerMP transferPlayerToDimension(EntityPlayerMP player, int dimDst, double x, double y, double z) {
        if (player == null || player.field_70128_L || player.field_71093_bK == dimDst || player.field_70170_p.field_72995_K) {
            return null;
        }
        PlayerEvent.PlayerChangedDimensionEvent pcdEvent = new PlayerEvent.PlayerChangedDimensionEvent((EntityPlayer)player, player.field_71093_bK, dimDst);
        if (FMLCommonHandler.instance().bus().post((Event)pcdEvent)) {
            return null;
        }
        int dimSrc = player.field_71093_bK;
        x = MathHelper.func_151237_a((double)x, (double)-3.0E7, (double)3.0E7);
        z = MathHelper.func_151237_a((double)z, (double)-3.0E7, (double)3.0E7);
        player.func_70012_b(x, y, z, player.field_70177_z, player.field_70125_A);
        ServerConfigurationManager serverCM = player.field_71133_b.func_71203_ab();
        WorldServer worldServerSrc = MinecraftServer.func_71276_C().func_71218_a(dimSrc);
        WorldServer worldServerDst = MinecraftServer.func_71276_C().func_71218_a(dimDst);
        if (worldServerSrc == null || worldServerDst == null) {
            EnderUtilities.logger.warn("transferPlayerToDimension(): worldServer[Src|Dst] == null");
            return null;
        }
        player.field_71093_bK = dimDst;
        player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldServerSrc.func_72900_e((Entity)player);
        player.field_70128_L = false;
        player.func_70078_a((Entity)null);
        if (player.field_70153_n != null) {
            player.field_70153_n.func_70078_a((Entity)null);
        }
        worldServerDst.func_72838_d((Entity)player);
        worldServerDst.func_72866_a((Entity)player, false);
        player.func_70029_a((World)worldServerDst);
        serverCM.func_72375_a(player, worldServerSrc);
        player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldServerDst);
        player.field_71133_b.func_71203_ab().func_72354_b(player, worldServerDst);
        player.field_71133_b.func_71203_ab().func_72385_f(player);
        player.func_71023_q(0);
        player.func_71118_n();
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, dimSrc, dimDst);
        return player;
    }
}

