/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.nbt;

import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NBTHelperPlayer {
    public long playerUUIDMost = 0L;
    public long playerUUIDLeast = 0L;
    public String playerName = "";
    public boolean isPublic = false;
    public UUID playerUUID;

    public static boolean nbtHasPlayerTag(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("Player", 10)) {
            return false;
        }
        NBTTagCompound tag = nbt.func_74775_l("Player");
        return tag != null && tag.func_150297_b("UUIDM", 4) && tag.func_150297_b("UUIDL", 4) && tag.func_150297_b("Name", 8);
    }

    public static boolean itemHasPlayerTag(ItemStack stack) {
        return stack != null && NBTHelperPlayer.nbtHasPlayerTag(stack.func_77978_p());
    }

    public static boolean selectedModuleHasPlayerTag(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        return NBTHelperPlayer.itemHasPlayerTag(UtilItemModular.getSelectedModuleStack(toolStack, moduleType));
    }

    public NBTTagCompound readFromNBT(NBTTagCompound nbt) {
        if (!NBTHelperPlayer.nbtHasPlayerTag(nbt)) {
            return null;
        }
        NBTTagCompound tag = nbt.func_74775_l("Player");
        this.playerUUIDMost = tag.func_74763_f("UUIDM");
        this.playerUUIDLeast = tag.func_74763_f("UUIDL");
        this.playerName = tag.func_74779_i("Name");
        this.isPublic = tag.func_74767_n("Public");
        this.playerUUID = new UUID(this.playerUUIDMost, this.playerUUIDLeast);
        return tag;
    }

    public String getPlayerName() {
        if (this.playerName == null) {
            this.playerName = "";
        }
        return this.playerName;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return NBTHelperPlayer.writePlayerTagToNBT(nbt, this.playerUUIDMost, this.playerUUIDLeast, this.playerName, this.isPublic);
    }

    public boolean writeToItem(ItemStack stack) {
        if (stack != null) {
            stack.func_77982_d(this.writeToNBT(stack.func_77978_p()));
            return true;
        }
        return false;
    }

    public boolean writeToSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(toolStack, moduleType);
        if (moduleStack != null) {
            if (!this.writeToItem(moduleStack)) {
                return false;
            }
            UtilItemModular.setSelectedModuleStack(toolStack, moduleType, moduleStack);
            return true;
        }
        return false;
    }

    public static NBTTagCompound writePlayerTagToNBT(NBTTagCompound nbt, long most, long least, String name, boolean isPublic) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("UUIDM", most);
        tag.func_74772_a("UUIDL", least);
        tag.func_74778_a("Name", name);
        tag.func_74757_a("Public", isPublic);
        nbt.func_74782_a("Player", (NBTBase)tag);
        return nbt;
    }

    public static NBTTagCompound writePlayerTagToNBT(NBTTagCompound nbt, EntityPlayer player, boolean isPublic) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (player == null) {
            nbt.func_82580_o("Player");
            return nbt;
        }
        return NBTHelperPlayer.writePlayerTagToNBT(nbt, player.func_110124_au().getMostSignificantBits(), player.func_110124_au().getLeastSignificantBits(), player.func_70005_c_(), isPublic);
    }

    public static NBTTagCompound writePlayerTagToNBT(NBTTagCompound nbt, EntityPlayer player) {
        return NBTHelperPlayer.writePlayerTagToNBT(nbt, player, true);
    }

    public static void writePlayerTagToItem(ItemStack stack, EntityPlayer player, boolean isPublic) {
        if (stack != null) {
            stack.func_77982_d(NBTHelperPlayer.writePlayerTagToNBT(stack.func_77978_p(), player, isPublic));
        }
    }

    public static boolean writePlayerTagToSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType, EntityPlayer player, boolean isPublic) {
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(toolStack, moduleType);
        if (moduleStack != null) {
            NBTHelperPlayer.writePlayerTagToItem(moduleStack, player, isPublic);
            UtilItemModular.setSelectedModuleStack(toolStack, moduleType, moduleStack);
            return true;
        }
        return false;
    }

    public static NBTHelperPlayer getPlayerDataFromNBT(NBTTagCompound nbt) {
        NBTHelperPlayer player = new NBTHelperPlayer();
        if (player.readFromNBT(nbt) != null) {
            return player;
        }
        return null;
    }

    public static NBTHelperPlayer getPlayerDataFromItem(ItemStack stack) {
        if (stack != null) {
            return NBTHelperPlayer.getPlayerDataFromNBT(stack.func_77978_p());
        }
        return null;
    }

    public static NBTHelperPlayer getPlayerDataFromSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        return NBTHelperPlayer.getPlayerDataFromItem(UtilItemModular.getSelectedModuleStack(toolStack, moduleType));
    }

    public boolean isOwner(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        return this.playerUUIDMost == player.func_110124_au().getMostSignificantBits() && this.playerUUIDLeast == player.func_110124_au().getLeastSignificantBits();
    }

    public boolean canAccess(EntityPlayer player) {
        return this.isPublic || this.isOwner(player);
    }

    public static boolean isOwnerOfItem(ItemStack stack, EntityPlayer player) {
        NBTHelperPlayer playerData;
        if (stack != null && stack.func_77978_p() != null && (playerData = new NBTHelperPlayer()).readFromNBT(stack.func_77978_p()) != null) {
            return playerData.isOwner(player);
        }
        return false;
    }

    public static boolean isOwnerOfSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType, EntityPlayer player) {
        return NBTHelperPlayer.isOwnerOfItem(UtilItemModular.getSelectedModuleStack(toolStack, moduleType), player);
    }

    public static boolean canAccessItem(ItemStack stack, EntityPlayer player) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77978_p() == null) {
            return true;
        }
        NBTHelperPlayer playerData = NBTHelperPlayer.getPlayerDataFromItem(stack);
        return playerData == null || playerData.isPublic || playerData.isOwner(player);
    }

    public static boolean canAccessSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType, EntityPlayer player) {
        return NBTHelperPlayer.canAccessItem(UtilItemModular.getSelectedModuleStack(toolStack, moduleType), player);
    }
}

