/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPosEU {
    public int posX;
    public int posY;
    public int posZ;

    public BlockPosEU(int x, int y, int z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public BlockPosEU(BlockPosEU old) {
        this.posX = old.posX;
        this.posY = old.posY;
        this.posZ = old.posZ;
    }

    public BlockPosEU(BlockPosEU old, ForgeDirection dir, int distance) {
        this(old);
        this.offset(dir, distance);
    }

    public void add(int x, int y, int z) {
        this.posX += x;
        this.posY += y;
        this.posZ += z;
    }

    public void offset(ForgeDirection dir, int distance) {
        this.posX += dir.offsetX * distance;
        this.posY += dir.offsetY * distance;
        this.posZ += dir.offsetZ * distance;
    }

    public void clampCoords() {
        this.posX = MathHelper.func_76125_a((int)this.posX, (int)-30000000, (int)30000000);
        this.posY = MathHelper.func_76125_a((int)this.posY, (int)0, (int)255);
        this.posZ = MathHelper.func_76125_a((int)this.posZ, (int)-30000000, (int)30000000);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.posX;
        result = 31 * result + this.posY;
        result = 31 * result + this.posZ;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockPosEU other = (BlockPosEU)obj;
        if (this.posX != other.posX) {
            return false;
        }
        if (this.posY != other.posY) {
            return false;
        }
        return this.posZ == other.posZ;
    }
}

