/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.client.effects.Particles;
import fi.dy.masa.enderutilities.creativetab.CreativeTab;
import fi.dy.masa.enderutilities.entity.EntityEndermanFighter;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderCapacitor;
import fi.dy.masa.enderutilities.item.part.ItemLinkCrystal;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageAddEffects;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.reference.ReferenceMaterial;
import fi.dy.masa.enderutilities.reference.ReferenceNames;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EnergyBridgeTracker;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class ItemEnderSword
extends ItemSword
implements IKeyBound,
IModular {
    public static final int ENDER_CHARGE_COST = 50;
    public static final int MODE_SUMMON = 3;
    private float damageVsEntity;
    private final Item.ToolMaterial material = ReferenceMaterial.Tool.ENDER_ALLOY_ADVANCED;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconEmpty;
    @SideOnly(value=Side.CLIENT)
    String[] parts;

    public ItemEnderSword() {
        super(ReferenceMaterial.Tool.ENDER_ALLOY_ADVANCED);
        this.func_77625_d(1);
        this.func_77656_e(this.material.func_77997_a());
        this.setNoRepair();
        this.damageVsEntity = 5.0f + this.material.func_78000_c();
        this.func_77637_a(CreativeTab.ENDER_UTILITIES_TAB);
        this.func_77655_b(ReferenceNames.getPrefixedName("endersword"));
        this.func_111206_d(ReferenceTextures.getItemTextureName("endersword"));
    }

    public float func_150931_i() {
        return this.damageVsEntity;
    }

    public boolean addToolDamage(ItemStack stack, int amount, EntityLivingBase living1, EntityLivingBase living2) {
        if (stack == null || this.isToolBroken(stack)) {
            return false;
        }
        amount = Math.min(amount, this.getMaxDamage(stack) - stack.func_77960_j());
        stack.func_77972_a(amount, living2);
        if (this.isToolBroken(stack)) {
            living1.func_70669_a(stack);
        }
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.func_77997_a();
    }

    public boolean isToolBroken(ItemStack stack) {
        return stack == null || stack.func_77960_j() >= this.getMaxDamage(stack);
    }

    public float func_150893_a(ItemStack stack, Block block) {
        if (this.isToolBroken(stack)) {
            return 0.2f;
        }
        if (block == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = block.func_149688_o();
        if (material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151589_v || material == Material.field_151584_j || material == Material.field_151572_C) {
            return 1.5f;
        }
        return 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase targetEntity, EntityLivingBase attacker) {
        if (targetEntity != null && !targetEntity.field_70170_p.field_72995_K && this.getSwordMode(stack) == 3) {
            this.summonFighterEndermen(targetEntity.field_70170_p, targetEntity, 3);
        }
        return this.addToolDamage(stack, 1, targetEntity, attacker);
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase livingbase) {
        if (block.func_149712_f(world, x, y, z) != 0.0f && !this.isToolBroken(stack)) {
            int amount = Math.min(2, this.getMaxDamage(stack) - stack.func_77960_j());
            stack.func_77972_a(amount, livingbase);
            if (this.isToolBroken(stack)) {
                livingbase.func_70669_a(stack);
            }
            return true;
        }
        return false;
    }

    private IInventory getLinkedInventoryWithChecks(ItemStack toolStack, EntityPlayer player) {
        byte mode = this.getSwordMode(toolStack);
        if (mode == 0) {
            return null;
        }
        if (mode == 1 && !(player instanceof FakePlayer) && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE) >= 0) {
            return player.field_71071_by;
        }
        if (mode == 2 && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE) >= 1 && UtilItemModular.useEnderCharge(toolStack, 50, false)) {
            NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (this.getSelectedModuleTier(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) != 1 || target == null) {
                return null;
            }
            if ("minecraft:ender_chest".equals(target.blockName)) {
                return player.func_71005_bN();
            }
            if (!NBTHelperPlayer.canAccessSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player) || target.dimension != player.field_71093_bK && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE) < 2) {
                return null;
            }
            WorldServer targetWorld = MinecraftServer.func_71276_C().func_71218_a(target.dimension);
            if (targetWorld == null) {
                return null;
            }
            ChunkLoading.getInstance().loadChunkForcedWithPlayerTicket(player, target.dimension, target.posX >> 4, target.posZ >> 4, 30);
            TileEntity te = targetWorld.func_147438_o(target.posX, target.posY, target.posZ);
            if (te == null || !(te instanceof IInventory) || !target.isTargetBlockUnchanged()) {
                NBTHelperTarget.removeTargetTagFromSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("enderutilities.chat.message.bound.block.changed", new Object[0]));
                return null;
            }
            return (IInventory)te;
        }
        return null;
    }

    public void handleLivingDropsEvent(ItemStack toolStack, LivingDropsEvent event) {
        if (this.isToolBroken(toolStack) || event.drops == null || event.drops.size() == 0) {
            return;
        }
        byte mode = this.getSwordMode(toolStack);
        if (mode == 0 || mode == 3) {
            return;
        }
        boolean transported = false;
        EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
        IInventory inv = this.getLinkedInventoryWithChecks(toolStack, player);
        if (inv != null) {
            Iterator iter = event.drops.iterator();
            if (inv instanceof InventoryPlayer) {
                while (iter.hasNext()) {
                    ItemStack stack = ((EntityItem)iter.next()).func_92059_d();
                    if (stack == null || !player.field_71071_by.func_70441_a(stack.func_77946_l())) continue;
                    iter.remove();
                    transported = true;
                }
            } else {
                NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                while (iter.hasNext()) {
                    ItemStack stack = ((EntityItem)iter.next()).func_92059_d();
                    if (stack == null || !InventoryUtils.tryInsertItemStackToInventory(inv, stack.func_77946_l(), target.blockFace)) continue;
                    iter.remove();
                    transported = true;
                }
            }
        } else if (this.getSelectedModuleTier(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 0) {
            NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (!NBTHelperPlayer.canAccessSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player) || target.dimension != player.field_71093_bK && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE) < 2) {
                return;
            }
            WorldServer targetWorld = MinecraftServer.func_71276_C().func_71218_a(target.dimension);
            if (targetWorld == null) {
                return;
            }
            ChunkLoading.getInstance().loadChunkForcedWithPlayerTicket(player, target.dimension, target.posX >> 4, target.posZ >> 4, 30);
            Iterator iter = event.drops.iterator();
            while (iter.hasNext()) {
                ItemStack stack = ((EntityItem)iter.next()).func_92059_d();
                if (stack == null) continue;
                EntityItem entityItem = new EntityItem((World)targetWorld, target.dPosX, target.dPosY + 0.125, target.dPosZ, stack.func_77946_l());
                entityItem.field_70179_y = 0.0;
                entityItem.field_70159_w = 0.0;
                entityItem.field_70181_x = 0.15;
                if (!targetWorld.func_72838_d((Entity)entityItem)) continue;
                Particles.spawnParticles((World)targetWorld, "portal", target.dPosX, target.dPosY, target.dPosZ, 3, 0.2, 1.0);
                iter.remove();
                transported = true;
            }
        }
        if (transported) {
            if (mode == 2) {
                UtilItemModular.useEnderCharge(toolStack, 50, true);
            }
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAddEffects(2, 3, event.entity.field_70165_t + 0.5, event.entity.field_70163_u + 0.5, event.entity.field_70161_v + 0.5, 8, 0.2, 0.3), new NetworkRegistry.TargetPoint(event.entity.field_71093_bK, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, 24.0));
        }
    }

    private void summonFighterEndermen(World world, EntityLivingBase targetEntity, int amount) {
        if (targetEntity instanceof EntityEndermanFighter) {
            return;
        }
        double r = 16.0;
        double x = targetEntity.field_70165_t;
        double y = targetEntity.field_70163_u;
        double z = targetEntity.field_70161_v;
        int numReTargeted = 0;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(x - r), (double)(y - r), (double)(z - r), (double)(x + r), (double)(y + r), (double)(z + r));
        List list = world.func_72872_a(EntityEndermanFighter.class, bb);
        for (EntityEndermanFighter fighter : list) {
            if (fighter.func_70777_m() != null || fighter.func_94056_bM()) continue;
            fighter.setTargetCommanded((Entity)targetEntity);
            ++numReTargeted;
        }
        if (numReTargeted >= amount) {
            return;
        }
        int count = numReTargeted;
        for (int i = 0; i < 64; ++i) {
            x = targetEntity.field_70165_t - 5.0 + (double)world.field_73012_v.nextFloat() * 10.0;
            y = targetEntity.field_70163_u - 2.0 + (double)world.field_73012_v.nextFloat() * 4.0;
            z = targetEntity.field_70161_v - 5.0 + (double)world.field_73012_v.nextFloat() * 10.0;
            EntityEndermanFighter fighter = new EntityEndermanFighter(world);
            fighter.func_70107_b(x, targetEntity.field_70163_u, z);
            Block block = world.func_147439_a((int)x, (int)targetEntity.field_70163_u - 1, (int)z);
            if (!world.func_72945_a((Entity)fighter, fighter.field_70121_D).isEmpty() || world.func_72953_d(fighter.field_70121_D) || !block.func_149688_o().func_76230_c()) continue;
            for (int j = 0; j < 16; ++j) {
                float vx = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                float vy = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                float vz = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                world.func_72869_a("portal", x, y, z, (double)vx, (double)vy, (double)vz);
            }
            world.func_72908_a(x, y, z, "mob.endermen.portal", 1.0f, 1.0f);
            world.func_72838_d((Entity)fighter);
            fighter.setTargetCommanded((Entity)targetEntity);
            if (++count >= amount) break;
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.material.func_77995_e();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (player != null && player.func_70093_af() && te != null && (te instanceof IInventory || te.getClass() == TileEntityEnderChest.class) && UtilItemModular.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 1) {
            UtilItemModular.setTarget(stack, player, x, y, z, side, hitX, hitY, hitZ, false, false);
            return true;
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int slot, boolean isCurrent) {
        super.func_77663_a(stack, world, player, slot, isCurrent);
        if (!world.field_72995_K && EnergyBridgeTracker.dimensionHasEnergyBridge(world.field_73011_w.field_76574_g) && (world.field_73011_w.field_76574_g == 1 || EnergyBridgeTracker.dimensionHasEnergyBridge(1))) {
            UtilItemModular.addEnderCharge(stack, 100, true);
        }
    }

    public boolean func_150897_b(Block block) {
        return block == Blocks.field_150321_G;
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return false;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        double dmg = this.damageVsEntity;
        if (this.isToolBroken(stack) || this.getSwordMode(stack) == 3) {
            dmg = 0.0;
        }
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", dmg, 0));
        return multimap;
    }

    public byte getSwordMode(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74771_c("Mode");
        }
        return 0;
    }

    public void setSwordMode(ItemStack stack, byte value) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74774_a("Mode", value);
    }

    public void changeSwordMode(ItemStack stack) {
        byte mode = this.getSwordMode(stack);
        if ((mode = (byte)(mode + 1)) > 3) {
            mode = 0;
        }
        this.setSwordMode(stack, mode);
    }

    public void changePrivacyMode(ItemStack stack, EntityPlayer player) {
        NBTHelperPlayer data = NBTHelperPlayer.getPlayerDataFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (data != null && data.isOwner(player)) {
            data.isPublic = !data.isPublic;
            data.writeToSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (stack == null || ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, ReferenceKeys.keypressActionIsReversed(key) || ReferenceKeys.keypressContainsShift(key));
        } else if (ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key) && !ReferenceKeys.keypressContainsControl(key)) {
            UtilItemModular.setTarget(stack, player, true);
        } else if (ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSwordMode(stack);
        } else if (ReferenceKeys.keypressContainsAlt(key) && !ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key)) {
            this.changePrivacyMode(stack, player);
        }
    }

    @Override
    public int getModuleCount(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getModuleCount(stack, moduleType);
    }

    @Override
    public int getMaxModules(ItemStack stack) {
        return 5;
    }

    @Override
    public int getMaxModules(ItemStack stack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack toolStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (!moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) || imodule.getModuleTier(moduleStack) == 0 || imodule.getModuleTier(moduleStack) == 1) {
            return this.getMaxModules(toolStack, moduleType);
        }
        return 0;
    }

    @Override
    public int getMaxModuleTier(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getMaxModuleTier(stack, moduleType);
    }

    @Override
    public int getSelectedModuleTier(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getSelectedModuleTier(stack, moduleType);
    }

    @Override
    public ItemStack getSelectedModuleStack(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getSelectedModuleStack(stack, moduleType);
    }

    @Override
    public ItemStack setSelectedModuleStack(ItemStack toolStack, ItemModule.ModuleType moduleType, ItemStack moduleStack) {
        return UtilItemModular.setSelectedModuleStack(toolStack, moduleType, moduleStack);
    }

    @Override
    public ItemStack changeSelectedModule(ItemStack stack, ItemModule.ModuleType moduleType, boolean reverse) {
        return UtilItemModular.changeSelectedModule(stack, moduleType, reverse);
    }

    @Override
    public List<NBTTagCompound> getAllModules(ItemStack stack) {
        return UtilItemModular.getAllModules(stack);
    }

    @Override
    public ItemStack setAllModules(ItemStack stack, List<NBTTagCompound> modules) {
        return UtilItemModular.setAllModules(stack, modules);
    }

    @Override
    public ItemStack setModule(ItemStack stack, int index, NBTTagCompound nbt) {
        return UtilItemModular.setModule(stack, index, nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        ItemStack linkCrystalStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        ItemStack capacitorStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
        int coreTier = this.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE);
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        String preDGreen = EnumChatFormatting.DARK_GREEN.toString();
        String preBlue = EnumChatFormatting.BLUE.toString();
        byte mode = this.getSwordMode(stack);
        String str = mode == 0 ? "enderutilities.tooltip.item.normal" : (mode == 1 ? "enderutilities.tooltip.item.endertool.playerinv" : (mode == 2 ? "enderutilities.tooltip.item.endertool.remote" : "enderutilities.tooltip.item.endersword.summon"));
        str = StatCollector.func_74838_a((String)str);
        list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.mode") + ": " + preDGreen + str + rst);
        str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.endercore") + ": ";
        if (coreTier >= 0) {
            String coreType = coreTier == 0 ? "enderutilities.tooltip.item.basic" : (coreTier == 1 ? "enderutilities.tooltip.item.enhanced" : "enderutilities.tooltip.item.advanced");
            coreType = StatCollector.func_74838_a((String)coreType);
            str = str + preDGreen + coreType + rst + " (" + preBlue + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.tier") + " " + (coreTier + 1) + rst + ")";
        } else {
            String preRed = EnumChatFormatting.RED.toString();
            str = str + preRed + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.none") + rst;
        }
        list.add(str);
        if (linkCrystalStack != null && linkCrystalStack.func_77973_b() instanceof ItemLinkCrystal) {
            String preWhiteIta = EnumChatFormatting.WHITE.toString() + EnumChatFormatting.ITALIC.toString();
            if (NBTHelperTarget.itemHasTargetTag(linkCrystalStack)) {
                ((ItemLinkCrystal)linkCrystalStack.func_77973_b()).addInformationSelective(linkCrystalStack, player, list, advancedTooltips, verbose);
            } else {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.notargetset"));
            }
            int num = UtilItemModular.getModuleCount(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            int sel = UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) + 1;
            String dName = linkCrystalStack.func_82837_s() ? preWhiteIta + linkCrystalStack.func_82833_r() + rst + " " : "";
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedlinkcrystal.short") + String.format(" %s(%s%d%s / %s%d%s)", dName, preBlue, sel, rst, preBlue, num, rst));
        } else {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.nolinkcrystals"));
        }
        if (capacitorStack != null && capacitorStack.func_77973_b() instanceof ItemEnderCapacitor) {
            ((ItemEnderCapacitor)capacitorStack.func_77973_b()).addInformationSelective(capacitorStack, player, list, advancedTooltips, verbose);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        ArrayList<String> tmpList = new ArrayList<String>();
        boolean verbose = EnderUtilities.proxy.isShiftKeyDown();
        if (stack != null && stack.func_77978_p() == null) {
            this.addTooltips(stack, tmpList, verbose);
            if (!verbose && tmpList.size() > 1) {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.holdshiftfordescription"));
            } else {
                list.addAll(tmpList);
            }
            return;
        }
        tmpList.clear();
        this.addInformationSelective(stack, player, tmpList, advancedTooltips, true);
        if (!verbose && tmpList.size() > 2) {
            tmpList.clear();
            this.addInformationSelective(stack, player, tmpList, advancedTooltips, false);
            list.add(tmpList.get(0));
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.holdshift"));
        } else {
            list.addAll(tmpList);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemEnderUtilities.addTooltips(this.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.parts = new String[]{"rod", "head.1", "head.2", "head.3", "head.4", "head.1.broken", "head.2.broken", "head.3.broken", "head.4.broken", "core.1", "core.2", "core.3", "capacitor.1", "capacitor.2", "capacitor.3", "linkcrystal.1", "linkcrystal.2"};
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + ".rod");
        this.iconEmpty = iconRegister.func_94245_a(ReferenceTextures.getItemTextureName("empty"));
        this.iconArray = new IIcon[this.parts.length];
        String prefix = this.func_111208_A() + ".";
        for (int i = 0; i < this.parts.length; ++i) {
            this.iconArray[i] = iconRegister.func_94245_a(prefix + this.parts[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        if (stack == null) {
            return this.field_77791_bV;
        }
        int i = 0;
        int tier = 0;
        switch (renderPass) {
            case 0: {
                break;
            }
            case 1: {
                i += this.getSwordMode(stack) + 1;
                if (!this.isToolBroken(stack)) break;
                i += 4;
                break;
            }
            case 2: {
                tier = this.getMaxModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE);
                if (tier >= 0) {
                    i += tier + 9;
                    break;
                }
                return this.iconEmpty;
            }
            case 3: {
                tier = this.getMaxModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
                if (tier >= 0) {
                    i += tier + 12;
                    break;
                }
                return this.iconEmpty;
            }
            case 4: {
                ItemStack lcStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                tier = lcStack != null && lcStack.func_77973_b() instanceof ItemLinkCrystal ? ((ItemLinkCrystal)lcStack.func_77973_b()).getModuleTier(lcStack) : this.getMaxModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                if (tier >= 0) {
                    i += tier + 15;
                    break;
                }
                return this.iconEmpty;
            }
            default: {
                return this.iconEmpty;
            }
        }
        if (i < 0 || i >= this.iconArray.length) {
            return this.iconEmpty;
        }
        return this.iconArray[i];
    }
}

