/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.creativetab.CreativeTab;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemEnderBucket
extends ItemLocationBoundModular
implements IKeyBound,
IFluidContainerItem {
    public static final double ENDER_CHARGE_COST = 0.2;
    public static final byte OPERATION_MODE_NORMAL = 0;
    public static final byte OPERATION_MODE_FILL_BUCKET = 1;
    public static final byte OPERATION_MODE_DRAIN_BUCKET = 2;
    public static final byte OPERATION_MODE_BINDING = 3;
    public static final byte LINK_MODE_DISABLED = 0;
    public static final byte LINK_MODE_ENABLED = 1;
    public static final int ENDER_BUCKET_MAX_AMOUNT = 16000;
    protected int capacity;
    @SideOnly(value=Side.CLIENT)
    public IIcon itemIconLinked;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] iconParts;

    public ItemEnderBucket() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("enderbucket");
        this.func_111206_d(ReferenceTextures.getItemTextureName("enderbucket") + ".32");
        this.func_77637_a(CreativeTab.ENDER_UTILITIES_TAB);
        this.setCapacity(Configs.enderBucketCapacity.getInt(16000));
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || this.getBucketLinkMode(stack) == 1 && !NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return false;
        }
        if (this.useBucketOnFluidBlock(stack, world, player, this.getBucketMode(stack))) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IFluidHandler) {
            if (this.getBucketMode(stack) == 3) {
                super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
                return true;
            }
            this.useBucketOnTank(stack, player, world, x, y, z, side, this.getBucketMode(stack));
            return true;
        }
        return false;
    }

    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (this.getBucketLinkMode(stack) == 1 && !NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return false;
        }
        if (this.useBucketOnFluidBlock(stack, world, player, this.getBucketMode(stack))) {
            return true;
        }
        return this.useBucketOnBlock(stack, player, world, x, y, z, side, hitX, hitY, hitZ, this.getBucketMode(stack));
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K || this.getBucketLinkMode(stack) == 1 && !NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return stack;
        }
        this.useBucketOnFluidBlock(stack, world, player, this.getBucketMode(stack));
        return stack;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = this.getFluidCached(stack);
        if (fluidStack != null && fluidStack.amount > 0 && fluidStack.getFluid() != null) {
            String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
            String fluidName = EnumChatFormatting.GREEN.toString() + fluidStack.getFluid().getLocalizedName(fluidStack) + rst;
            return StatCollector.func_74838_a((String)(this.func_77667_c(stack) + ".name")).trim() + " " + fluidName;
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        String fluidName;
        if (stack.func_77978_p() == null) {
            super.addInformationSelective(stack, player, list, advancedTooltips, verbose);
            return;
        }
        FluidStack fluidStack = this.getFluidCached(stack);
        String preNr = EnumChatFormatting.BLUE.toString();
        String preTxt = EnumChatFormatting.DARK_GREEN.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        int amount = 0;
        int capacity = this.getCapacityCached(stack, player);
        if (fluidStack != null && fluidStack.getFluid() != null) {
            amount = fluidStack.amount;
            fluidName = preTxt + fluidStack.getFluid().getLocalizedName(fluidStack) + rst;
        } else {
            fluidName = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.empty");
        }
        byte mode = this.getBucketMode(stack);
        byte linkMode = this.getBucketLinkMode(stack);
        String amountStr = String.format("%s%s%s mB / %s%s%s mB", preNr, EUStringUtils.formatNumberWithKSeparators(amount), rst, preNr, EUStringUtils.formatNumberWithKSeparators(capacity), rst);
        String modeStr = mode == 0 ? "enderutilities.tooltip.item.bucket.mode.normal" : (mode == 1 ? "enderutilities.tooltip.item.bucket.mode.fill" : (mode == 2 ? "enderutilities.tooltip.item.bucket.mode.drain" : (mode == 3 ? "enderutilities.tooltip.item.bucket.mode.bind" : "")));
        if (verbose) {
            if (linkMode == 1) {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.cached.fluid") + ": " + fluidName);
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.cached.amount") + ": " + amountStr);
            } else {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.fluid") + ": " + fluidName);
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.amount") + ": " + amountStr);
            }
        } else if (linkMode == 1) {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.cached.fluid.compact") + ": " + fluidName + " - " + amountStr);
        } else {
            list.add(fluidName + " - " + amountStr);
        }
        list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.mode") + ": " + StatCollector.func_74838_a((String)modeStr));
        if (linkMode == 1) {
            super.addInformationSelective(stack, player, list, advancedTooltips, verbose);
        }
    }

    public byte getBucketMode(ItemStack stack) {
        byte mode;
        NBTTagCompound nbt;
        if (stack != null && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b("Mode") && (mode = nbt.func_74771_c("Mode")) >= 0 && mode <= 3) {
            return mode;
        }
        return 0;
    }

    public byte getBucketLinkMode(ItemStack stack) {
        byte mode;
        NBTTagCompound nbt;
        if (stack != null && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b("Linked") && ((mode = nbt.func_74771_c("Linked")) == 0 || mode == 1)) {
            return mode;
        }
        return 0;
    }

    public boolean isTargetUsable(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (world == null) {
            return false;
        }
        Block targetBlock = world.func_147439_a(x, y, z);
        return targetBlock != null && targetBlock.func_149688_o() != null && world.func_72962_a(player, x, y, x) && player.func_82247_a(x, y, z, side, stack);
    }

    public boolean useBucketOnTank(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, byte bucketMode) {
        if (!this.isTargetUsable(stack, player, world, x, y, z, side)) {
            return false;
        }
        this.setCapacity(Configs.enderBucketCapacity.getInt(16000));
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IFluidHandler) {
            FluidStack fluidStack;
            ForgeDirection forgeDir = ForgeDirection.getOrientation((int)side);
            IFluidHandler iFluidHandler = (IFluidHandler)te;
            String blockName = Block.field_149771_c.func_148750_c((Object)world.func_147439_a(x, y, z));
            if (blockName != null && blockName.equals("ThermalExpansion:Tank")) {
                forgeDir = ForgeDirection.UP;
            }
            FluidStack storedFluidStack = this.getFluidWorker(stack, player);
            int storedFluidAmount = 0;
            if (storedFluidStack != null) {
                storedFluidAmount = storedFluidStack.amount;
            }
            if (bucketMode == 1 || bucketMode == 0 && !player.func_70093_af()) {
                FluidStack fluidStack2 = iFluidHandler.drain(forgeDir, 1000, false);
                int amount = this.getCapacityAvailable(stack, fluidStack2, player);
                if (amount > 0) {
                    if (amount > 1000) {
                        amount = 1000;
                    }
                    if (fluidStack2 != null && (storedFluidAmount == 0 || fluidStack2.isFluidEqual(storedFluidStack)) && (fluidStack2 = iFluidHandler.drain(forgeDir, amount, false)) != null && this.fillWorker(stack, fluidStack2, false, player) == fluidStack2.amount) {
                        fluidStack2 = iFluidHandler.drain(forgeDir, amount, true);
                        this.fillWorker(stack, fluidStack2, true, player);
                        return true;
                    }
                }
            } else if (storedFluidAmount > 0 && (fluidStack = this.drainWorker(stack, 1000, false, player)) != null && iFluidHandler.fill(forgeDir, fluidStack, false) > 0) {
                int amount = iFluidHandler.fill(forgeDir, fluidStack, true);
                this.drainWorker(stack, amount, true, player);
                return true;
            }
        }
        return false;
    }

    public boolean useBucketOnBlock(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, byte bucketMode) {
        FluidStack fs;
        if (!this.isTargetUsable(stack, player, world, x, y, z, side)) {
            return false;
        }
        this.setCapacity(Configs.enderBucketCapacity.getInt(16000));
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        x += dir.offsetX;
        y += dir.offsetY;
        z += dir.offsetZ;
        FluidStack storedFluidStack = this.getFluidWorker(stack, player);
        int storedFluidAmount = 0;
        if (storedFluidStack != null) {
            storedFluidAmount = storedFluidStack.amount;
        }
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return this.useBucketOnFluidBlock(stack, world, player, x, y, z, side, bucketMode);
        }
        if (storedFluidAmount >= 1000 && bucketMode != 1 && (fs = this.drainWorker(stack, 1000, false, player)) != null && fs.amount == 1000 && this.tryPlaceFluidBlock(world, x, y, z, storedFluidStack)) {
            this.drainWorker(stack, 1000, true, player);
            return true;
        }
        return false;
    }

    public boolean useBucketOnFluidBlock(ItemStack stack, World world, EntityPlayer player, byte bucketMode) {
        MovingObjectPosition mop = this.func_77621_a(world, player, true);
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return false;
        }
        int x = mop.field_72311_b;
        int y = mop.field_72312_c;
        int z = mop.field_72309_d;
        return this.useBucketOnFluidBlock(stack, world, player, x, y, z, mop.field_72310_e, bucketMode);
    }

    public boolean useBucketOnFluidBlock(ItemStack stack, World world, EntityPlayer player, int x, int y, int z, int side, byte bucketMode) {
        Block targetBlock = world.func_147439_a(x, y, z);
        if (!this.isTargetUsable(stack, player, world, x, y, z, side) || !targetBlock.func_149688_o().func_76224_d()) {
            return false;
        }
        FluidStack storedFluidStack = this.getFluidWorker(stack, player);
        FluidStack targetFluidStack = null;
        IFluidBlock iFluidBlock = null;
        int storedFluidAmount = 0;
        if (storedFluidStack != null) {
            storedFluidAmount = storedFluidStack.amount;
        }
        if (targetBlock instanceof IFluidBlock) {
            iFluidBlock = (IFluidBlock)targetBlock;
            targetFluidStack = iFluidBlock.drain(world, x, y, z, false);
        } else {
            if (targetBlock == Blocks.field_150358_i) {
                targetBlock = Blocks.field_150355_j;
            } else if (targetBlock == Blocks.field_150356_k) {
                targetBlock = Blocks.field_150353_l;
            }
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)targetBlock);
            if (fluid != null) {
                targetFluidStack = FluidRegistry.getFluidStack((String)fluid.getName(), (int)1000);
            }
        }
        if (bucketMode != 2 && (storedFluidAmount == 0 || this.getCapacityAvailable(stack, targetFluidStack, player) >= 1000 && storedFluidStack.isFluidEqual(targetFluidStack) && (!player.func_70093_af() || bucketMode == 1))) {
            if (iFluidBlock != null) {
                if (iFluidBlock.canDrain(world, x, y, z) && (targetFluidStack = iFluidBlock.drain(world, x, y, z, false)) != null && this.fillWorker(stack, targetFluidStack, false, player) == targetFluidStack.amount) {
                    targetFluidStack = iFluidBlock.drain(world, x, y, z, true);
                    this.fillWorker(stack, targetFluidStack, true, player);
                    return true;
                }
                return false;
            }
            if (targetFluidStack != null && world.func_72805_g(x, y, z) == 0 && this.fillWorker(stack, targetFluidStack, false, player) == targetFluidStack.amount && world.func_147468_f(x, y, z)) {
                this.fillWorker(stack, targetFluidStack, true, player);
                return true;
            }
        }
        if (storedFluidStack != null && storedFluidAmount >= 1000 && bucketMode != 1) {
            FluidStack fs;
            if ((!storedFluidStack.isFluidEqual(targetFluidStack) || player.func_70093_af() || world.func_72805_g(x, y, z) != 0) && (fs = this.drainWorker(stack, 1000, false, player)) != null && fs.amount == 1000 && this.tryPlaceFluidBlock(world, x, y, z, storedFluidStack)) {
                this.drainWorker(stack, 1000, true, player);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean tryPlaceFluidBlock(World world, int x, int y, int z, FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null || !fluidStack.getFluid().canBePlacedInWorld()) {
            return false;
        }
        Block block = fluidStack.getFluid().getBlock();
        if (block == Blocks.field_150355_j) {
            block = Blocks.field_150358_i;
        } else if (block == Blocks.field_150353_l) {
            block = Blocks.field_150356_k;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        if (!world.func_147437_c(x, y, z) && material.func_76220_a()) {
            return false;
        }
        if (world.field_73011_w.field_76575_d && block == Blocks.field_150358_i) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
                world.func_147480_a(x, y, z, true);
            }
            world.func_147465_d(x, y, z, block, 0, 3);
        }
        return true;
    }

    public ItemEnderBucket setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public int getCapacityCached(ItemStack stack, EntityPlayer player) {
        if (this.getBucketLinkMode(stack) == 1) {
            NBTTagCompound moduleNbt;
            ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (moduleStack != null && (moduleNbt = moduleStack.func_77978_p()) != null && moduleNbt.func_150297_b("CapacityCached", 3)) {
                return moduleNbt.func_74762_e("CapacityCached");
            }
            return 0;
        }
        return this.getCapacityWorker(stack, player);
    }

    public int getCapacityAvailable(ItemStack stack, FluidStack fluidStackIn, EntityPlayer player) {
        if (this.getBucketLinkMode(stack) == 1) {
            NBTHelperTarget targetData = this.getLinkedTankTargetData(stack);
            IFluidHandler tank = this.getLinkedTank(stack);
            if (targetData != null && tank != null) {
                FluidTankInfo[] info = tank.getTankInfo(targetData.forgeDir);
                FluidStack fluidStack = tank.drain(targetData.forgeDir, Integer.MAX_VALUE, false);
                if (fluidStack != null) {
                    FluidStack fs;
                    if (fluidStackIn != null) {
                        if (!fluidStack.isFluidEqual(fluidStackIn)) {
                            return 0;
                        }
                        fs = fluidStackIn.copy();
                    } else {
                        fs = fluidStack.copy();
                    }
                    if (info != null && info[0] != null) {
                        return info[0].capacity - fluidStack.amount;
                    }
                    fs.amount = Integer.MAX_VALUE;
                    return tank.fill(targetData.forgeDir, fs, false);
                }
                if (info != null && info[0] != null) {
                    return info[0].capacity;
                }
                if (fluidStackIn != null) {
                    FluidStack fs = fluidStackIn.copy();
                    fs.amount = Integer.MAX_VALUE;
                    return tank.fill(targetData.forgeDir, fs, false);
                }
                Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)Blocks.field_150355_j);
                if (fluid != null && (fluidStack = FluidRegistry.getFluidStack((String)fluid.getName(), (int)Integer.MAX_VALUE)) != null) {
                    return tank.fill(targetData.forgeDir, fluidStack, false);
                }
            }
            return 0;
        }
        FluidStack fluidStack = this.getFluidWorker(stack, player);
        if (fluidStack != null) {
            return this.getCapacityWorker(stack, player) - fluidStack.amount;
        }
        return this.getCapacityWorker(stack, player);
    }

    public void cacheFluid(ItemStack stack, FluidStack fluidStack) {
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (moduleStack != null) {
            NBTTagCompound moduleNbt = moduleStack.func_77978_p();
            if (moduleNbt == null) {
                moduleNbt = new NBTTagCompound();
            }
            if (fluidStack != null) {
                moduleNbt.func_74782_a("FluidCached", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
            } else {
                moduleNbt.func_82580_o("FluidCached");
            }
            moduleStack.func_77982_d(moduleNbt);
            this.setSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, moduleStack);
        }
        this.cacheCapacity(stack);
    }

    public void cacheCapacity(ItemStack stack) {
        ItemStack moduleStack;
        if (this.getBucketLinkMode(stack) == 1 && (moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL)) != null) {
            NBTTagCompound moduleNbt = moduleStack.func_77978_p();
            if (moduleNbt == null) {
                return;
            }
            IFluidHandler tank = this.getLinkedTank(stack);
            NBTHelperTarget targetData = this.getLinkedTankTargetData(stack);
            if (tank != null && targetData != null) {
                FluidTankInfo[] info = tank.getTankInfo(targetData.forgeDir);
                if (info != null && info[0] != null) {
                    moduleNbt.func_74768_a("CapacityCached", info[0].capacity);
                } else {
                    moduleNbt.func_74768_a("CapacityCached", 0);
                }
            } else {
                moduleNbt.func_82580_o("CapacityCached");
            }
            moduleStack.func_77982_d(moduleNbt);
            this.setSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, moduleStack);
        }
    }

    public NBTHelperTarget getLinkedTankTargetData(ItemStack stack) {
        NBTHelperTarget targetData = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (targetData == null) {
            return null;
        }
        if ("ThermalExpansion:Tank".equals(targetData.blockName)) {
            targetData.forgeDir = ForgeDirection.UP;
        }
        return targetData;
    }

    public IFluidHandler getLinkedTank(ItemStack stack) {
        NBTHelperTarget targetData = this.getLinkedTankTargetData(stack);
        if (targetData == null || MinecraftServer.func_71276_C() == null) {
            return null;
        }
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(targetData.dimension);
        if (world == null) {
            return null;
        }
        if (!ChunkLoading.getInstance().loadChunkForcedWithModTicket(targetData.dimension, targetData.posX >> 4, targetData.posZ >> 4, 30)) {
            return null;
        }
        TileEntity te = world.func_147438_o(targetData.posX, targetData.posY, targetData.posZ);
        if (te == null || !(te instanceof IFluidHandler)) {
            return null;
        }
        return (IFluidHandler)te;
    }

    public FluidStack getFluidCached(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return null;
        }
        if (this.getBucketLinkMode(stack) == 1) {
            ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (moduleStack != null && moduleStack.func_77978_p() != null && moduleStack.func_77978_p().func_150297_b("FluidCached", 10)) {
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)moduleStack.func_77978_p().func_74775_l("FluidCached"));
            }
            return null;
        }
        if (nbt.func_150297_b("Fluid", 10)) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
        }
        return null;
    }

    public int getCapacity(ItemStack stack) {
        return this.getCapacityWorker(stack, null);
    }

    private int getCapacityWorker(ItemStack stack, EntityPlayer player) {
        if (this.getBucketLinkMode(stack) == 0) {
            return this.capacity;
        }
        if (!NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return 0;
        }
        NBTHelperTarget targetData = this.getLinkedTankTargetData(stack);
        IFluidHandler tank = this.getLinkedTank(stack);
        if (targetData != null && tank != null) {
            FluidTankInfo[] info = tank.getTankInfo(targetData.forgeDir);
            if (info != null && info[0] != null) {
                return info[0].capacity;
            }
            FluidStack fluidStack = tank.drain(targetData.forgeDir, Integer.MAX_VALUE, false);
            if (fluidStack != null) {
                FluidStack fs = fluidStack.copy();
                fs.amount = Integer.MAX_VALUE;
                int space = tank.fill(targetData.forgeDir, fs, false);
                return space + fluidStack.amount;
            }
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)Blocks.field_150355_j);
            if (fluid != null && (fluidStack = FluidRegistry.getFluidStack((String)fluid.getName(), (int)Integer.MAX_VALUE)) != null) {
                return tank.fill(targetData.forgeDir, fluidStack, false);
            }
        }
        return 0;
    }

    public FluidStack getFluid(ItemStack stack) {
        return this.getFluidWorker(stack, null);
    }

    private FluidStack getFluidWorker(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return null;
        }
        if (this.getBucketLinkMode(stack) == 1) {
            if (!NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
                return null;
            }
            NBTHelperTarget targetData = this.getLinkedTankTargetData(stack);
            IFluidHandler tank = this.getLinkedTank(stack);
            if (targetData != null && tank != null) {
                FluidStack fluidStack = tank.drain(targetData.forgeDir, Integer.MAX_VALUE, false);
                this.cacheFluid(stack, fluidStack);
                return fluidStack;
            }
            return null;
        }
        if (nbt.func_150297_b("Fluid", 10)) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
        }
        return null;
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain) {
        return this.drainWorker(stack, maxDrain, doDrain, null);
    }

    private FluidStack drainWorker(ItemStack stack, int maxDrain, boolean doDrain, EntityPlayer player) {
        if (this.getBucketLinkMode(stack) == 1) {
            if (!NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
                return null;
            }
            NBTHelperTarget targetData = this.getLinkedTankTargetData(stack);
            IFluidHandler tank = this.getLinkedTank(stack);
            if (targetData != null && tank != null) {
                if (!UtilItemModular.useEnderCharge(stack, (int)(0.2 * (double)maxDrain), doDrain)) {
                    return null;
                }
                FluidStack fluidStack = tank.drain(targetData.forgeDir, maxDrain, doDrain);
                this.cacheFluid(stack, tank.drain(targetData.forgeDir, Integer.MAX_VALUE, false));
                return fluidStack;
            }
            return null;
        }
        int drained = 0;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Fluid", 10)) {
            return null;
        }
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
        if (fluidStack == null) {
            return null;
        }
        drained = Math.min(fluidStack.amount, maxDrain);
        if (doDrain) {
            if (drained >= fluidStack.amount) {
                nbt.func_82580_o("Fluid");
                if (nbt.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            } else {
                NBTTagCompound fluidTag = nbt.func_74775_l("Fluid");
                fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - drained);
                nbt.func_74782_a("Fluid", (NBTBase)fluidTag);
            }
        }
        fluidStack.amount = drained;
        return fluidStack;
    }

    public int fill(ItemStack stack, FluidStack fluidStackIn, boolean doFill) {
        return this.fillWorker(stack, fluidStackIn, doFill, null);
    }

    private int fillWorker(ItemStack stack, FluidStack fluidStackIn, boolean doFill, EntityPlayer player) {
        if (fluidStackIn == null) {
            return 0;
        }
        if (this.getBucketLinkMode(stack) == 1) {
            if (!NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
                return 0;
            }
            NBTHelperTarget targetData = this.getLinkedTankTargetData(stack);
            IFluidHandler tank = this.getLinkedTank(stack);
            if (targetData != null && tank != null) {
                if (fluidStackIn != null && !UtilItemModular.useEnderCharge(stack, (int)(0.2 * (double)fluidStackIn.amount), doFill)) {
                    return 0;
                }
                int amount = tank.fill(targetData.forgeDir, fluidStackIn, doFill);
                this.cacheFluid(stack, tank.drain(targetData.forgeDir, Integer.MAX_VALUE, false));
                return amount;
            }
            return 0;
        }
        int capacityAvailable = this.getCapacityAvailable(stack, fluidStackIn, player);
        NBTTagCompound nbt = stack.func_77978_p();
        if (!doFill) {
            if (nbt == null || !nbt.func_150297_b("Fluid", 10)) {
                return Math.min(capacityAvailable, fluidStackIn.amount);
            }
            FluidStack storedFluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
            if (storedFluidStack == null) {
                return Math.min(capacityAvailable, fluidStackIn.amount);
            }
            if (!storedFluidStack.isFluidEqual(fluidStackIn)) {
                return 0;
            }
            return Math.min(capacityAvailable, fluidStackIn.amount);
        }
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        if (!nbt.func_74764_b("Fluid")) {
            NBTTagCompound fluidTag = fluidStackIn.writeToNBT(new NBTTagCompound());
            if (capacityAvailable < fluidStackIn.amount) {
                fluidTag.func_74768_a("Amount", capacityAvailable);
                nbt.func_74782_a("Fluid", (NBTBase)fluidTag);
                return capacityAvailable;
            }
            nbt.func_74782_a("Fluid", (NBTBase)fluidTag);
            return fluidStackIn.amount;
        }
        NBTTagCompound fluidTag = nbt.func_74775_l("Fluid");
        FluidStack storedFluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (!storedFluidStack.isFluidEqual(fluidStackIn)) {
            return 0;
        }
        int filled = 0;
        if (fluidStackIn.amount < capacityAvailable) {
            storedFluidStack.amount += fluidStackIn.amount;
            filled = fluidStackIn.amount;
        } else {
            storedFluidStack.amount += capacityAvailable;
        }
        nbt.func_74782_a("Fluid", (NBTBase)storedFluidStack.writeToNBT(fluidTag));
        return filled;
    }

    @Override
    public int getMaxModules(ItemStack toolStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (!moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) || imodule.getModuleTier(moduleStack) == 1) {
            return this.getMaxModules(toolStack, moduleType);
        }
        return 0;
    }

    private void changeLinkMode(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74757_a("Linked", !nbt.func_74767_n("Linked"));
        stack.func_77982_d(nbt);
    }

    private void changeOperationMode(ItemStack stack) {
        byte val;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if ((val = (byte)(nbt.func_74771_c("Mode") + 1)) > 3 || val == 3 && this.getBucketLinkMode(stack) == 0) {
            val = 0;
        }
        nbt.func_74774_a("Mode", val);
        stack.func_77982_d(nbt);
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (stack == null || ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (key == 1) {
            this.changeOperationMode(stack);
        } else if (ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeLinkMode(stack);
        } else if (ReferenceKeys.keypressContainsControl(key)) {
            if (!ReferenceKeys.keypressContainsAlt(key) && this.getBucketLinkMode(stack) == 1) {
                super.doKeyBindingAction(player, stack, key);
            }
        } else {
            super.doKeyBindingAction(player, stack, key);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A());
        this.itemIconLinked = iconRegister.func_94245_a(this.func_111208_A() + ".linked");
        this.iconParts = new IIcon[12];
        this.iconParts[0] = iconRegister.func_94245_a(this.func_111208_A() + ".main.normal");
        this.iconParts[1] = iconRegister.func_94245_a(this.func_111208_A() + ".main.fill");
        this.iconParts[2] = iconRegister.func_94245_a(this.func_111208_A() + ".main.drain");
        this.iconParts[3] = iconRegister.func_94245_a(this.func_111208_A() + ".main.bind");
        this.iconParts[4] = iconRegister.func_94245_a(this.func_111208_A() + ".inside");
        this.iconParts[5] = iconRegister.func_94245_a(this.func_111208_A() + ".window");
        this.iconParts[6] = iconRegister.func_94245_a(this.func_111208_A() + ".linked.main.normal");
        this.iconParts[7] = iconRegister.func_94245_a(this.func_111208_A() + ".linked.main.fill");
        this.iconParts[8] = iconRegister.func_94245_a(this.func_111208_A() + ".linked.main.drain");
        this.iconParts[9] = iconRegister.func_94245_a(this.func_111208_A() + ".linked.main.bind");
        this.iconParts[10] = iconRegister.func_94245_a(this.func_111208_A() + ".linked.inside");
        this.iconParts[11] = iconRegister.func_94245_a(this.func_111208_A() + ".linked.window");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconPart(int i) {
        if (i >= this.iconParts.length) {
            i = 0;
        }
        return this.iconParts[i];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        if (this.getBucketLinkMode(stack) == 1 && this.getBucketMode(stack) == 0) {
            return this.itemIconLinked;
        }
        return this.field_77791_bV;
    }
}

