/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import fi.dy.masa.enderutilities.gui.EnderUtilitiesGUIHandler;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.proxy.IProxy;
import fi.dy.masa.enderutilities.setup.ConfigReader;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.setup.Registry;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EnergyBridgeTracker;
import org.apache.logging.log4j.Logger;

@Mod(modid="enderutilities", name="Ender Utilities", version="0.4.1")
public class EnderUtilities {
    @Mod.Instance(value="enderutilities")
    public static EnderUtilities instance;
    @SidedProxy(clientSide="fi.dy.masa.enderutilities.proxy.ClientProxy", serverSide="fi.dy.masa.enderutilities.proxy.ServerProxy")
    public static IProxy proxy;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        logger = event.getModLog();
        ConfigReader.loadConfigsAll(event.getSuggestedConfigurationFile());
        proxy.registerKeyBindings();
        PacketHandler.init();
        EnderUtilitiesItems.init();
        EnderUtilitiesBlocks.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerEntities();
        proxy.registerEventHandlers();
        proxy.registerRenderers();
        proxy.registerTileEntities();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new EnderUtilitiesGUIHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Registry.registerEnderbagLists();
        Registry.registerTeleportBlacklist();
    }

    @Mod.EventHandler
    public void onServerStartingEvent(FMLServerStartingEvent event) {
        ChunkLoading.getInstance().init();
        EnergyBridgeTracker.readFromDisk();
    }
}

