/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock.renderer;

import io.endertech.multiblock.texture.ConnectedTextureIcon;
import io.endertech.util.helper.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class ConnectedRenderBlocks
extends RenderBlocks {
    public static final ForgeDirection[][] neighborsBySide = new ForgeDirection[][]{{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}, {ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}, {ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.WEST}, {ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.WEST, ForgeDirection.EAST}, {ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.SOUTH}, {ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.NORTH}};
    private Block block;
    private int meta;

    public static boolean checkBit(int a, int b) {
        return (a & b) == b;
    }

    public void setBlockToCompareTo(Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    public void setBlockAccess(IBlockAccess blockAccess) {
        this.field_147845_a = blockAccess;
    }

    public void renderSideFace(ConnectedTextureIcon icon, int index, double x, double y, double z, int side) {
        icon.setCurrentRenderIcon(index);
        switch (side) {
            case 0: {
                super.func_147768_a(this.block, x, y, z, (IIcon)icon);
                break;
            }
            case 1: {
                super.func_147806_b(this.block, x, y, z, (IIcon)icon);
                break;
            }
            case 2: {
                super.func_147761_c(this.block, x, y, z, (IIcon)icon);
                break;
            }
            case 3: {
                super.func_147734_d(this.block, x, y, z, (IIcon)icon);
                break;
            }
            case 4: {
                super.func_147798_e(this.block, x, y, z, (IIcon)icon);
                break;
            }
            case 5: {
                super.func_147764_f(this.block, x, y, z, (IIcon)icon);
            }
        }
    }

    public int[] calculateConnectednessIndexes(IBlockAccess blockAccess, int x, int y, int z, int face) {
        int[] iconIndexes = new int[5];
        for (int i = 0; i < 4; ++i) {
            ForgeDirection dir = neighborsBySide[face][i];
            if (!BlockHelper.areBlocksEqual(blockAccess, this.block, this.meta, x, y, z, dir)) continue;
            iconIndexes[i + 1] = this.calculateConnectednessForSingleBlock(blockAccess, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, face);
            iconIndexes[0] = iconIndexes[0] | 1 << i;
        }
        return iconIndexes;
    }

    public int calculateConnectednessForSingleBlock(IBlockAccess blockAccess, int x, int y, int z, int face) {
        int iconIndex = 0;
        for (int i = 0; i < 4; ++i) {
            ForgeDirection dir = neighborsBySide[face][i];
            if (!BlockHelper.areBlocksEqual(blockAccess, this.block, this.meta, x, y, z, dir)) continue;
            iconIndex |= 1 << i;
        }
        return iconIndex;
    }

    public void renderSide(Block b, double x, double y, double z, ConnectedTextureIcon icon, int side) {
        int ix = (int)x;
        int iy = (int)y;
        int iz = (int)z;
        ForgeDirection towards = ForgeDirection.getOrientation((int)side);
        if (BlockHelper.areBlocksEqual(this.field_147845_a, this.block, this.meta, ix, iy, iz, towards)) {
            return;
        }
        this.renderSideFace(icon, 0, x, y, z, side);
        int[] connectednessIndexes = this.calculateConnectednessIndexes(this.field_147845_a, ix, iy, iz, side);
        boolean connectedTop = ConnectedRenderBlocks.checkBit(connectednessIndexes[0], 1);
        boolean connectedBottom = ConnectedRenderBlocks.checkBit(connectednessIndexes[0], 2);
        boolean connectedLeft = ConnectedRenderBlocks.checkBit(connectednessIndexes[0], 4);
        boolean connectedRight = ConnectedRenderBlocks.checkBit(connectednessIndexes[0], 8);
        boolean topConnectedLeft = ConnectedRenderBlocks.checkBit(connectednessIndexes[1], 4);
        boolean leftConnectedTop = ConnectedRenderBlocks.checkBit(connectednessIndexes[3], 1);
        boolean topConnectedRight = ConnectedRenderBlocks.checkBit(connectednessIndexes[1], 8);
        boolean rightConnectedTop = ConnectedRenderBlocks.checkBit(connectednessIndexes[4], 1);
        boolean bottomConnectedLeft = ConnectedRenderBlocks.checkBit(connectednessIndexes[2], 4);
        boolean leftConnectedBottom = ConnectedRenderBlocks.checkBit(connectednessIndexes[3], 2);
        boolean bottomConnectedRight = ConnectedRenderBlocks.checkBit(connectednessIndexes[2], 8);
        boolean rightConnectedBottom = ConnectedRenderBlocks.checkBit(connectednessIndexes[4], 2);
        if (!connectedTop) {
            this.renderSideFace(icon, 1, x, y, z, side);
        }
        if (!connectedBottom) {
            this.renderSideFace(icon, 2, x, y, z, side);
        }
        if (!connectedLeft) {
            this.renderSideFace(icon, 3, x, y, z, side);
        }
        if (!connectedRight) {
            this.renderSideFace(icon, 4, x, y, z, side);
        }
        if (connectedLeft && connectedTop && !topConnectedLeft && !leftConnectedTop) {
            this.renderSideFace(icon, 5, x, y, z, side);
        }
        if (connectedRight && connectedTop && !topConnectedRight && !rightConnectedTop) {
            this.renderSideFace(icon, 6, x, y, z, side);
        }
        if (connectedBottom && connectedLeft && !bottomConnectedLeft && !leftConnectedBottom) {
            this.renderSideFace(icon, 8, x, y, z, side);
        }
        if (connectedBottom && connectedRight && !bottomConnectedRight && !rightConnectedBottom) {
            this.renderSideFace(icon, 7, x, y, z, side);
        }
        icon.setCurrentRenderIcon(0);
    }

    public void func_147768_a(Block block, double x, double y, double z, IIcon icon) {
        if (this.func_147744_b()) {
            icon = this.field_147840_d;
        }
        if (icon instanceof ConnectedTextureIcon) {
            this.renderSide(block, x, y, z, (ConnectedTextureIcon)icon, 0);
        } else {
            super.func_147768_a(block, x, y, z, icon);
        }
    }

    public void func_147806_b(Block block, double x, double y, double z, IIcon icon) {
        if (this.func_147744_b()) {
            icon = this.field_147840_d;
        }
        if (icon instanceof ConnectedTextureIcon) {
            this.renderSide(block, x, y, z, (ConnectedTextureIcon)icon, 1);
        } else {
            super.func_147806_b(block, x, y, z, icon);
        }
    }

    public void func_147761_c(Block block, double x, double y, double z, IIcon icon) {
        if (this.func_147744_b()) {
            icon = this.field_147840_d;
        }
        if (icon instanceof ConnectedTextureIcon) {
            this.renderSide(block, x, y, z, (ConnectedTextureIcon)icon, 2);
        } else {
            super.func_147761_c(block, x, y, z, icon);
        }
    }

    public void func_147734_d(Block block, double x, double y, double z, IIcon icon) {
        if (this.func_147744_b()) {
            icon = this.field_147840_d;
        }
        if (icon instanceof ConnectedTextureIcon) {
            this.renderSide(block, x, y, z, (ConnectedTextureIcon)icon, 3);
        } else {
            super.func_147734_d(block, x, y, z, icon);
        }
    }

    public void func_147798_e(Block block, double x, double y, double z, IIcon icon) {
        if (this.func_147744_b()) {
            icon = this.field_147840_d;
        }
        if (icon instanceof ConnectedTextureIcon) {
            this.renderSide(block, x, y, z, (ConnectedTextureIcon)icon, 4);
        } else {
            super.func_147798_e(block, x, y, z, icon);
        }
    }

    public void func_147764_f(Block block, double x, double y, double z, IIcon icon) {
        if (this.func_147744_b()) {
            icon = this.field_147840_d;
        }
        if (icon instanceof ConnectedTextureIcon) {
            this.renderSide(block, x, y, z, (ConnectedTextureIcon)icon, 5);
        } else {
            super.func_147764_f(block, x, y, z, icon);
        }
    }
}

