/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.block;

import cofh.api.block.IDismantleable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.endertech.EnderTech;
import io.endertech.block.BlockET;
import io.endertech.client.render.IconRegistry;
import io.endertech.tile.TilePad;
import io.endertech.util.BlockCoord;
import io.endertech.util.IOutlineDrawer;
import io.endertech.util.helper.TextureHelper;
import java.util.ArrayList;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockPad
extends BlockET
implements ITileEntityProvider,
IDismantleable,
IOutlineDrawer {
    public BlockPad() {
        super(Material.field_151573_f);
        this.func_149647_a(EnderTech.tabET);
        this.func_149711_c(10.0f);
        this.func_149752_b(20.0f);
    }

    public IIcon getPrimaryIcon(int meta, TilePad tile) {
        return tile.isActive ? this.getActiveIcon(meta) : this.getInactiveIcon(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        ForgeDirection orientation = ForgeDirection.getOrientation((int)side);
        if (orientation == ForgeDirection.UP) {
            return this.getTopIcon(meta);
        }
        if (orientation == ForgeDirection.DOWN) {
            return this.getBottomIcon(meta);
        }
        if (orientation == ForgeDirection.SOUTH) {
            return this.getInactiveIcon(meta);
        }
        return this.getSideIcon(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int iSide) {
        ForgeDirection side;
        TileEntity tileEntity = blockAccess.func_147438_o(x, y, z);
        int meta = blockAccess.func_72805_g(x, y, z);
        if (!(tileEntity instanceof TilePad)) {
            return this.getSideIcon(meta);
        }
        TilePad tile = (TilePad)tileEntity;
        ForgeDirection out = tile.getOrientation();
        if (out == (side = ForgeDirection.getOrientation((int)iSide))) {
            return this.getPrimaryIcon(meta, tile);
        }
        if (side == ForgeDirection.UP) {
            return this.getTopIcon(meta);
        }
        if (side == ForgeDirection.DOWN) {
            return this.getBottomIcon(meta);
        }
        return this.getSideIcon(meta);
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TilePad) {
            int direction = -1;
            if (MathHelper.func_76135_e((float)((float)entityLiving.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entityLiving.field_70161_v - (float)z)) < 2.0f) {
                double d0 = entityLiving.field_70163_u + 1.82 - (double)entityLiving.field_70129_M;
                if (d0 - (double)y > 2.0) {
                    direction = ForgeDirection.UP.ordinal();
                }
                if ((double)y - d0 > 0.0) {
                    direction = ForgeDirection.DOWN.ordinal();
                }
            }
            TilePad tile = (TilePad)tileEntity;
            if (direction == -1) {
                super.func_149689_a(world, x, y, z, entityLiving, itemStack);
            } else {
                tile.setOrientation(direction);
            }
            NBTTagCompound nbtTagCompound = itemStack.field_77990_d;
            if (nbtTagCompound == null) {
                nbtTagCompound = new NBTTagCompound();
            }
            tile.readStateFromNBT(nbtTagCompound);
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int faceHit, float par7, float par8, float par9) {
        return super.func_149727_a(world, x, y, z, player, faceHit, par7, par8, par9);
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnDrops) {
        return BlockET.dismantleBlockInWorld(player, world, x, y, z, returnDrops);
    }

    @Override
    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        return true;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @Override
    public boolean drawOutline(DrawBlockHighlightEvent event) {
        BlockCoord target = new BlockCoord(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
        World world = event.player.field_70170_p;
        TileEntity tile = world.func_147438_o(target.x, target.y, target.z);
        if (tile instanceof TilePad) {
            return ((TilePad)tile).drawOutline(event);
        }
        return false;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = worldObj.func_147438_o(x, y, z);
        if (!(tile instanceof TilePad)) {
            return false;
        }
        TilePad TilePad2 = (TilePad)tile;
        return TilePad2.setFacing(axis.ordinal());
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    public abstract IIcon getActiveIcon(int var1);

    public abstract IIcon getInactiveIcon(int var1);

    public IIcon getTopIcon(int meta) {
        return IconRegistry.getIcon("Machine_" + TextureHelper.metaToType(meta) + "_Top");
    }

    public IIcon getBottomIcon(int meta) {
        return IconRegistry.getIcon("Machine_" + TextureHelper.metaToType(meta) + "_Bottom");
    }

    public IIcon getSideIcon(int meta) {
        return IconRegistry.getIcon("Machine_" + TextureHelper.metaToType(meta) + "_Side");
    }
}

