/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.TabTracker;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.Rectangle4i;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class TabBase
extends ElementBase {
    public static int tabExpandSpeed = 8;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    protected int offsetX = 0;
    protected int offsetY = 0;
    public boolean open;
    public boolean fullyOpen;
    public int side = 1;
    public int headerColor = 14797103;
    public int subheaderColor = 11186104;
    public int textColor = 0;
    public int backgroundColor = 0xFFFFFF;
    protected int currentShiftX = 0;
    protected int currentShiftY = 0;
    public int minWidth = 22;
    public int maxWidth = 124;
    public int currentWidth = this.minWidth;
    public int minHeight = 22;
    public int maxHeight = 22;
    public int currentHeight = this.minHeight;
    public static final ResourceLocation DEFAULT_TEXTURE_LEFT = new ResourceLocation("cofh:textures/gui/elements/Tab_Left.png");
    public static final ResourceLocation DEFAULT_TEXTURE_RIGHT = new ResourceLocation("cofh:textures/gui/elements/Tab_Right.png");

    public TabBase(GuiBase gui) {
        super(gui, 0, 0);
        this.texture = DEFAULT_TEXTURE_RIGHT;
    }

    public TabBase(GuiBase gui, int side) {
        super(gui, 0, 0);
        this.side = side;
        this.texture = side == 0 ? DEFAULT_TEXTURE_LEFT : DEFAULT_TEXTURE_RIGHT;
    }

    public TabBase setOffsets(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
        return this;
    }

    public void draw(int x, int y) {
        this.posX = x + this.offsetX;
        this.posY = y + this.offsetY;
        this.draw();
    }

    public void draw() {
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
    }

    @Override
    public void update() {
        if (this.open && this.currentWidth < this.maxWidth) {
            this.currentWidth += tabExpandSpeed;
        } else if (!this.open && this.currentWidth > this.minWidth) {
            this.currentWidth -= tabExpandSpeed;
        }
        if (this.currentWidth > this.maxWidth) {
            this.currentWidth = this.maxWidth;
        } else if (this.currentWidth < this.minWidth) {
            this.currentWidth = this.minWidth;
        }
        if (this.open && this.currentHeight < this.maxHeight) {
            this.currentHeight += tabExpandSpeed;
        } else if (!this.open && this.currentHeight > this.minHeight) {
            this.currentHeight -= tabExpandSpeed;
        }
        if (this.currentHeight > this.maxHeight) {
            this.currentHeight = this.maxHeight;
        } else if (this.currentHeight < this.minHeight) {
            this.currentHeight = this.minHeight;
        }
        if (!this.fullyOpen && this.open && this.currentWidth == this.maxWidth && this.currentHeight == this.maxHeight) {
            this.setFullyOpen();
        }
    }

    protected void drawBackground() {
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        RenderHelper.bindTexture(this.texture);
        int xPosition = this.posX();
        this.gui.func_73729_b(xPosition, this.posY + 4, 0, 256 - this.currentHeight + 4, 4, this.currentHeight - 4);
        this.gui.func_73729_b(xPosition + 4, this.posY, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
        this.gui.func_73729_b(xPosition, this.posY, 0, 0, 4, 4);
        this.gui.func_73729_b(xPosition + 4, this.posY + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawTabIcon(String iconName) {
        this.gui.drawIcon(iconName, this.posXOffset(), this.posY + 3, 1);
    }

    protected int posX() {
        if (this.side == 0) {
            return this.posX - this.currentWidth;
        }
        return this.posX;
    }

    protected int posXOffset() {
        return this.posX() + this.sideOffset();
    }

    protected int sideOffset() {
        return this.side == 0 ? 4 : 2;
    }

    public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
        return this.side == 0 ? mouseX <= shiftX && mouseX >= shiftX - this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.currentHeight : mouseX >= (shiftX += this.offsetX) && mouseX <= shiftX + this.currentWidth && mouseY >= (shiftY += this.offsetY) && mouseY <= shiftY + this.currentHeight;
    }

    public boolean isFullyOpened() {
        return this.fullyOpen;
    }

    public void setCurrentShift(int x, int y) {
        this.currentShiftX = x + this.offsetX;
        this.currentShiftY = y + this.offsetY;
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
        this.fullyOpen = true;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            if (this.side == 0) {
                TabTracker.setOpenedLeftTab(null);
            } else {
                TabTracker.setOpenedRightTab(null);
            }
            this.fullyOpen = false;
        } else {
            this.open = true;
            if (this.side == 0) {
                TabTracker.setOpenedLeftTab(this.getClass());
            } else {
                TabTracker.setOpenedRightTab(this.getClass());
            }
        }
    }

    public Rectangle4i getBounds() {
        if (this.isVisible()) {
            return new Rectangle4i(this.posX() + this.gui.getGuiLeft(), this.posY + this.gui.getGuiTop(), this.currentWidth, this.currentHeight);
        }
        return new Rectangle4i(this.posX() + this.gui.getGuiLeft(), this.posY + this.gui.getGuiTop(), 0, 0);
    }
}

