/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.blocks;

import cofh.api.energy.IEnergyProvider;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.nauktis.core.inventory.BaseInventory;
import com.nauktis.core.tileentity.BaseModTileEntitySynced;
import com.nauktis.core.utility.Utils;
import com.nauktis.solarflux.blocks.StatefulEnergyStorage;
import com.nauktis.solarflux.blocks.modules.EnergySharingModule;
import com.nauktis.solarflux.blocks.modules.ITileEntityModule;
import com.nauktis.solarflux.blocks.modules.SimpleEnergyDispenserModule;
import com.nauktis.solarflux.blocks.modules.TraversalEnergyDispenserModule;
import com.nauktis.solarflux.config.ModConfiguration;
import com.nauktis.solarflux.config.TierConfiguration;
import com.nauktis.solarflux.init.ModItems;
import com.nauktis.solarflux.items.UpgradeItem;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class SolarPanelTileEntity
extends BaseModTileEntitySynced
implements IInventory,
IEnergyProvider {
    public static final int INVENTORY_SIZE = 5;
    public static final Range<Integer> UPGRADE_SLOTS = Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(5));
    private final short mTickShift;
    private final StatefulEnergyStorage mEnergyStorage;
    private int mTierIndex;
    private ITileEntityModule mEnergySharingModule;
    private ITileEntityModule mEnergyDispenserModule = new SimpleEnergyDispenserModule(this);
    private int mCurrentEnergyGeneration;
    private float mSunIntensity;
    private BaseInventory mInventory = new BaseInventory("Solar Panel", 5);
    private Map<Item, Integer> mUpgradeCache = Maps.newHashMap();

    public SolarPanelTileEntity() {
        this(0);
    }

    public SolarPanelTileEntity(int pTierIndex) {
        this.mTierIndex = pTierIndex;
        this.mTickShift = (short)Utils.RANDOM.nextInt(100);
        this.mEnergyStorage = new StatefulEnergyStorage(ModConfiguration.getTierConfiguration(this.mTierIndex).getCapacity(), ModConfiguration.getTierConfiguration(this.mTierIndex).getMaximumEnergyTransfer());
        if (ModConfiguration.doesAutoBalanceEnergy()) {
            this.mEnergySharingModule = new EnergySharingModule(this);
        }
    }

    public TierConfiguration getTierConfiguration() {
        return ModConfiguration.getTierConfigurations().get(this.mTierIndex);
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.generateEnergy();
        if (this.isServer()) {
            if (this.atTickRate(20)) {
                this.updateCurrentEnergyGeneration();
            }
            this.mEnergyDispenserModule.tick();
            if (this.mEnergySharingModule != null) {
                this.mEnergySharingModule.tick();
            }
        }
    }

    public StatefulEnergyStorage getEnergyStorage() {
        return this.mEnergyStorage;
    }

    public int getCurrentEnergyGeneration() {
        return this.mCurrentEnergyGeneration;
    }

    public void setCurrentEnergyGeneration(int pCurrentEnergyGeneration) {
        this.mCurrentEnergyGeneration = pCurrentEnergyGeneration;
    }

    public int getMaximumEnergyGeneration() {
        return this.getTierConfiguration().getMaximumEnergyGeneration();
    }

    private void updateCurrentEnergyGeneration() {
        this.computeSunIntensity();
        double energyGeneration = (float)this.getMaximumEnergyGeneration() * this.mSunIntensity;
        this.mCurrentEnergyGeneration = (int)Math.round(energyGeneration *= 1.0 + (double)ModConfiguration.getEfficiencyUpgradeIncrease() * Math.pow(this.getUpgradeCount(ModItems.mUpgradeEfficiency), ModConfiguration.getEfficiencyUpgradeReturnsToScale()));
    }

    public float getSunIntensity() {
        return this.mSunIntensity;
    }

    public void setSunIntensity(float pSunIntensity) {
        this.mSunIntensity = pSunIntensity;
    }

    private void computeSunIntensity() {
        if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            float multiplicator = 1.5f - (float)this.getUpgradeCount(ModItems.mUpgradeLowLight) * 0.122f;
            float displacement = 1.2f + (float)this.getUpgradeCount(ModItems.mUpgradeLowLight) * 0.08f;
            float celestialAngleRadians = this.field_145850_b.func_72929_e(1.0f);
            if ((double)celestialAngleRadians > Math.PI) {
                celestialAngleRadians = 6.283184f - celestialAngleRadians;
            }
            this.mSunIntensity = multiplicator * MathHelper.func_76134_b((float)(celestialAngleRadians / displacement));
            this.mSunIntensity = Math.max(0.0f, this.mSunIntensity);
            this.mSunIntensity = Math.min(1.0f, this.mSunIntensity);
            if (this.mSunIntensity > 0.0f) {
                if (this.field_145850_b.func_72896_J()) {
                    this.mSunIntensity *= ModConfiguration.getRainGenerationFactor();
                }
                if (this.field_145850_b.func_72911_I()) {
                    this.mSunIntensity *= ModConfiguration.getThunderGenerationFactor();
                }
            }
        } else {
            this.mSunIntensity = 0.0f;
        }
    }

    protected void generateEnergy() {
        if (this.mCurrentEnergyGeneration > 0) {
            this.getEnergyStorage().receiveEnergy(this.mCurrentEnergyGeneration, false);
        }
    }

    private void refreshUpgradeCache() {
        this.mUpgradeCache.clear();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null || !(itemStack.func_77973_b() instanceof UpgradeItem)) continue;
            if (this.mUpgradeCache.containsKey(itemStack.func_77973_b())) {
                this.mUpgradeCache.put(itemStack.func_77973_b(), itemStack.field_77994_a + this.mUpgradeCache.get(itemStack.func_77973_b()));
                continue;
            }
            this.mUpgradeCache.put(itemStack.func_77973_b(), itemStack.field_77994_a);
        }
        if (this.getUpgradeCount(ModItems.mUpgradeTraversal) > 0 && this.mEnergyDispenserModule instanceof SimpleEnergyDispenserModule) {
            this.mEnergyDispenserModule = new TraversalEnergyDispenserModule(this);
        } else if (this.getUpgradeCount(ModItems.mUpgradeTraversal) == 0 && this.mEnergyDispenserModule instanceof TraversalEnergyDispenserModule) {
            this.mEnergyDispenserModule = new SimpleEnergyDispenserModule(this);
        }
        this.getEnergyStorage().setMaxTransfer((int)((double)ModConfiguration.getTierConfiguration(this.mTierIndex).getMaximumEnergyTransfer() * (1.0 + (double)ModConfiguration.getTransferRateUpgradeIncrease() * Math.pow(this.getUpgradeCount(ModItems.mUpgradeTransferRate), ModConfiguration.getTransferRateUpgradeReturnsToScale()))));
        this.getEnergyStorage().setMaxEnergyStored((int)((double)ModConfiguration.getTierConfiguration(this.mTierIndex).getCapacity() * (1.0 + (double)ModConfiguration.getCapacityUpgradeIncrease() * Math.pow(this.getUpgradeCount(ModItems.mUpgradeCapacity), ModConfiguration.getCapacityUpgradeReturnsToScale()))));
    }

    public int getTotalUpgradeInstalled() {
        int count = 0;
        for (int value : this.mUpgradeCache.values()) {
            count += value;
        }
        return count;
    }

    public int additionalUpgradeAllowed(ItemStack pItemStack) {
        Item item;
        if (pItemStack != null && (item = pItemStack.func_77973_b()) instanceof UpgradeItem) {
            UpgradeItem upgrade = (UpgradeItem)item;
            return upgrade.getMaximumPerSolarPanel() - this.getUpgradeCount(upgrade);
        }
        return 0;
    }

    public int getUpgradeCount(Item pItem) {
        if (pItem != null) {
            Integer count = this.mUpgradeCache.get(pItem);
            return count == null ? 0 : count;
        }
        return 0;
    }

    @Override
    protected void loadDataFromNBT(NBTTagCompound pNBT) {
        super.loadDataFromNBT(pNBT);
        this.mTierIndex = pNBT.func_74762_e("SFTierIndex");
        this.mEnergyStorage.setMaxEnergyStored(ModConfiguration.getTierConfiguration(this.mTierIndex).getCapacity());
        this.mEnergyStorage.setMaxTransfer(ModConfiguration.getTierConfiguration(this.mTierIndex).getMaximumEnergyTransfer());
        this.mInventory.readFromNBT(pNBT);
        this.func_70296_d();
        this.mEnergyStorage.readFromNBT(pNBT);
    }

    @Override
    protected void addDataToNBT(NBTTagCompound pNBT) {
        super.addDataToNBT(pNBT);
        pNBT.func_74768_a("SFTierIndex", this.mTierIndex);
        this.mInventory.writeToNBT(pNBT);
        this.mEnergyStorage.writeToNBT(pNBT);
    }

    public boolean atTickRate(int pDesiredTickRate) {
        return (this.func_145831_w().func_82737_E() + (long)this.mTickShift) % (long)pDesiredTickRate == 0L;
    }

    public boolean canConnectEnergy(ForgeDirection pFrom) {
        return pFrom != ForgeDirection.UP;
    }

    public int extractEnergy(ForgeDirection pFrom, int pMaxExtract, boolean pSimulate) {
        return this.getEnergyStorage().extractEnergy(this.getEnergyStorage().getMaxExtract(), pSimulate);
    }

    public int getEnergyStored() {
        return this.getEnergyStored(ForgeDirection.DOWN);
    }

    public void setEnergyStored(int pEnergy) {
        this.getEnergyStorage().setEnergyStored(pEnergy);
    }

    public int getScaledEnergyStoredFraction(int pScale) {
        long v = pScale;
        v *= (long)this.getEnergyStored();
        Preconditions.checkState(((v /= (long)this.getMaxEnergyStored()) <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Integer overflow");
        return (int)v;
    }

    public int getPercentageEnergyStored() {
        return this.getScaledEnergyStoredFraction(100);
    }

    public int getEnergyStored(ForgeDirection pFrom) {
        return this.getEnergyStorage().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(ForgeDirection.DOWN);
    }

    public int getMaxEnergyStored(ForgeDirection pFrom) {
        return this.getEnergyStorage().getMaxEnergyStored();
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("hash", ((Object)((Object)this)).hashCode()).add("MaxProduction", this.getMaximumEnergyGeneration()).add("energyStorage", (Object)this.getEnergyStorage()).toString();
    }

    public BaseInventory getInventory() {
        return this.mInventory;
    }

    public int func_70302_i_() {
        return this.mInventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int pSlotIndex) {
        return this.mInventory.func_70301_a(pSlotIndex);
    }

    public ItemStack func_70298_a(int pSlotIndex, int pDecrementAmount) {
        return this.mInventory.func_70298_a(pSlotIndex, pDecrementAmount);
    }

    public ItemStack func_70304_b(int pSlotIndex) {
        return this.mInventory.func_70304_b(pSlotIndex);
    }

    public void func_70299_a(int pSlotIndex, ItemStack pItemStack) {
        this.mInventory.func_70299_a(pSlotIndex, pItemStack);
    }

    public String func_145825_b() {
        return this.mInventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.mInventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.mInventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer pEntityPlayer) {
        return this.mInventory.func_70300_a(pEntityPlayer);
    }

    public void func_70295_k_() {
        this.mInventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.mInventory.func_70305_f();
    }

    public boolean func_94041_b(int pSlotIndex, ItemStack pItemStack) {
        if (pItemStack.func_77973_b() instanceof UpgradeItem && this.additionalUpgradeAllowed(pItemStack) >= pItemStack.field_77994_a) {
            return this.mInventory.func_94041_b(pSlotIndex, pItemStack);
        }
        return false;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.refreshUpgradeCache();
    }
}

