/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.permissions;

import cpw.mods.fml.common.FMLLog;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.permissions.DefaultPermProvider;
import net.minecraftforge.permissions.IContext;
import net.minecraftforge.permissions.IPermissionsProvider;
import net.minecraftforge.permissions.PermissionContext;

public final class PermissionsManager {
    private static IPermissionsProvider provider = new DefaultPermProvider();
    private static boolean wasSet = false;

    private PermissionsManager() {
    }

    public static boolean checkPermission(EntityPlayer player, String permissionNode) {
        return provider.checkPermission(new PermissionContext().setPlayer(player), permissionNode);
    }

    public static boolean checkPermission(IContext contextInfo, String permissionNode) {
        return provider.checkPermission(contextInfo, permissionNode);
    }

    public static void registerPermission(String permissionNode, RegisteredPermValue level) {
        provider.registerPermission(permissionNode, level);
    }

    public static void setPermProvider(IPermissionsProvider factory) throws IllegalStateException {
        if (factory == null) {
            wasSet = false;
        } else {
            if (wasSet) {
                throw new IllegalStateException(String.format("Attempted to register permissions framework %s1 when permissions framework %s2 is already registered!", factory.getClass().getName(), provider.getClass().getName()));
            }
            provider = factory;
            wasSet = true;
            FMLLog.fine((String)("Registered permissions framework " + provider.getClass().getName()), (Object[])new Object[0]);
        }
    }

    public static enum RegisteredPermValue {
        TRUE,
        FALSE,
        OP;


        public static RegisteredPermValue fromBoolean(boolean toConvert) {
            if (toConvert) {
                return TRUE;
            }
            return FALSE;
        }

        public static RegisteredPermValue fromString(String name) {
            for (RegisteredPermValue value : RegisteredPermValue.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return value;
            }
            return null;
        }
    }
}

