/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.worldborder;

import com.forgeessentials.api.permissions.ServerZone;
import com.forgeessentials.api.permissions.WorldZone;
import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.commons.IReconstructData;
import com.forgeessentials.commons.SaveableObject;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.worldborder.ModuleWorldBorder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

@SaveableObject
public class WorldBorder {
    @SaveableObject.UniqueLoadingKey
    @SaveableObject.SaveableField
    public String zone;
    @SaveableObject.SaveableField
    public Point center;
    @SaveableObject.SaveableField
    public int rad;
    @SaveableObject.SaveableField
    public byte shapeByte;
    @SaveableObject.SaveableField
    public boolean enabled;

    public WorldBorder(Zone zone, Point center, int rad, byte shape) {
        if (!(zone instanceof ServerZone) && !(zone instanceof WorldZone)) {
            throw new RuntimeException(zone.getName() + " is not the global zone or a worldzone");
        }
        this.zone = zone.getName();
        this.center = center;
        this.rad = rad;
        this.shapeByte = shape;
        this.enabled = true;
    }

    public WorldBorder(String zone, Point center, int rad, byte shape, boolean enabled) {
        this.zone = zone;
        this.center = center;
        this.rad = rad;
        this.shapeByte = shape;
        this.enabled = enabled;
    }

    public WorldBorder(String name) {
        this.zone = name;
        this.center = new Point(0, 0, 0);
        this.rad = 0;
        this.shapeByte = 0;
        this.enabled = false;
    }

    @SaveableObject.Reconstructor
    private static WorldBorder reconstruct(IReconstructData tag) {
        Point center = (Point)tag.getFieldValue("center");
        int rad = (Integer)tag.getFieldValue("rad");
        byte shape = (Byte)tag.getFieldValue("shapeByte");
        boolean enabled = (Boolean)tag.getFieldValue("enabled");
        return new WorldBorder(tag.getUniqueKey(), center, rad, shape, enabled);
    }

    public void check(EntityPlayerMP player) {
        int dist;
        if (!this.enabled) {
            return;
        }
        if (this.shapeByte == 1) {
            if (player.field_70165_t < (double)(this.center.getX() - this.rad)) {
                ModuleWorldBorder.executeClosestEffects(this, player.field_70165_t - (double)(this.center.getX() - this.rad), player);
            }
            if (player.field_70165_t > (double)(this.center.getX() + this.rad)) {
                ModuleWorldBorder.executeClosestEffects(this, player.field_70165_t - (double)(this.center.getX() + this.rad), player);
            }
            if (player.field_70161_v < (double)(this.center.getZ() - this.rad)) {
                ModuleWorldBorder.executeClosestEffects(this, player.field_70161_v - (double)(this.center.getZ() - this.rad), player);
            }
            if (player.field_70161_v > (double)(this.center.getZ() + this.rad)) {
                ModuleWorldBorder.executeClosestEffects(this, player.field_70161_v - (double)(this.center.getZ() + this.rad), player);
            }
        } else if (this.shapeByte == 2 && (dist = ModuleWorldBorder.getDistanceRound(this.center, (EntityPlayer)player)) > this.rad) {
            ModuleWorldBorder.executeClosestEffects(this, dist, player);
        }
    }

    public long getETA() {
        try {
            if (this.shapeByte == 1) {
                return (long)Math.pow(this.rad / 16 * 2, 2.0);
            }
            if (this.shapeByte == 2) {
                return (long)(Math.pow(this.rad / 16, 2.0) * Math.PI);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public void save() {
        DataManager.getInstance().save(this, this.zone);
    }

    public String getShape() {
        switch (this.shapeByte) {
            case 1: {
                return "square";
            }
            case 2: {
                return "round";
            }
        }
        return "not set";
    }
}

