/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.worldborder;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commons.IReconstructData;
import com.forgeessentials.commons.SaveableObject;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.util.FEChunkLoader;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.tasks.ITickTask;
import com.forgeessentials.util.tasks.TaskRegistry;
import com.forgeessentials.worldborder.CommandFiller;
import com.forgeessentials.worldborder.ModuleWorldBorder;
import com.forgeessentials.worldborder.WorldBorder;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.gen.ChunkProviderServer;

@SaveableObject
public class TickTaskFill
implements ITickTask {
    @SaveableObject.SaveableField
    public int speed = 1;
    public WorldBorder border;
    @SaveableObject.UniqueLoadingKey
    @SaveableObject.SaveableField
    String dimID;
    boolean isComplete = false;
    WorldServer world;
    int minX;
    int minZ;
    int maxX;
    int maxZ;
    int centerX;
    int centerZ;
    int rad;
    @SaveableObject.SaveableField
    long ticks = 0L;
    @SaveableObject.SaveableField
    long todo = 0L;
    MinecraftServer server = MinecraftServer.func_71276_C();
    ICommandSender source;
    boolean stopped = false;
    @SaveableObject.SaveableField
    private int X;
    @SaveableObject.SaveableField
    private int Z;
    Method writeChunkToNBT = null;

    private TickTaskFill(IReconstructData tag) {
        this.X = (Integer)tag.getFieldValue("X");
        this.Z = (Integer)tag.getFieldValue("Z");
        this.speed = (Integer)tag.getFieldValue("speed");
        this.ticks = (Long)tag.getFieldValue("ticks");
        this.todo = (Long)tag.getFieldValue("todo");
    }

    public TickTaskFill(WorldServer worldToFill, ICommandSender sender, boolean restart) {
        TickTaskFill saved;
        this.dimID = worldToFill.field_73011_w.field_76574_g + "";
        FEChunkLoader.instance().forceLoadWorld((World)worldToFill);
        if (CommandFiller.map.containsKey(worldToFill.field_73011_w.field_76574_g)) {
            OutputHandler.chatError((ICommandSender)this.server, "Already running a filler for dim " + this.dimID + "!");
            return;
        }
        this.source = sender;
        this.world = worldToFill;
        this.border = ModuleWorldBorder.getBorder(APIRegistry.perms.getServerZone().getWorldZone((World)this.world).getName(), false);
        if (this.border == null || this.border.shapeByte == 0 || this.border.rad == 0) {
            OutputHandler.chatError(sender, "You need to set the worldborder first!");
            return;
        }
        this.X = this.minX = (this.border.center.getX() - this.border.rad - ModuleWorldBorder.overGenerate) / 16;
        this.Z = this.minZ = (this.border.center.getZ() - this.border.rad - ModuleWorldBorder.overGenerate) / 16;
        this.maxX = (this.border.center.getX() + this.border.rad + ModuleWorldBorder.overGenerate) / 16;
        this.maxZ = (this.border.center.getZ() + this.border.rad + ModuleWorldBorder.overGenerate) / 16;
        this.centerX = this.border.center.getX() / 16;
        this.centerZ = this.border.center.getZ() / 16;
        this.rad = (this.border.rad + ModuleWorldBorder.overGenerate) / 16;
        this.todo = this.border.getETA();
        OutputHandler.debug("Filler for :" + this.world.field_73011_w.field_76574_g);
        OutputHandler.debug("MinX=" + this.minX + " MaxX=" + this.maxX);
        OutputHandler.debug("MinZ=" + this.minZ + " MaxZ=" + this.maxZ);
        if (restart && (saved = DataManager.getInstance().load(TickTaskFill.class, Integer.toString(worldToFill.field_73011_w.field_76574_g))) != null) {
            OutputHandler.chatWarning(this.source, "Found a stopped filler. Will resume that one.");
            this.X = saved.X;
            this.Z = saved.Z;
            this.speed = saved.speed;
            this.ticks = saved.ticks;
            this.todo = saved.todo;
        }
        this.setupWriteChunkToNBT();
        TaskRegistry.registerTask(this);
        OutputHandler.chatWarning(this.source, "This filler will take about " + this.getETA() + " at current speed.");
    }

    @SaveableObject.Reconstructor
    private static TickTaskFill reconstruct(IReconstructData tag) {
        return new TickTaskFill(tag);
    }

    private String getETA() {
        try {
            return FunctionHelper.parseTime((int)((double)(this.todo / (long)this.speed) / FunctionHelper.getTPS()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public void tick() {
        ++this.ticks;
        if (this.ticks % 500L == 0L) {
            OutputHandler.chatNotification(this.source, "Filler for " + this.dimID + ": " + this.getStatus());
        }
        for (int i = 0; i < this.speed; ++i) {
            while (RegionFileCache.func_76550_a((File)this.world.getChunkSaveLocation(), (int)this.X, (int)this.Z).chunkExists(this.X & 0x1F, this.Z & 0x1F)) {
                --this.todo;
                if (!this.next()) continue;
                return;
            }
            ChunkProviderServer provider = (ChunkProviderServer)this.world.func_72863_F();
            Chunk chunk = provider.field_73246_d.func_73158_c(this.X, this.Z);
            chunk.func_76624_a((IChunkProvider)provider, (IChunkProvider)provider, this.X, this.Z);
            this.saveChunk(provider, chunk);
            --this.todo;
            if (!this.next()) continue;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean next() {
        if (this.border.shapeByte == 1) {
            if (this.X <= this.maxX) {
                ++this.X;
                return false;
            }
            if (this.Z <= this.maxZ) {
                this.X = this.minX;
                ++this.Z;
                return false;
            }
            this.isComplete = true;
            return true;
        }
        if (this.border.shapeByte != 2) {
            this.isComplete = true;
            throw new RuntimeException("WTF?" + this.border.shapeByte);
        }
        do {
            if (this.X <= this.maxX) {
                ++this.X;
                continue;
            }
            if (this.Z > this.maxZ) {
                this.isComplete = true;
                return true;
            }
            this.X = this.minX;
            ++this.Z;
        } while (this.rad < ModuleWorldBorder.getDistanceRound(this.centerX, this.centerZ, this.X, this.Z));
        return false;
    }

    @Override
    public void onComplete() {
        try {
            boolean var6 = this.world.field_73058_d;
            this.world.field_73058_d = false;
            this.world.func_73044_a(true, (IProgressUpdate)null);
            this.world.field_73058_d = var6;
        }
        catch (MinecraftException minecraftException) {
            // empty catch block
        }
        if (!this.stopped) {
            OutputHandler.chatWarning(this.source, "Filler finished after " + this.ticks + " ticks.");
            System.out.print("Removed filler? :" + DataManager.getInstance().delete(TickTaskFill.class, this.dimID));
        }
        CommandFiller.map.remove(Integer.parseInt(this.dimID));
        FEChunkLoader.instance().unforceLoadWorld((World)this.world);
        System.gc();
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public boolean editsBlocks() {
        return true;
    }

    public void stop() {
        this.stopped = true;
        this.isComplete = true;
        DataManager.getInstance().save(this, this.dimID);
        OutputHandler.chatWarning(this.source, "Filler stopped after " + this.ticks + " ticks. Still to do: " + this.todo + " chuncks.");
        System.gc();
    }

    public String getStatus() {
        return "Todo: " + this.getETA() + " at " + this.speed + " chuncks per ticks.";
    }

    public void setSpeed(int speed) {
        this.speed = speed;
        OutputHandler.chatWarning(this.source, "Changed speed of filler " + this.dimID + " to " + speed);
    }

    private void saveChunk(ChunkProviderServer provider, Chunk chunk) {
        AnvilChunkLoader loader = (AnvilChunkLoader)provider.field_73247_e;
        try {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound.func_74782_a("Level", (NBTBase)nbttagcompound1);
            this.writeChunkToNBT(loader, chunk, (World)this.world, nbttagcompound1);
            this.writeChunkNBTTags(loader, chunk, nbttagcompound);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setupWriteChunkToNBT() {
        Class[] cArg = new Class[]{Chunk.class, World.class, NBTTagCompound.class};
        try {
            this.writeChunkToNBT = AnvilChunkLoader.class.getDeclaredMethod("func_75820_a", cArg);
        }
        catch (NoSuchMethodException e) {
            try {
                this.writeChunkToNBT = AnvilChunkLoader.class.getDeclaredMethod("writeChunkToNBT", cArg);
            }
            catch (NoSuchMethodException e1) {
                throw new RuntimeException("TickTaskFill: Unable to obtain access to private method AnvilChunkLoader.writeChunkToNBT");
            }
        }
        this.writeChunkToNBT.setAccessible(true);
    }

    private void writeChunkToNBT(AnvilChunkLoader loader, Chunk chunk, World world, NBTTagCompound tag) {
        Object[] args = new Object[]{chunk, world, tag};
        try {
            this.writeChunkToNBT.invoke((Object)loader, args);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
        }
    }

    private void writeChunkNBTTags(AnvilChunkLoader loader, Chunk chunk, NBTTagCompound tag) throws IOException {
        try (DataOutputStream dataoutputstream = RegionFileCache.func_76552_d((File)this.world.getChunkSaveLocation(), (int)chunk.field_76635_g, (int)chunk.field_76647_h);){
            CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)dataoutputstream);
        }
    }
}

