/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.worldborder;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.WorldZone;
import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.FEModuleEvent;
import com.forgeessentials.util.events.PlayerMoveEvent;
import com.forgeessentials.util.vector.Vector2;
import com.forgeessentials.worldborder.CommandFiller;
import com.forgeessentials.worldborder.CommandWB;
import com.forgeessentials.worldborder.ConfigWorldBorder;
import com.forgeessentials.worldborder.Effects.IEffect;
import com.forgeessentials.worldborder.TickTaskFill;
import com.forgeessentials.worldborder.WorldBorder;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.permissions.PermissionsManager;

@FEModule(name="WorldBorder", parentMod=ForgeEssentials.class)
public class ModuleWorldBorder {
    public static boolean logToConsole = true;
    private static Map<String, WorldBorder> borderMap = new HashMap<String, WorldBorder>();
    public static Map<Integer, IEffect[]> effectsList = new HashMap<Integer, IEffect[]>();
    public static int overGenerate = 345;

    public static void loadAll() {
        borderMap = DataManager.getInstance().loadAll(WorldBorder.class);
    }

    public static void saveAll() {
        for (WorldBorder wb : borderMap.values()) {
            wb.save();
        }
        for (TickTaskFill filler : CommandFiller.map.values()) {
            filler.stop();
        }
    }

    public static void registerEffects(int dist, IEffect[] effects) {
        effectsList.put(dist, effects);
    }

    public static void executeClosestEffects(WorldBorder wb, double dd, EntityPlayerMP player) {
        int d = (int)Math.abs(dd);
        if (logToConsole) {
            OutputHandler.felog.info(player.getDisplayName() + " passed the worldborder by " + d + " blocks.");
        }
        for (int i = d; i >= 0; --i) {
            if (effectsList.isEmpty() || !effectsList.containsKey(i)) continue;
            for (IEffect effect : effectsList.get(i)) {
                effect.execute(wb, player);
            }
        }
    }

    public static Vector2 getDirectionVector(Point center, EntityPlayerMP player) {
        Vector2 vecp = new Vector2((double)center.getX() - player.field_70165_t, (double)center.getZ() - player.field_70161_v);
        vecp.normalize();
        vecp.multiply(-1.0);
        return vecp;
    }

    public static int getDistanceRound(Point center, EntityPlayer player) {
        double difX = (double)center.getX() - player.field_70165_t;
        double difZ = (double)center.getZ() - player.field_70161_v;
        return (int)Math.sqrt(difX * difX + difZ * difZ);
    }

    public static int getDistanceRound(int centerX, int centerZ, int x, int z) {
        double difX = centerX - x;
        double difZ = centerZ - z;
        return (int)Math.sqrt(difX * difX + difZ * difZ);
    }

    @SubscribeEvent
    public void load(FEModuleEvent.FEModuleInitEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ForgeEssentials.getConfigManager().registerLoader("WorldBorder", new ConfigWorldBorder());
    }

    @SubscribeEvent
    public void serverStarting(FEModuleEvent.FEModuleServerInitEvent e) {
        FunctionHelper.registerServerCommand(new CommandWB());
        FunctionHelper.registerServerCommand(new CommandFiller());
        APIRegistry.perms.registerPermission("fe.worldborder.admin", PermissionsManager.RegisteredPermValue.OP);
        APIRegistry.perms.registerPermission("fe.worldborder.filler", PermissionsManager.RegisteredPermValue.OP);
    }

    @SubscribeEvent
    public void serverStarted(FEModuleEvent.FEModuleServerPostInitEvent e) {
        ModuleWorldBorder.loadAll();
    }

    @SubscribeEvent
    public void serverStopping(FEModuleEvent.FEModuleServerStopEvent e) {
        ModuleWorldBorder.saveAll();
    }

    public static void checkBorder(EntityPlayerMP player, String name) {
        WorldBorder border = borderMap.get(name);
        if (border != null) {
            border.check(player);
        }
    }

    public static WorldBorder getBorder(String name, boolean createIfNull) {
        WorldBorder border = borderMap.get(name);
        if (border == null && createIfNull) {
            border = new WorldBorder(name);
            borderMap.put(name, border);
        }
        return border;
    }

    @SubscribeEvent
    public void playerMove(PlayerMoveEvent e) {
        ModuleWorldBorder.checkBorder((EntityPlayerMP)e.entityPlayer, APIRegistry.perms.getServerZone().getWorldZone(e.entityPlayer.field_70170_p).getName());
        ModuleWorldBorder.checkBorder((EntityPlayerMP)e.entityPlayer, APIRegistry.perms.getServerZone().getName());
    }

    @SubscribeEvent
    public void worldUnLoad(WorldEvent.Unload e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        WorldZone zone = APIRegistry.perms.getServerZone().getWorldZone(e.world);
        borderMap.remove(((Zone)zone).getName());
    }
}

