/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.worldborder;

import com.forgeessentials.core.moduleLauncher.config.IConfigLoader;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.worldborder.Effects.IEffect;
import com.forgeessentials.worldborder.ModuleWorldBorder;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigWorldBorder
extends IConfigLoader.ConfigLoaderBase {
    public static void penaltiesConfig(Configuration config) {
        ModuleWorldBorder.effectsList.clear();
        String penaltyBasePackage = IEffect.class.getPackage().getName();
        config.addCustomCategoryComment("Penalties", "This is what will happen to the player if he passes the world border.");
        String[] stages = new String[]{"Stage1"};
        for (String stage : stages = config.get("Penalties", "stages", stages, "If you add an item here, a subcategory will be generated.").getStringList()) {
            String cat = "Penalties." + stage;
            int dist = config.get(cat, "Distance", 0, "The distance outside the border when this gets activated. WARNING: This needs to be unique! You can specify 2 penalties in 1 stage.").getInt();
            String[] effects = new String[]{"message", "knockback", "damage"};
            effects = config.get(cat, "effects", effects, "Get the list of possibilities in the example file").getStringList();
            IEffect[] effctList = new IEffect[effects.length];
            int i = 0;
            for (String effect : effects) {
                try {
                    Class<?> c = Class.forName(penaltyBasePackage + "." + effect.toLowerCase());
                    try {
                        IEffect pentalty = (IEffect)c.newInstance();
                        pentalty.registerConfig(config, cat + "." + effect);
                        effctList[i] = pentalty;
                        ++i;
                    }
                    catch (Exception e) {
                        OutputHandler.felog.info("Could not initialize '" + effect + "' in stage '" + stage + "'");
                        e.printStackTrace();
                    }
                }
                catch (ClassNotFoundException e) {
                    OutputHandler.felog.info("'" + effect + "' in the stage '" + stage + "' does not exist!");
                    e.printStackTrace();
                }
            }
            ModuleWorldBorder.registerEffects(dist, effctList);
        }
    }

    public static void commonConfig(Configuration config) {
        String category = "Settings";
        config.addCustomCategoryComment(category, "Common settings.");
        ModuleWorldBorder.logToConsole = config.get(category, "LogToConsole", true, "Enable logging to the server console and the log file").getBoolean(true);
        Property prop = config.get(category, "overGenerate", 345);
        prop.comment = "The amount of blocks that will be generated outside the radius of the border. This is important! \nIf you set this high, you will need exponentially more time while generating, but you won't get extra land if a player does pass the border. \nIf you use something like Dynmap you should put this number higher. If the border isn't there for aesthetic purposes, then you don't need that. \nThe default value (345) is calculated like this: (20 chuncks for view distance * 16 blocks per chunck) + 25 as backup. \nThis allows players to pass the border 25 blocks before generating new land.";
        ModuleWorldBorder.overGenerate = prop.getInt(345);
    }

    @Override
    public void load(Configuration config, boolean isReload) {
        ConfigWorldBorder.penaltiesConfig(config);
        ConfigWorldBorder.commonConfig(config);
    }
}

