/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.worldborder;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.worldborder.ModuleWorldBorder;
import com.forgeessentials.worldborder.WorldBorder;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandWB
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "worldborder";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("wb");
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        this.execute(sender, args);
    }

    public void execute(ICommandSender sender, String[] args) {
        Zone zone;
        if (args.length == 0) {
            OutputHandler.chatError(sender, "You must specify a zone you want to work in. '/wb global' or '/wb <id>'");
            if (sender instanceof EntityPlayer) {
                OutputHandler.chatError(sender, "As a player, '/wb world' works too");
            }
            return;
        }
        if (args[0].equalsIgnoreCase("global")) {
            zone = APIRegistry.perms.getServerZone();
        } else if (FunctionHelper.isNumeric(args[0])) {
            WorldServer world = DimensionManager.getWorld((int)CommandWB.func_71526_a((ICommandSender)sender, (String)args[0]));
            if (world == null) {
                OutputHandler.chatError(sender, args[0] + " is not an ID of a loaded world.");
                return;
            }
            zone = APIRegistry.perms.getServerZone().getWorldZone((World)world);
        } else if (args[0].equalsIgnoreCase("world") && sender instanceof EntityPlayer) {
            zone = APIRegistry.perms.getServerZone().getWorldZone(((EntityPlayer)sender).field_70170_p);
        } else {
            OutputHandler.chatError(sender, "You must specify a zone you want to work in. '/wb global' or '/wb <id>'");
            return;
        }
        WorldBorder border = ModuleWorldBorder.getBorder(((Zone)zone).getName(), true);
        if (args.length == 1 || args[1].equalsIgnoreCase("info")) {
            String header = "--- WorldBorder for " + ((Zone)zone).getName() + " ---";
            OutputHandler.chatNotification(sender, header);
            OutputHandler.chatNotification(sender, "Enabled: " + (border.enabled ? EnumChatFormatting.GREEN : EnumChatFormatting.RED) + border.enabled);
            OutputHandler.chatNotification(sender, "Center: " + border.center.toString());
            OutputHandler.chatNotification(sender, "Radius: " + border.rad);
            OutputHandler.chatNotification(sender, "Shape: " + border.getShape());
            StringBuilder footer = new StringBuilder();
            for (int i = 0; i < header.length(); ++i) {
                footer.append("-");
            }
            OutputHandler.chatNotification(sender, footer.toString());
        } else if (args[1].equalsIgnoreCase("enable")) {
            if (border.shapeByte != 0 && border.rad != 0) {
                border.enabled = true;
                OutputHandler.chatConfirmation(sender, "Border has been enabled.");
            } else {
                OutputHandler.chatError(sender, "You have to set a center, radius and shape first!");
            }
        } else if (args[1].equalsIgnoreCase("disable")) {
            if (border.shapeByte != 0 && border.rad != 0) {
                border.enabled = false;
                OutputHandler.chatConfirmation(sender, "Border has been disabled.");
            } else {
                OutputHandler.chatError(sender, "You have to set a center, radius and shape first!");
            }
        } else if (args[1].equalsIgnoreCase("center")) {
            if (args.length == 2) {
                OutputHandler.chatError(sender, "You have to specify coordinates (x z)" + (sender instanceof EntityPlayer ? " or 'here'." : "."));
            } else if (sender instanceof EntityPlayer && args[2].equalsIgnoreCase("here")) {
                border.center = new Point((Entity)((EntityPlayer)sender));
                OutputHandler.chatConfirmation(sender, "Center set to " + border.center);
            } else if (args.length == 4) {
                int x = CommandWB.func_71526_a((ICommandSender)sender, (String)args[2]);
                int z = CommandWB.func_71526_a((ICommandSender)sender, (String)args[3]);
                border.center = new Point(x, 64, z);
                OutputHandler.chatConfirmation(sender, "Center set to " + border.center);
            } else {
                OutputHandler.chatError(sender, "Expected '/wb " + args[0] + " center <x> <z>'");
            }
        } else if (args[1].equalsIgnoreCase("rad") || args[1].equalsIgnoreCase("radius")) {
            if (args.length == 2) {
                OutputHandler.chatError(sender, "You have to specify a radius...");
            } else {
                border.rad = CommandWB.func_71528_a((ICommandSender)sender, (String)args[2], (int)0);
                OutputHandler.chatConfirmation(sender, "You have set the radius to " + border.rad);
            }
        } else if (args[1].equalsIgnoreCase("shape")) {
            if (args.length == 2) {
                OutputHandler.chatError(sender, "You have to set the boder to 'round' or 'square'.");
            } else if (args[2].equalsIgnoreCase("square")) {
                border.shapeByte = 1;
                OutputHandler.chatConfirmation(sender, "You have set the border to " + border.getShape());
            } else if (args[2].equalsIgnoreCase("round")) {
                border.shapeByte = (byte)2;
                OutputHandler.chatConfirmation(sender, "You have set the border to " + border.getShape());
            }
        } else {
            OutputHandler.chatError(sender, "dafuq? I have no clue what you are trying to do. Use TAB for cmd filling!");
            OutputHandler.chatError(sender, "/wb <zone> [info|enable|disable|center|radius|shape]");
        }
        ModuleWorldBorder.saveAll();
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.worldborder.admin";
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("global");
            if (sender instanceof EntityPlayer) {
                list.add("world");
            }
            Integer[] arr$ = DimensionManager.getIDs();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i = arr$[i$];
                list.add("" + i);
            }
            return CommandWB.func_71531_a((String[])args, list);
        }
        if (args.length == 2) {
            return CommandWB.func_71530_a((String[])args, (String[])new String[]{"info", "enable", "disable", "center", "radius", "shape"});
        }
        if (args.length == 3 && args[2].equalsIgnoreCase("shape")) {
            return CommandWB.func_71530_a((String[])args, (String[])new String[]{"square", "round"});
        }
        return null;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/worldborder <global|world|dimID> [info|enable|disable|center|radius|shape] Configure FE WorldBorder.";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }
}

