/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.worldborder;

import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.worldborder.TickTaskFill;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandFiller
extends ForgeEssentialsCommandBase {
    public static HashMap<Integer, TickTaskFill> map = new HashMap();

    public String func_71517_b() {
        return "filler";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        CommandFiller.execute((ICommandSender)sender, args);
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        CommandFiller.execute(sender, args);
    }

    private static void execute(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            String header = "--- Fillers active ---";
            OutputHandler.chatNotification(sender, header);
            for (Integer world : map.keySet()) {
                OutputHandler.chatNotification(sender, world + ": " + map.get(world).getStatus());
            }
            StringBuilder footer = new StringBuilder();
            for (int i = 3; i < header.length(); ++i) {
                footer.append("-");
            }
            OutputHandler.chatNotification(sender, footer.toString());
            return;
        }
        WorldServer world = null;
        if (FunctionHelper.isNumeric(args[0])) {
            world = DimensionManager.getWorld((int)CommandFiller.func_71526_a((ICommandSender)sender, (String)args[0]));
        } else if ((args[0].equalsIgnoreCase("here") || args[0].equalsIgnoreCase("world")) && sender instanceof EntityPlayer) {
            world = (WorldServer)((EntityPlayer)sender).field_70170_p;
        }
        if (world == null) {
            OutputHandler.chatError(sender, args[0] + " is not an ID of a loaded world.");
            return;
        }
        if (args.length == 1) {
            if (map.containsKey(world.field_73011_w.field_76574_g)) {
                OutputHandler.chatConfirmation(sender, map.get(world.field_73011_w.field_76574_g).getStatus());
            } else {
                OutputHandler.chatError(sender, "There is no filler running for that world.");
            }
        } else if (args[1].equalsIgnoreCase("start")) {
            if (!map.containsKey(world.field_73011_w.field_76574_g)) {
                map.put(world.field_73011_w.field_76574_g, new TickTaskFill(world, sender, true));
            } else {
                OutputHandler.chatError(sender, "Filler already running for that world!");
            }
        } else if (args[1].equalsIgnoreCase("stop")) {
            if (!map.containsKey(world.field_73011_w.field_76574_g)) {
                OutputHandler.chatError(sender, "There is no filler running for that world.");
            } else {
                map.get(world.field_73011_w.field_76574_g).stop();
                map.remove(world.field_73011_w.field_76574_g);
            }
        } else if (args[1].equalsIgnoreCase("reset")) {
            if (!map.containsKey(world.field_73011_w.field_76574_g)) {
                map.put(world.field_73011_w.field_76574_g, new TickTaskFill(world, sender, false));
            } else {
                OutputHandler.chatError(sender, "Filler already running for that world!");
            }
        } else if (args[1].equalsIgnoreCase("speed")) {
            if (!map.containsKey(world.field_73011_w.field_76574_g)) {
                OutputHandler.chatError(sender, "There is no filler running for that world.");
            } else if (args.length != 3) {
                OutputHandler.chatConfirmation(sender, "Current speed: " + CommandFiller.map.get((Object)Integer.valueOf((int)world.field_73011_w.field_76574_g)).speed + " Chunks per Second");
            } else {
                map.get(world.field_73011_w.field_76574_g).setSpeed(CommandFiller.func_71528_a((ICommandSender)sender, (String)args[2], (int)0));
                if (CommandFiller.map.get((Object)Integer.valueOf((int)world.field_73011_w.field_76574_g)).source != sender) {
                    OutputHandler.chatError(sender, "Changed speed to " + args[2]);
                }
            }
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            if (sender instanceof EntityPlayer) {
                list.add("world");
                list.add("here");
            }
            Integer[] arr$ = DimensionManager.getIDs();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i = arr$[i$];
                list.add(Integer.toString(i));
            }
            return CommandFiller.func_71531_a((String[])args, list);
        }
        if (args.length == 2) {
            return CommandFiller.func_71530_a((String[])args, (String[])new String[]{"start", "stop", "reset", "speed"});
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "fe.worldborder.filler";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/filler [worldID start|stop|reset|speed[value]]";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }
}

