/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util.vector;

import com.forgeessentials.util.vector.Vector2;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Vector3
extends Vector2
implements Cloneable {
    protected double z;

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(Entity par1) {
        this.x = par1.field_70165_t;
        this.y = par1.field_70163_u;
        this.z = par1.field_70161_v;
    }

    public Vector3(TileEntity par1) {
        this.x = par1.field_145851_c;
        this.y = par1.field_145848_d;
        this.z = par1.field_145849_e;
    }

    public Vector3(Vec3 par1) {
        this.x = par1.field_72450_a;
        this.y = par1.field_72448_b;
        this.z = par1.field_72449_c;
    }

    public Vector3(MovingObjectPosition par1) {
        this.x = par1.field_72311_b;
        this.y = par1.field_72312_c;
        this.z = par1.field_72309_d;
    }

    public Vector3(ChunkCoordinates par1) {
        this.x = par1.field_71574_a;
        this.y = par1.field_71572_b;
        this.z = par1.field_71573_c;
    }

    public double getZ() {
        return this.z;
    }

    @Deprecated
    public static Vector3 get(Entity par1) {
        return new Vector3(par1);
    }

    @Deprecated
    public static Vector3 get(TileEntity par1) {
        return new Vector3(par1);
    }

    @Deprecated
    public static Vector3 get(Vec3 par1) {
        return new Vector3(par1);
    }

    @Deprecated
    public static Vector3 get(MovingObjectPosition par1) {
        return new Vector3(par1);
    }

    @Deprecated
    public static Vector3 get(ChunkCoordinates par1) {
        return new Vector3(par1);
    }

    public static double distance(Vector3 par1, Vector3 par2) {
        double var2 = par1.getX() - par2.getX();
        double var4 = par1.getY() - par2.getY();
        double var6 = par1.getZ() - par2.getZ();
        return MathHelper.func_76133_a((double)(var2 * var2 + var4 * var4 + var6 * var6));
    }

    public static Vector3 subtract(Vector3 par1, Vector3 par2) {
        return new Vector3(par1.getX() - par2.getX(), par1.getY() - par2.getY(), par1.getZ() - par2.getZ());
    }

    public static Vector3 add(Vector3 par1, Vector3 par2) {
        return new Vector3(par1.getX() + par2.getX(), par1.getY() + par2.getY(), par1.getZ() + par2.getZ());
    }

    public static Vector3 add(Vector3 par1, double par2) {
        return new Vector3(par1.getX() + par2, par1.getY() + par2, par1.getZ() + par2);
    }

    public static Vector3 multiply(Vector3 vec1, Vector3 vec2) {
        return new Vector3(vec1.getX() * vec2.getX(), vec1.getY() * vec2.getY(), vec1.getZ() * vec2.getZ());
    }

    public static Vector3 multiply(Vector3 vec1, double vec2) {
        return new Vector3(vec1.getX() * vec2, vec1.getY() * vec2, vec1.getZ() * vec2);
    }

    public static Vector3 readFromNBT(String prefix, NBTTagCompound par1NBTTagCompound) {
        return new Vector3(par1NBTTagCompound.func_74769_h(prefix + "X"), par1NBTTagCompound.func_74769_h(prefix + "Y"), par1NBTTagCompound.func_74769_h(prefix + "Z"));
    }

    @Override
    public int intX() {
        return (int)Math.floor(this.x);
    }

    @Override
    public int intY() {
        return (int)Math.floor(this.y);
    }

    public int intZ() {
        return (int)Math.floor(this.z);
    }

    public boolean isEquals(Vector3 vector) {
        return this.x == vector.getX() && this.y == vector.getY() && this.z == vector.getZ();
    }

    @Override
    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }

    public Block getBlock(IBlockAccess world) {
        return world.func_147439_a(this.intX(), this.intY(), this.intZ());
    }

    public int getBlockMetadata(IBlockAccess world) {
        return world.func_72805_g(this.intX(), this.intY(), this.intZ());
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world.func_147438_o(this.intX(), this.intY(), this.intZ());
    }

    public void setBlock(World world, Block block, int metadata) {
        world.func_147465_d(this.intX(), this.intY(), this.intZ(), block, metadata, 1);
    }

    public void setBlock(World world, Block block) {
        world.func_147449_b(this.intX(), this.intY(), this.intZ(), block);
    }

    public void setBlockWithNotify(World world, Block block, int metadata) {
        world.func_147465_d(this.intX(), this.intY(), this.intZ(), block, metadata, 1);
    }

    public Vector2 toVector2() {
        return new Vector2(this.x, this.z);
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public boolean isEqual(Vector3 vector3) {
        return this.x == vector3.getX() && this.y == vector3.getY() && this.z == vector3.getZ();
    }

    public double distanceTo(Vector3 vector3) {
        double var2 = vector3.getX() - this.x;
        double var4 = vector3.getY() - this.y;
        double var6 = vector3.getZ() - this.z;
        return MathHelper.func_76133_a((double)(var2 * var2 + var4 * var4 + var6 * var6));
    }

    public void add(Vector3 par1) {
        this.x += par1.getX();
        this.y += par1.getY();
        this.z += par1.getZ();
    }

    @Override
    public void add(double par1) {
        this.x += par1;
        this.y += par1;
        this.z += par1;
    }

    public void subtract(Vector3 amount) {
        this.x -= amount.getX();
        this.y -= amount.getY();
        this.z -= amount.getZ();
    }

    @Override
    public void multiply(double amount) {
        this.x *= amount;
        this.y *= amount;
        this.z *= amount;
    }

    public void multiply(Vector3 vec) {
        this.x *= vec.getX();
        this.y *= vec.getY();
        this.z *= vec.getZ();
    }

    public void writeToNBT(String prefix, NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74780_a(prefix + "X", this.x);
        par1NBTTagCompound.func_74780_a(prefix + "Y", this.y);
        par1NBTTagCompound.func_74780_a(prefix + "Z", this.z);
    }

    @Override
    public Vector3 round() {
        return new Vector3(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    @Override
    public Vector3 floor() {
        return new Vector3(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public List<Entity> getEntitiesWithin(World worldObj, Class<? extends Entity> par1Class) {
        return worldObj.func_72872_a(par1Class, AxisAlignedBB.func_72330_a((double)this.intX(), (double)this.intY(), (double)this.intZ(), (double)(this.intX() + 1), (double)(this.intY() + 1), (double)(this.intZ() + 1)));
    }

    @Override
    public String toString() {
        return "Vector3 [" + this.x + "," + this.y + "," + this.z + "]";
    }
}

