/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util.vector;

import net.minecraft.util.MathHelper;

public class Vector2
implements Cloneable {
    protected double x;
    protected double y;

    public Vector2() {
        this(0, 0);
    }

    public Vector2(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Vector2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int intX() {
        return (int)Math.floor(this.x);
    }

    public int intY() {
        return (int)Math.floor(this.y);
    }

    public Vector2 clone() {
        return new Vector2(this.x, this.y);
    }

    public static double distance(Vector2 par1, Vector2 par2) {
        double var2 = par1.x - par2.x;
        double var4 = par1.y - par2.y;
        return MathHelper.func_76133_a((double)(var2 * var2 + var4 * var4));
    }

    public static double slope(Vector2 par1, Vector2 par2) {
        double var2 = par1.x - par2.x;
        double var4 = par1.y - par2.y;
        return var4 / var2;
    }

    public void add(Vector2 par1) {
        this.x += par1.x;
        this.y += par1.y;
    }

    public void add(double par1) {
        this.x += par1;
        this.y += par1;
    }

    public void substract(Vector2 par1) {
        this.x -= par1.x;
        this.y -= par1.y;
    }

    public void substract(double par1) {
        this.x -= par1;
        this.y -= par1;
    }

    public void multiply(Vector2 par1) {
        this.x *= par1.x;
        this.y *= par1.y;
    }

    public void multiply(double par1) {
        this.x *= par1;
        this.y *= par1;
    }

    public void normalize() {
        double dist = Math.sqrt(this.x * this.x + this.y * this.y);
        this.x /= dist;
        this.y /= dist;
    }

    public Vector2 round() {
        return new Vector2(Math.round(this.x), Math.round(this.y));
    }

    public Vector2 floor() {
        return new Vector2(Math.floor(this.x), Math.floor(this.y));
    }

    public boolean isEquals(Vector2 vector) {
        return this.x == vector.x && this.y == vector.y;
    }

    public String toString() {
        return "Vector2 [" + this.x + "," + this.y + "]";
    }
}

