/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util.tasks;

import com.forgeessentials.util.tasks.ITickTask;
import com.forgeessentials.util.tasks.TimeTaskHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TaskRegistry {
    public static final int MAX_BLOCK_UPDATES = 10;
    private static TaskRegistry instance;
    protected ConcurrentLinkedQueue<ITickTask> tasks = new ConcurrentLinkedQueue();
    private TimeTaskHandler timed;

    public TaskRegistry() {
        instance = this;
        this.timed = new TimeTaskHandler();
        FMLCommonHandler.instance().bus().register((Object)instance);
    }

    public static void registerTask(ITickTask task) {
        TaskRegistry.instance.tasks.offer(task);
    }

    public static void registerSingleTask(TimerTask task, int hours, int minutes, int seconds, int milliseconds) {
        long time = TaskRegistry.getMillis(hours, minutes, seconds, milliseconds);
        TaskRegistry.instance.timed.addTask(task, time);
    }

    public static void registerSingleTask(Runnable task, int hours, int minutes, int seconds, int milliseconds) {
        TimedTaskWrapper wrapper = new TimedTaskWrapper(task);
        TaskRegistry.registerSingleTask(wrapper, hours, minutes, seconds, milliseconds);
    }

    public static void registerRecurringTask(TimerTask task, int delayHrs, int delayMin, int delaySec, int delayMilli, int intervalHrs, int intervalMin, int intervalSec, int intervalMilli) {
        long delay = TaskRegistry.getMillis(delayHrs, delayMin, delaySec, delayMilli);
        long interval = TaskRegistry.getMillis(intervalHrs, intervalMin, intervalSec, intervalMilli);
        TaskRegistry.instance.timed.addRepetingTask(task, delay, interval);
    }

    public static void registerRecurringTask(Runnable task, int delayHrs, int delayMin, int delaySec, int delayMilli, int intervalHrs, int intervalMin, int intervalSec, int intervalMilli) {
        TimedTaskWrapper wrapper = new TimedTaskWrapper(task);
        TaskRegistry.registerRecurringTask(wrapper, delayHrs, delayMin, delaySec, delayMilli, intervalHrs, intervalMin, intervalSec, intervalMilli);
    }

    public static void removeTask(TimerTask task) {
        try {
            TaskRegistry.instance.timed.removeTask(task);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void removeTask(Runnable task) {
        TimedTaskWrapper wrapper = new TimedTaskWrapper(task);
        TaskRegistry.instance.timed.removeTask(wrapper);
    }

    private static long getMillis(int hrs, int min, int sec, int milli) {
        long time = 0L;
        time = hrs;
        time = time * 60L + (long)min;
        time = time * 60L + (long)sec;
        time = time * 1000L + (long)milli;
        return time;
    }

    public void onServerStop() {
        TaskRegistry.instance.timed.kill();
        TaskRegistry.instance.timed = null;
    }

    public void onServerStart() {
        TaskRegistry.instance.timed = new TimeTaskHandler();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent e) {
        int blockCounter = 0;
        for (ITickTask task : this.tasks) {
            if (task.isComplete()) {
                task.onComplete();
                this.tasks.remove(task);
                continue;
            }
            if (task.editsBlocks() && blockCounter <= 10) {
                task.tick();
                ++blockCounter;
                continue;
            }
            task.tick();
        }
    }

    private static class TimedTaskWrapper
    extends TimerTask {
        private final Runnable runner;

        public TimedTaskWrapper(Runnable runner) {
            this.runner = runner;
        }

        @Override
        public void run() {
            this.runner.run();
        }
    }
}

