/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util.selections;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import com.forgeessentials.util.selections.SelectionHandler;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandPos
extends ForgeEssentialsCommandBase {
    private int type;

    public CommandPos(int type) {
        this.type = type;
    }

    public String func_71517_b() {
        return "/fepos" + this.type;
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP player, String[] args) {
        if (args.length == 1) {
            if (args[0].toLowerCase().equals("here")) {
                int x = (int)player.field_70165_t;
                int y = (int)player.field_70163_u;
                int z = (int)player.field_70161_v;
                if (this.type == 1) {
                    SelectionHandler.selectionProvider.setPoint1(player, new Point(x, y, z));
                } else {
                    SelectionHandler.selectionProvider.setPoint2(player, new Point(x, y, z));
                }
                OutputHandler.chatConfirmation((ICommandSender)player, "Pos" + this.type + " set to " + x + ", " + y + ", " + z);
                return;
            }
            throw new CommandException(this.func_71518_a((ICommandSender)player), new Object[0]);
        }
        if (args.length > 0) {
            int z;
            int y;
            int x;
            if (args.length < 3) {
                throw new CommandException(this.func_71518_a((ICommandSender)player), new Object[0]);
            }
            try {
                x = Integer.parseInt(args[0]);
                y = Integer.parseInt(args[1]);
                z = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                throw new CommandException(this.func_71518_a((ICommandSender)player), new Object[0]);
            }
            if (this.type == 1) {
                SelectionHandler.selectionProvider.setPoint1(player, new Point(x, y, z));
            } else {
                SelectionHandler.selectionProvider.setPoint2(player, new Point(x, y, z));
            }
            OutputHandler.chatConfirmation((ICommandSender)player, "Pos" + this.type + " set to " + x + ", " + y + ", " + z);
            return;
        }
        MovingObjectPosition mop = FunctionHelper.getPlayerLookingSpot((EntityPlayer)player);
        if (mop == null) {
            OutputHandler.chatError((ICommandSender)player, "You must first look at the ground!");
            return;
        }
        int x = mop.field_72311_b;
        int y = mop.field_72312_c;
        int z = mop.field_72309_d;
        WorldPoint point = new WorldPoint(player.field_71093_bK, x, y, z);
        if (!APIRegistry.perms.checkUserPermission(new UserIdent(player), point, this.getPermissionNode())) {
            OutputHandler.chatError((ICommandSender)player, "Insufficient permissions.");
            return;
        }
        if (this.type == 1) {
            SelectionHandler.selectionProvider.setPoint1(player, point);
        } else {
            SelectionHandler.selectionProvider.setPoint2(player, point);
        }
        OutputHandler.chatConfirmation((ICommandSender)player, "Pos" + this.type + " set to " + x + ", " + y + ", " + z);
    }

    @Override
    public String getPermissionNode() {
        return "fe.core.pos.pos";
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " [<x> <y> <z] or [here] Sets selection positions";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }
}

