/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util.questioner;

import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.questioner.Questioner;
import net.minecraft.command.ICommandSender;

public class QuestionData {
    private ICommandSender target;
    private int waitTime;
    private long startTime;
    private Questioner.IReplyHandler processAnswer;

    public QuestionData(ICommandSender target, String question, Questioner.IReplyHandler runnable, int timeout) {
        this.target = target;
        this.startTime = System.currentTimeMillis();
        this.processAnswer = runnable;
        this.waitTime = timeout;
        OutputHandler.sendMessage(target, question);
    }

    public int getTimeout() {
        return this.waitTime;
    }

    public void count() {
        if ((System.currentTimeMillis() - this.startTime) / 1000L > (long)this.waitTime) {
            Questioner.abort(this);
        }
    }

    public void doAnswer(boolean affirmative) {
        this.processAnswer.replyReceived(affirmative);
        Questioner.questionDone(this);
    }

    public ICommandSender getTarget() {
        return this.target;
    }
}

