/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util.events;

import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.events.PlayerMoveEvent;
import com.forgeessentials.util.events.ServerEventHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;

public class ForgeEssentialsEventFactory
extends ServerEventHandler {
    private HashMap<UUID, WarpPoint> lastPlayerPosition = new HashMap();

    @SubscribeEvent
    public void playerTickEvent(TickEvent.PlayerTickEvent e) {
        if (e.side != Side.SERVER || e.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)e.player;
        WarpPoint before = this.lastPlayerPosition.get(player.getPersistentID());
        WarpPoint current = new WarpPoint((Entity)e.player);
        if (before != null && !player.field_70128_L && player.field_70170_p != null && !before.equals(current)) {
            PlayerMoveEvent event = new PlayerMoveEvent((EntityPlayer)player, before, current);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled() && current.equals(new WarpPoint((Entity)e.player))) {
                FunctionHelper.teleportPlayer(player, before);
            }
        }
        this.lastPlayerPosition.put(player.getPersistentID(), new WarpPoint((Entity)e.player));
    }

    @SubscribeEvent
    public void playerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent e) {
        this.lastPlayerPosition.remove(e.player.getPersistentID());
    }
}

