/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commons.IReconstructData;
import com.forgeessentials.commons.SaveableObject;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.util.FakePlayer;

@SaveableObject(SaveInline=true)
public class UserIdent {
    @SaveableObject.SaveableField
    private UUID uuid;
    @SaveableObject.SaveableField
    private String username;
    private EntityPlayerMP player;
    private GameProfile profile;

    public UserIdent(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        this.uuid = uuid;
    }

    public UserIdent(String ident) {
        if (ident == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.uuid = UUID.fromString(ident);
        }
        catch (IllegalArgumentException e) {
            this.username = ident;
        }
    }

    public UserIdent(EntityPlayerMP player) {
        if (player == null) {
            throw new IllegalArgumentException();
        }
        this.player = player;
        this.uuid = player.getPersistentID();
        this.username = player.func_70005_c_();
    }

    public UserIdent(EntityPlayer player) {
        if (player == null) {
            throw new IllegalArgumentException();
        }
        if (player instanceof EntityPlayerMP) {
            this.player = (EntityPlayerMP)player;
        }
        this.uuid = player.getPersistentID();
        this.username = player.func_70005_c_();
    }

    public UserIdent(UUID uuid, String username) {
        if (uuid == null && (username == null || username.isEmpty())) {
            throw new IllegalArgumentException();
        }
        this.uuid = uuid;
        this.username = username;
    }

    public UserIdent(String uuid, String username) {
        if (uuid == null && (username == null || username.isEmpty())) {
            throw new IllegalArgumentException();
        }
        this.username = username;
        if (uuid != null && !uuid.isEmpty()) {
            this.uuid = UUID.fromString(uuid);
            this.username = username;
        }
    }

    public UserIdent(String ident, ICommandSender sender) {
        if (ident == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.uuid = UUID.fromString(ident);
        }
        catch (IllegalArgumentException e) {
            this.player = UserIdent.getPlayerByMatchOrUsername(sender, ident);
            if (this.player == null) {
                this.username = ident;
            }
            this.username = this.player.func_70005_c_();
            this.uuid = this.player.getPersistentID();
        }
    }

    public void identifyUser() {
        if (this.uuid == null) {
            this.uuid = UserIdent.getUuidByUsername(this.username);
        } else if (this.username == null || this.profile == null) {
            this.profile = UserIdent.getGameProfileByUuid(this.uuid);
            if (this.profile != null) {
                this.username = this.profile.getName();
            }
        }
        if (this.player == null && this.uuid != null) {
            this.player = UserIdent.getPlayerByUuid(this.uuid);
        }
    }

    public void updateUsername() {
        this.username = UserIdent.getUsernameByUuid(this.uuid);
    }

    public boolean wasValidUUID() {
        return this.uuid != null;
    }

    public boolean hasUsername() {
        this.identifyUser();
        return this.username != null;
    }

    public boolean hasUUID() {
        this.identifyUser();
        return this.uuid != null;
    }

    public boolean hasPlayer() {
        this.identifyUser();
        return this.player != null;
    }

    public boolean hasGameProfile() {
        this.identifyUser();
        return this.profile != null;
    }

    public UUID getUuid() {
        this.identifyUser();
        return this.uuid;
    }

    public String getUsername() {
        this.identifyUser();
        return this.username;
    }

    public EntityPlayerMP getPlayer() {
        this.identifyUser();
        return this.player;
    }

    public GameProfile getGameProfile() {
        this.identifyUser();
        return this.profile;
    }

    public String getUsernameOrUUID() {
        this.identifyUser();
        return this.username == null ? this.uuid.toString() : this.username;
    }

    public String toString() {
        this.identifyUser();
        return "(" + (this.uuid == null ? "" : this.uuid.toString()) + "|" + this.username + ")";
    }

    public int hashCode() {
        this.identifyUser();
        if (this.uuid == null) {
            return this.username.hashCode();
        }
        return this.uuid.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof String) {
            this.identifyUser();
            if (this.uuid != null) {
                try {
                    UUID otherUUID = UUID.fromString((String)other);
                    return this.uuid.equals(otherUUID);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            return this.username.equals(other);
        }
        if (other instanceof UserIdent) {
            UserIdent ident = (UserIdent)other;
            this.identifyUser();
            ident.identifyUser();
            if (this.uuid != null && ident.uuid != null) {
                return this.uuid.equals(ident.uuid);
            }
            if (this.username != null && ident.username != null) {
                return this.username.equals(ident.username);
            }
            return false;
        }
        if (other instanceof UUID) {
            this.identifyUser();
            return other.equals(this.uuid);
        }
        return false;
    }

    @SaveableObject.Reconstructor
    private static UserIdent reconstruct(IReconstructData tag) {
        return new UserIdent((UUID)tag.getFieldValue("uuid"), (String)tag.getFieldValue("username"));
    }

    public static UserIdent fromString(String string) {
        if (string.charAt(0) != '(' || string.charAt(string.length() - 1) != ')' || string.indexOf(124) < 0) {
            throw new IllegalArgumentException("UserIdent string needs to be in the format \"(<uuid>|<username>)\"");
        }
        String[] parts = string.substring(1, string.length() - 1).split("\\|", 2);
        return new UserIdent(UUID.fromString(parts[0]), parts[1]);
    }

    public static String getUsernameByUuid(String uuid) {
        return UserIdent.getUsernameByUuid(UUID.fromString(uuid));
    }

    public static String getUsernameByUuid(UUID uuid) {
        GameProfile profile = UserIdent.getGameProfileByUuid(uuid);
        if (profile != null) {
            return profile.getName();
        }
        for (UserIdent ident : APIRegistry.perms.getServerZone().getKnownPlayers()) {
            if (!ident.getUuid().equals(uuid)) continue;
            return ident.getUsername();
        }
        return null;
    }

    public static GameProfile getGameProfileByUuid(UUID uuid) {
        GameProfile profile = MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(uuid);
        return profile;
    }

    public static EntityPlayerMP getPlayerByUuid(UUID uuid) {
        for (EntityPlayerMP player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!player.func_146103_bH().getId().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public static EntityPlayerMP getPlayerByUsername(String name) {
        for (EntityPlayerMP player : FMLCommonHandler.instance().getSidedDelegate().getServer().func_71203_ab().field_72404_b) {
            if (!player.func_146103_bH().getName().equals(name)) continue;
            return player;
        }
        return null;
    }

    public static EntityPlayerMP getPlayerByMatchOrUsername(ICommandSender sender, String match) {
        EntityPlayerMP player = PlayerSelector.func_82386_a((ICommandSender)sender, (String)match);
        if (player != null) {
            return player;
        }
        return UserIdent.getPlayerByUsername(match);
    }

    public static UUID getUuidByUsername(String username) {
        EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(username);
        if (player != null) {
            return player.func_146103_bH().getId();
        }
        for (UserIdent ident : APIRegistry.perms.getServerZone().getKnownPlayers()) {
            if (ident.uuid == null || !username.equals(ident.getUsername())) continue;
            return ident.getUuid();
        }
        return null;
    }

    public boolean isFakePlayer() {
        this.identifyUser();
        return this.player instanceof FakePlayer;
    }
}

