/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util;

public abstract class TimeoutHandler {
    private long lastTime;
    private int interval;

    public TimeoutHandler(int interval) {
        this.interval = interval;
    }

    public TimeoutHandler(int interval, int initialDelay) {
        this.interval = interval;
        this.lastTime = System.currentTimeMillis() - (long)interval + (long)initialDelay;
    }

    public void run() {
        if (System.currentTimeMillis() - this.lastTime > (long)this.interval) {
            this.doRun();
            this.lastTime = System.currentTimeMillis();
        }
    }

    protected abstract void doRun();

    public long getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(long lastTime) {
        this.lastTime = lastTime;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }
}

