/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util;

import com.forgeessentials.commons.IReconstructData;
import com.forgeessentials.commons.SaveableObject;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.core.moduleLauncher.ModuleLauncher;
import com.forgeessentials.core.network.S1PacketSelectionUpdate;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.util.BackupArea;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.UserIdent;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerEvent;

@SaveableObject
public class PlayerInfo {
    private static HashMap<UUID, PlayerInfo> playerInfoMap = new HashMap();
    public static boolean persistSelections;
    @SaveableObject.SaveableField
    private UserIdent ident;
    @SaveableObject.UniqueLoadingKey
    private final String uuid_string;
    private String wandID;
    private int wandDmg;
    private boolean wandEnabled = false;
    @SaveableObject.SaveableField
    private WarpPoint home;
    @SaveableObject.SaveableField
    private WarpPoint lastTeleportOrigin;
    @SaveableObject.SaveableField
    private WarpPoint lastDeathLocation;
    @SaveableObject.SaveableField
    private int spawnType;
    private long lastTeleportTime = 0L;
    private HashMap<String, Integer> kitCooldown = new HashMap();
    @SaveableObject.SaveableField
    protected Point sel1;
    @SaveableObject.SaveableField
    protected Point sel2;
    @SaveableObject.SaveableField
    private int timePlayed = 0;
    private long loginTime = System.currentTimeMillis();
    @SaveableObject.SaveableField
    private long firstJoin = System.currentTimeMillis();
    private Stack<BackupArea> undos = new Stack();
    private Stack<BackupArea> redos = new Stack();
    @SaveableObject.SaveableField
    private Map<String, List<ItemStack>> inventoryGroups = new HashMap<String, List<ItemStack>>();
    @SaveableObject.SaveableField
    private String activeInventoryGroup = "default";
    private boolean hasFEClient = false;

    protected PlayerInfo() {
        this.uuid_string = null;
    }

    protected PlayerInfo(UUID uuid) {
        this.ident = new UserIdent(uuid);
        this.uuid_string = uuid.toString();
    }

    @SaveableObject.Reconstructor
    public static PlayerInfo reconstruct(IReconstructData tag) {
        UUID uuid = UUID.fromString(tag.getUniqueKey());
        PlayerInfo info = new PlayerInfo(uuid);
        if (persistSelections) {
            info.sel1 = (Point)tag.getFieldValue("sel1");
            info.sel2 = (Point)tag.getFieldValue("sel2");
        }
        info.home = (WarpPoint)tag.getFieldValue("home");
        info.lastTeleportOrigin = (WarpPoint)tag.getFieldValue("lastTeleportOrigin");
        info.lastDeathLocation = (WarpPoint)tag.getFieldValue("lastDeathLocation");
        info.spawnType = (Integer)tag.getFieldValue("spawnType");
        info.timePlayed = (Integer)tag.getFieldValue("timePlayed");
        info.firstJoin = (Long)tag.getFieldValue("firstJoin");
        return info;
    }

    public void save() {
        this.recalcTimePlayed();
        DataManager.getInstance().save(this, this.uuid_string);
    }

    @SubscribeEvent
    public void initForPlayer(PlayerEvent.LoadFromFile event) {
        PlayerInfo.getPlayerInfo(event.entityPlayer);
    }

    public static boolean playerInfoExists(UUID playerID) {
        if (playerInfoMap.containsKey(playerID)) {
            return true;
        }
        PlayerInfo info = PlayerInfo.load(playerID.toString());
        return info != null;
    }

    private static PlayerInfo load(String key) {
        PlayerInfo info = DataManager.getInstance().load(PlayerInfo.class, key);
        return info;
    }

    public static PlayerInfo getPlayerInfo(EntityPlayer player) {
        return PlayerInfo.getPlayerInfo(player.getPersistentID());
    }

    public static PlayerInfo getPlayerInfo(UserIdent ident) {
        if (!ident.hasUUID()) {
            return null;
        }
        return PlayerInfo.getPlayerInfo(ident.getUuid());
    }

    public static PlayerInfo getPlayerInfo(UUID playerID) {
        PlayerInfo info = playerInfoMap.get(playerID);
        if (info == null) {
            info = PlayerInfo.load(playerID.toString());
            if (info == null) {
                info = new PlayerInfo(playerID);
            }
            playerInfoMap.put(playerID, info);
        }
        return info;
    }

    public static void discardInfo(UUID username) {
        PlayerInfo info = playerInfoMap.remove(username);
        if (info != null) {
            info.save();
        }
    }

    public static void saveAll() {
        for (PlayerInfo info : playerInfoMap.values()) {
            info.save();
        }
    }

    public static void clear() {
        playerInfoMap.clear();
    }

    public String getWandID() {
        return this.wandID;
    }

    public void setWandID(String wandID) {
        this.wandID = wandID;
    }

    public boolean isWandEnabled() {
        return this.wandEnabled;
    }

    public void setWandEnabled(boolean wandEnabled) {
        this.wandEnabled = wandEnabled;
    }

    public int getWandDmg() {
        return this.wandDmg;
    }

    public void setWandDmg(int wandDmg) {
        this.wandDmg = wandDmg;
    }

    public long getFirstJoin() {
        return this.firstJoin;
    }

    public int getTimePlayed() {
        this.recalcTimePlayed();
        return this.timePlayed;
    }

    public void recalcTimePlayed() {
        long current = System.currentTimeMillis() - this.loginTime;
        int min = (int)(current / 60000L);
        this.timePlayed += min;
        this.loginTime = System.currentTimeMillis();
    }

    public void KitCooldownTick() {
        for (String key : this.kitCooldown.keySet()) {
            if (this.kitCooldown.get(key) == 0) {
                this.kitCooldown.remove(key);
                continue;
            }
            this.kitCooldown.put(key, this.kitCooldown.get(key) - 1);
        }
    }

    public Point getSel1() {
        return this.sel1;
    }

    public Point getSel2() {
        return this.sel2;
    }

    public void setSel1(Point point) {
        this.sel1 = point;
    }

    public void setSel2(Point point) {
        this.sel2 = point;
    }

    public void clearSelection() {
        if (!ModuleLauncher.getModuleList().contains("WEIntegration")) {
            this.sel1 = null;
            this.sel2 = null;
            FunctionHelper.netHandler.sendTo((IMessage)new S1PacketSelectionUpdate(this.ident.getPlayer()), this.ident.getPlayer());
        }
    }

    public void sendSelectionUpdate() {
        FunctionHelper.netHandler.sendTo((IMessage)new S1PacketSelectionUpdate(this.ident.getPlayer()), this.ident.getPlayer());
    }

    public Map<String, List<ItemStack>> getInventoryGroups() {
        return this.inventoryGroups;
    }

    public List<ItemStack> getInventoryGroupItems(String name) {
        return this.inventoryGroups.get(name);
    }

    public String getInventoryGroup() {
        return this.activeInventoryGroup;
    }

    public void setInventoryGroup(String name) {
        if (!this.activeInventoryGroup.equals(name)) {
            List<ItemStack> newInventory = this.inventoryGroups.get(name);
            if (newInventory == null) {
                newInventory = new ArrayList<ItemStack>();
            }
            this.inventoryGroups.put(this.activeInventoryGroup, FunctionHelper.swapInventory(this.ident.getPlayer(), newInventory));
            this.inventoryGroups.put(name, null);
            this.activeInventoryGroup = name;
        }
    }

    public void addUndoAction(BackupArea backup) {
        this.undos.push(backup);
        this.redos.clear();
    }

    public BackupArea getNextUndo() {
        if (this.undos.empty()) {
            return null;
        }
        BackupArea back = this.undos.pop();
        this.redos.push(back);
        return back;
    }

    public BackupArea getNextRedo() {
        if (this.redos.empty()) {
            return null;
        }
        BackupArea back = this.redos.pop();
        this.undos.push(back);
        return back;
    }

    public HashMap<String, Integer> getKitCooldown() {
        return this.kitCooldown;
    }

    public WarpPoint getLastTeleportOrigin() {
        return this.lastTeleportOrigin;
    }

    public void setLastTeleportOrigin(WarpPoint lastTeleportStart) {
        this.lastTeleportOrigin = lastTeleportStart;
    }

    public WarpPoint getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    public void setLastDeathLocation(WarpPoint lastDeathLocation) {
        this.lastDeathLocation = lastDeathLocation;
    }

    public long getLastTeleportTime() {
        return this.lastTeleportTime;
    }

    public void setLastTeleportTime(long currentTimeMillis) {
        this.lastTeleportTime = currentTimeMillis;
    }

    public WarpPoint getHome() {
        return this.home;
    }

    public void setHome(WarpPoint home) {
        this.home = home;
    }

    public boolean getHasFEClient() {
        return this.hasFEClient;
    }

    public void setHasFEClient(boolean status) {
        this.hasFEClient = status;
    }

    public static Map<UUID, PlayerInfo> getPlayerInfoMap() {
        return ImmutableMap.copyOf(playerInfoMap);
    }
}

