/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util;

import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.moduleLauncher.config.IConfigLoader;
import com.forgeessentials.util.FunctionHelper;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class OutputHandler
extends IConfigLoader.ConfigLoaderBase {
    public static LogWrapper felog = new LogWrapper(LogManager.getLogger((String)"ForgeEssentials"));
    private static EnumChatFormatting chatErrorColor;
    private static EnumChatFormatting chatWarningColor;
    private static EnumChatFormatting chatConfirmationColor;
    private static EnumChatFormatting chatNotificationColor;
    public static final String CONFIG_CAT = "Core.Output";

    public static void chatColored(ICommandSender sender, String msg, EnumChatFormatting color) {
        ChatComponentText cmsg = new ChatComponentText(FunctionHelper.formatColors(msg));
        cmsg.func_150256_b().func_150238_a(color);
        sender.func_145747_a((IChatComponent)cmsg);
    }

    public static void chatError(ICommandSender sender, String msg) {
        if (sender instanceof EntityPlayer) {
            OutputHandler.chatColored(sender, msg, chatErrorColor);
        } else {
            OutputHandler.sendMessage(sender, msg);
        }
    }

    public static void chatConfirmation(ICommandSender sender, String msg) {
        if (sender instanceof EntityPlayer) {
            OutputHandler.chatColored(sender, msg, chatConfirmationColor);
        } else {
            OutputHandler.sendMessage(sender, "SUCCESS: " + msg);
        }
    }

    public static void chatWarning(ICommandSender sender, String msg) {
        if (sender instanceof EntityPlayer) {
            OutputHandler.chatColored(sender, msg, chatWarningColor);
        } else {
            OutputHandler.sendMessage(sender, "WARNING: " + msg);
        }
    }

    public static void chatNotification(ICommandSender sender, String msg) {
        if (sender instanceof EntityPlayer) {
            OutputHandler.chatColored(sender, msg, chatNotificationColor);
        } else {
            OutputHandler.sendMessage(sender, "NOTICE: " + msg);
        }
    }

    public static void exception(java.util.logging.Level level, String message2, Throwable error) {
        felog.log(Level.toLevel((String)level.getName()), message2, error);
    }

    public static void debug(Object msg) {
        if (ForgeEssentials.isDebugMode()) {
            System.out.println(" {DEBUG} >>>> " + msg);
        }
    }

    public static void sendMessage(ICommandSender recipient, String message2) {
        recipient.func_145747_a(OutputHandler.createFromText(message2));
    }

    public static void sendMessage(ServerConfigurationManager configurationManager, String message2) {
        configurationManager.func_148539_a(OutputHandler.createFromText(message2));
    }

    public static IChatComponent createFromText(String string) {
        ChatComponentText component = new ChatComponentText(string);
        return component;
    }

    public static IChatComponent colourize(IChatComponent toColour, EnumChatFormatting colour) {
        ChatStyle style = new ChatStyle().func_150238_a(colour);
        toColour.func_150255_a(style);
        return toColour;
    }

    public static void setConfirmationColor(String color) {
        chatConfirmationColor = EnumChatFormatting.func_96300_b((String)color);
        if (chatConfirmationColor == null) {
            chatConfirmationColor = EnumChatFormatting.GREEN;
        }
    }

    public static void setErrorColor(String color) {
        chatErrorColor = EnumChatFormatting.func_96300_b((String)color);
        if (chatErrorColor == null) {
            chatErrorColor = EnumChatFormatting.RED;
        }
    }

    public static void setNotificationColor(String color) {
        chatNotificationColor = EnumChatFormatting.func_96300_b((String)color);
        if (chatNotificationColor == null) {
            chatNotificationColor = EnumChatFormatting.AQUA;
        }
    }

    public static void setWarningColor(String color) {
        chatWarningColor = EnumChatFormatting.func_96300_b((String)color);
        if (chatWarningColor == null) {
            chatWarningColor = EnumChatFormatting.YELLOW;
        }
    }

    @Override
    public void load(Configuration config, boolean isReload) {
        config.addCustomCategoryComment(CONFIG_CAT, "This controls the colors of the various chats output by ForgeEssentials.\nValid output colors are as follows:\naqua, black, blue, dark_aqua, dark_blue, dark_gray, dark_green, dark_purple, dark_red\ngold, gray, green, light_purple, red, white, yellow");
        OutputHandler.setConfirmationColor(config.get(CONFIG_CAT, "confirmationColor", "green", "Defaults to green.").getString());
        OutputHandler.setErrorColor(config.get(CONFIG_CAT, "errorOutputColor", "red", "Defaults to red.").getString());
        OutputHandler.setNotificationColor(config.get(CONFIG_CAT, "notificationOutputColor", "aqua", "Defaults to aqua.").getString());
        OutputHandler.setWarningColor(config.get(CONFIG_CAT, "warningOutputColor", "yellow", "Defaults to yellow.").getString());
    }

    public static class LogWrapper {
        private Logger wrapped;

        protected LogWrapper(Logger logger) {
            this.wrapped = logger;
        }

        public void finest(String message2) {
            this.wrapped.log(Level.ALL, message2);
        }

        public void finer(String message2) {
            this.wrapped.log(Level.DEBUG, message2);
        }

        public void fine(String message2) {
            this.wrapped.log(Level.INFO, message2);
        }

        public void info(String message2) {
            this.wrapped.log(Level.INFO, message2);
        }

        public void warning(String message2) {
            this.wrapped.log(Level.WARN, message2);
        }

        public void severe(String message2) {
            this.wrapped.log(Level.ERROR, message2);
        }

        public void log(Level level, String message2, Throwable error) {
            this.wrapped.log(level, message2, error);
        }

        public Logger getWrapper() {
            return this.wrapped;
        }
    }
}

