/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commons.selections.WorldPoint;
import com.google.gson.annotations.Expose;
import net.minecraft.entity.Entity;
import net.minecraft.world.WorldServer;

public class NamedWorldPoint
extends WorldPoint {
    protected String worldName;
    @Expose(serialize=false)
    protected boolean isLinked = false;
    @Expose(serialize=false)
    protected boolean isValid = true;

    public NamedWorldPoint(int dimension, String worldName, int x, int y, int z) {
        super(dimension, x, y, z);
        this.worldName = worldName;
        this.isLinked();
    }

    public NamedWorldPoint(String worldName, int x, int y, int z) {
        this(0, worldName, x, y, z);
    }

    public NamedWorldPoint(int dimension, int x, int y, int z) {
        super(dimension, x, y, z);
        this.worldName = APIRegistry.namedWorldHandler.getWorldName(dimension);
        this.isLinked();
    }

    public NamedWorldPoint(WorldPoint point) {
        this(point.getDimension(), point.getX(), point.getY(), point.getZ());
    }

    public NamedWorldPoint(Entity entity) {
        super(entity);
        this.worldName = APIRegistry.namedWorldHandler.getWorldName(this.dim);
        this.isLinked();
    }

    public boolean isLinked() {
        if (!this.isValid()) {
            return false;
        }
        return this.isLinked;
    }

    public boolean isValid() {
        if (!this.isValid) {
            if (this.worldName != null) {
                WorldServer world = APIRegistry.namedWorldHandler.getWorld(this.worldName);
                if (world != null) {
                    this.dim = world.field_73011_w.field_76574_g;
                    this.isLinked = true;
                    this.isValid = true;
                }
            } else {
                this.isLinked = false;
                this.isValid = true;
            }
        }
        return this.isValid;
    }
}

