/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commons.selections.AreaBase;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.commons.selections.WorldArea;
import com.forgeessentials.commons.selections.WorldPoint;
import com.google.gson.annotations.Expose;
import net.minecraft.world.WorldServer;

public class NamedWorldArea
extends WorldArea {
    protected String worldName;
    @Expose(serialize=false)
    protected boolean isLinked = false;
    @Expose(serialize=false)
    protected boolean isValid = true;

    public NamedWorldArea(int dimension, String worldName, Point start, Point end) {
        super(dimension, start, end);
        this.worldName = worldName;
        this.isLinked();
    }

    public NamedWorldArea(String worldName, Point start, Point end) {
        this(0, worldName, start, end);
    }

    public NamedWorldArea(String worldName, AreaBase area) {
        this(0, worldName, area.getLowPoint(), area.getHighPoint());
    }

    public NamedWorldArea(int dimension, Point start, Point end) {
        super(dimension, start, end);
        this.worldName = APIRegistry.namedWorldHandler.getWorldName(dimension);
        this.isLinked();
    }

    public NamedWorldArea(int dimension, AreaBase area) {
        this(dimension, area.getLowPoint(), area.getHighPoint());
    }

    public NamedWorldArea(WorldArea area) {
        this(area.getDimension(), area.getLowPoint(), area.getHighPoint());
    }

    public boolean isLinked() {
        if (!this.isValid()) {
            return false;
        }
        return this.isLinked;
    }

    public boolean isValid() {
        if (!this.isValid) {
            if (this.worldName != null) {
                WorldServer world = APIRegistry.namedWorldHandler.getWorld(this.worldName);
                if (world != null) {
                    this.dim = world.field_73011_w.field_76574_g;
                    this.isLinked = true;
                    this.isValid = true;
                }
            } else {
                this.isLinked = false;
                this.isValid = true;
            }
        }
        return this.isValid;
    }

    @Override
    public boolean contains(WorldPoint point) {
        if (!this.isValid()) {
            return false;
        }
        return super.contains(point);
    }

    @Override
    public boolean contains(WorldArea area) {
        if (!this.isValid()) {
            return false;
        }
        return super.contains(area);
    }
}

