/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.GroupEntry;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.core.environment.Environment;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fe.server.CommandHandlerForge;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class FunctionHelper {
    public static SimpleNetworkWrapper netHandler;
    public static final EventBus FE_INTERNAL_EVENTBUS;

    public static int parseIntDefault(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double parseDoubleDefault(String value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static List<ItemStack> swapInventory(EntityPlayerMP player, List<ItemStack> newItems) {
        ArrayList<ItemStack> oldItems = new ArrayList<ItemStack>();
        for (int slotIdx = 0; slotIdx < player.field_71071_by.func_70302_i_(); ++slotIdx) {
            oldItems.add(player.field_71071_by.func_70301_a(slotIdx));
            if (newItems != null && slotIdx < newItems.size()) {
                player.field_71071_by.func_70299_a(slotIdx, newItems.get(slotIdx));
                continue;
            }
            player.field_71071_by.func_70299_a(slotIdx, null);
        }
        return oldItems;
    }

    public static boolean isFree(World world, int x, int y, int z, int h) {
        for (int i = 0; i < h; ++i) {
            Block block = world.func_147439_a(x, y + i, z);
            if (!block.func_149688_o().func_76220_a() && !block.func_149688_o().func_76224_d()) continue;
            return false;
        }
        return true;
    }

    public static int placeInWorld(World world, int x, int y, int z, int h) {
        if (FunctionHelper.isFree(world, x, y, z, h)) {
            while (FunctionHelper.isFree(world, x, y - 1, z, h) && y > 0) {
                --y;
            }
        } else {
            ++y;
            while (y + h < world.func_72800_K() && !FunctionHelper.isFree(world, x, y, z, h)) {
                ++y;
            }
        }
        if (y == 0) {
            y = world.func_72800_K() - h;
        }
        return y;
    }

    public static int placeInWorld(World world, int x, int y, int z) {
        return FunctionHelper.placeInWorld(world, x, y, z, 2);
    }

    public static MovingObjectPosition getPlayerLookingSpot(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            return FunctionHelper.getPlayerLookingSpot(player, ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance());
        }
        return FunctionHelper.getPlayerLookingSpot(player, 5.0);
    }

    public static MovingObjectPosition getPlayerLookingSpot(EntityPlayer player, double maxDistance) {
        Vec3 lookAt = player.func_70676_i(1.0f);
        Vec3 playerPos = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)(player.func_70047_e() - player.getDefaultEyeHeight())), (double)player.field_70161_v);
        Vec3 pos1 = playerPos.func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3 pos2 = pos1.func_72441_c(lookAt.field_72450_a * maxDistance, lookAt.field_72448_b * maxDistance, lookAt.field_72449_c * maxDistance);
        return player.field_70170_p.func_72933_a(pos1, pos2);
    }

    public static String parseTime(int timeInSec) {
        String uptime = "";
        int weeks = timeInSec / 604800;
        int remainder = timeInSec % 604800;
        int days = remainder / 86400;
        remainder = timeInSec % 86400;
        int hours = remainder / 3600;
        remainder = timeInSec % 3600;
        int minutes = remainder / 60;
        int seconds = remainder % 60;
        if (weeks != 0) {
            uptime = uptime + weeks + " weeks ";
        }
        if (days != 0) {
            uptime = uptime + (days < 10 ? "0" : "") + days + " days ";
        }
        if (hours != 0) {
            uptime = uptime + (hours < 10 ? "0" : "") + hours + " h ";
        }
        if (minutes != 0) {
            uptime = uptime + (minutes < 10 ? "0" : "") + minutes + " minutes ";
        }
        uptime = uptime + (seconds < 10 ? "0" : "") + seconds + " seconds";
        return uptime;
    }

    public static String[] dropFirstString(String[] par0ArrayOfStr) {
        String[] var1 = new String[par0ArrayOfStr.length - 1];
        for (int var2 = 1; var2 < par0ArrayOfStr.length; ++var2) {
            var1[var2 - 1] = par0ArrayOfStr[var2];
        }
        return var1;
    }

    public static Pair<String, Integer> parseIdAndMetaFromString(String msg, boolean blocksOnly) throws NumberFormatException {
        String ID = null;
        int meta = -1;
        if (msg.contains(":")) {
            String[] pair = msg.split(":", 3);
            ID = pair[0] + ":" + pair[1];
            try {
                meta = Integer.parseInt(pair[2]);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(String.format("%s param was not recognized as number. Please try again.", pair[1]));
            }
        }
        return new ImmutablePair(ID, (Object)meta);
    }

    public static File getBaseDir() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            return Minecraft.func_71410_x().field_71412_D;
        }
        return new File(".");
    }

    public static File getWorldPath() {
        if (Environment.isClient()) {
            return new File(MinecraftServer.func_71276_C().func_71209_f("saves"), MinecraftServer.func_71276_C().func_71270_I());
        }
        return MinecraftServer.func_71276_C().func_71209_f(MinecraftServer.func_71276_C().func_71270_I());
    }

    private static double getTPS(int dimID) {
        try {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            long sum = 0L;
            long[] ticks = (long[])server.worldTickTimes.get(dimID);
            for (int i = 0; i < ticks.length; ++i) {
                sum += ticks[i];
            }
            double tps = (double)sum / (double)ticks.length * 1.0E-6;
            if (tps < 50.0) {
                return 20.0;
            }
            return 1000.0 / tps;
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    public static double getTPS() {
        try {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            long tickSum = 0L;
            long[] ticks = server.field_71311_j;
            for (int i = 0; i < ticks.length; ++i) {
                long var7 = ticks[i];
                tickSum += var7;
            }
            double tps = (double)tickSum / (double)ticks.length * 1.0E-6;
            if (tps < 50.0) {
                return 20.0;
            }
            return 1000.0 / tps;
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    public static String getCurrentDateString() {
        Calendar c = Calendar.getInstance();
        StringBuilder builder = new StringBuilder();
        builder.append(c.get(1));
        builder.append('-');
        builder.append(c.get(2) + 1);
        builder.append('-');
        builder.append(c.get(5));
        return builder.toString();
    }

    public static String getCurrentTimeString() {
        Calendar c = Calendar.getInstance();
        return String.format("%02d:%02d", c.get(11), c.get(12));
    }

    public static String replaceAllIgnoreCase(String text, String search, String replacement) {
        Pattern p = Pattern.compile(search, 2);
        Matcher m = p.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String formatColors(String message2) {
        char[] b = message2.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != '&' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    public static String format(String message2) {
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%smile", "\u263a");
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%copyrighted", "\u00a9");
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%registered", "\u00ae");
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%diamond", "\u2662");
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%spade", "\u2664");
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%club", "\u2667");
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%heart", "\u2661");
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%female", "\u2640");
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%male", "\u2642");
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%red", EnumChatFormatting.RED.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%yellow", EnumChatFormatting.YELLOW.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%black", EnumChatFormatting.BLACK.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%darkblue", EnumChatFormatting.DARK_BLUE.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%darkgreen", EnumChatFormatting.DARK_GREEN.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%darkaqua", EnumChatFormatting.DARK_AQUA.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%darkred", EnumChatFormatting.DARK_RED.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%purple", EnumChatFormatting.DARK_PURPLE.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%gold", EnumChatFormatting.GOLD.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%grey", EnumChatFormatting.GRAY.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%darkgrey", EnumChatFormatting.DARK_GRAY.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%indigo", EnumChatFormatting.BLUE.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%green", EnumChatFormatting.GREEN.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%aqua", EnumChatFormatting.AQUA.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%pink", EnumChatFormatting.LIGHT_PURPLE.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%white", EnumChatFormatting.WHITE.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%random", EnumChatFormatting.OBFUSCATED.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%bold", EnumChatFormatting.BOLD.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%strike", EnumChatFormatting.STRIKETHROUGH.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%underline", EnumChatFormatting.UNDERLINE.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%italics", EnumChatFormatting.ITALIC.toString());
        message2 = FunctionHelper.replaceAllIgnoreCase(message2, "%reset", EnumChatFormatting.RESET.toString());
        return message2;
    }

    public static void teleportPlayer(EntityPlayerMP player, WarpPoint p) {
        if (player.field_71093_bK != p.getDimension() && DimensionManager.isDimensionRegistered((int)p.getDimension())) {
            MinecraftServer.func_71276_C().func_71203_ab().func_72356_a(player, p.getDimension());
        }
        player.field_71135_a.func_147364_a(p.getX(), p.getY(), p.getZ(), p.getYaw(), p.getPitch());
        player.field_70169_q = player.field_70165_t = p.getX();
        player.field_70167_r = player.field_70163_u = p.getY();
        player.field_70166_s = player.field_70161_v = p.getZ();
    }

    public static void setPlayer(EntityPlayerMP player, Point point, World world) {
        if (player.field_71093_bK != world.field_73011_w.field_76574_g) {
            MinecraftServer.func_71276_C().func_71203_ab().func_72356_a(player, world.field_73011_w.field_76574_g);
        }
        double x = point.getX();
        double y = point.getY();
        double z = point.getZ();
        x = x < 0.0 ? x - 0.5 : x + 0.5;
        z = z < 0.0 ? z - 0.5 : z + 0.5;
        player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
    }

    public static boolean isNumeric(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String getPlayerPrefixSuffix(UserIdent player, boolean isSuffix) {
        String fix = APIRegistry.perms.getServerZone().getPlayerPermission(player, isSuffix ? "fe.internal.suffix" : "fe.internal.prefix");
        if (fix == null) {
            return "";
        }
        return fix;
    }

    public static String getPlayerGroupPrefixSuffix(UserIdent player, boolean isSuffix) {
        for (GroupEntry group : APIRegistry.perms.getPlayerGroups(player)) {
            String s = APIRegistry.perms.getServerZone().getGroupPermission(group.getGroup(), isSuffix ? "fe.internal.suffix" : "fe.internal.prefix");
            if (s == null) continue;
            return s;
        }
        return "";
    }

    public static String getFormattedPlayersOnline() {
        StringBuilder sb = new StringBuilder();
        for (Object fakePlayer : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            EntityPlayer player = (EntityPlayer)fakePlayer;
            String name = player.getDisplayName();
            if (player.getEntityData().func_74775_l("PlayerPersisted").func_74764_b("nickname")) {
                name = player.getEntityData().func_74775_l("PlayerPersisted").func_74779_i("nickname");
            }
            sb.append(name + ", ");
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.toString().substring(0, sb.length() - 2);
    }

    public static void saveBookToFile(ItemStack book, File savefolder) {
        String filename = "";
        if (book != null && book.func_77942_o() && book.func_77978_p().func_74764_b("title") && book.func_77978_p().func_74764_b("pages")) {
            filename = book.func_77978_p().func_74779_i("title") + ".txt";
            NBTTagList pages = (NBTTagList)book.func_77978_p().func_74781_a("pages");
            File savefile = new File(savefolder, filename);
            if (savefile.exists()) {
                savefile.delete();
            }
            try {
                savefile.createNewFile();
                try (BufferedWriter out = new BufferedWriter(new FileWriter(savefile));){
                    for (int c = 0; c < pages.func_74745_c(); ++c) {
                        String line = pages.func_150305_b(c).toString();
                        while (line.contains("\n")) {
                            out.write(line.substring(0, line.indexOf("\n")));
                            out.newLine();
                            line = line.substring(line.indexOf("\n") + 1);
                        }
                        if (line.length() <= 0) continue;
                        out.write(line);
                    }
                }
            }
            catch (Exception e) {
                OutputHandler.felog.info("Something went wrong...");
            }
        }
    }

    public static void getBookFromFile(EntityPlayer player, File file) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList pages = new NBTTagList();
        HashMap<String, String> map = new HashMap<String, String>();
        if (file.isFile() && file.getName().contains(".txt")) {
            ArrayList<String> lines = new ArrayList<String>();
            try {
                lines.add(EnumChatFormatting.GREEN + "START" + EnumChatFormatting.BLACK);
                lines.add("");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                    String line = reader.readLine();
                    while (line != null) {
                        while (line.length() > 21) {
                            lines.add(line.substring(0, 20));
                            line = line.substring(20);
                        }
                        lines.add(line);
                        line = reader.readLine();
                    }
                    reader.close();
                }
                lines.add("");
                lines.add(EnumChatFormatting.RED + "END" + EnumChatFormatting.BLACK);
            }
            catch (Exception e) {
                OutputHandler.felog.warning("Error reading script: " + file.getName());
            }
            int part = 0;
            int parts = lines.size() / 10 + 1;
            String filename = file.getName().replaceAll(".txt", "");
            if (filename.length() > 13) {
                filename = filename.substring(0, 10) + "...";
            }
            while (lines.size() != 0) {
                ++part;
                String temp = "";
                for (int i = 0; i < 10 && lines.size() > 0; ++i) {
                    temp = temp + (String)lines.get(0) + "\n";
                    lines.remove(0);
                }
                map.put(EnumChatFormatting.GOLD + " File: " + EnumChatFormatting.GRAY + filename + EnumChatFormatting.DARK_GRAY + "\nPart " + part + " of " + parts + EnumChatFormatting.BLACK + "\n\n", temp);
            }
        }
        TreeSet keys = new TreeSet(map.keySet());
        for (String name : keys) {
            pages.func_74742_a((NBTBase)new NBTTagString(name + (String)map.get(name)));
        }
        tag.func_74778_a("author", "ForgeEssentials");
        tag.func_74778_a("title", file.getName().replace(".txt", ""));
        tag.func_74782_a("pages", (NBTBase)pages);
        ItemStack is = new ItemStack(Items.field_151164_bB);
        is.func_77982_d(tag);
        player.field_71071_by.func_70441_a(is);
    }

    public static void getBookFromFile(EntityPlayer player, File file, String title) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList pages = new NBTTagList();
        HashMap<String, String> map = new HashMap<String, String>();
        if (file.isFile() && file.getName().contains(".txt")) {
            ArrayList<String> lines = new ArrayList<String>();
            try {
                lines.add(EnumChatFormatting.GREEN + "START" + EnumChatFormatting.BLACK);
                lines.add("");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                    String line = reader.readLine();
                    while (line != null) {
                        while (line.length() > 21) {
                            lines.add(line.substring(0, 20));
                            line = line.substring(20);
                        }
                        lines.add(line);
                        line = reader.readLine();
                    }
                }
                lines.add("");
                lines.add(EnumChatFormatting.RED + "END" + EnumChatFormatting.BLACK);
            }
            catch (Exception e) {
                OutputHandler.felog.warning("Error reading script: " + file.getName());
            }
            int part = 0;
            int parts = lines.size() / 10 + 1;
            String filename = file.getName().replaceAll(".txt", "");
            if (filename.length() > 13) {
                filename = filename.substring(0, 10) + "...";
            }
            while (lines.size() != 0) {
                ++part;
                String temp = "";
                for (int i = 0; i < 10 && lines.size() > 0; ++i) {
                    temp = temp + (String)lines.get(0) + "\n";
                    lines.remove(0);
                }
                map.put(EnumChatFormatting.GOLD + " File: " + EnumChatFormatting.GRAY + filename + EnumChatFormatting.DARK_GRAY + "\nPart " + part + " of " + parts + EnumChatFormatting.BLACK + "\n\n", temp);
            }
        }
        TreeSet keys = new TreeSet(map.keySet());
        for (String name : keys) {
            pages.func_74742_a((NBTBase)new NBTTagString(name + (String)map.get(name)));
        }
        tag.func_74778_a("author", "ForgeEssentials");
        tag.func_74778_a("title", title);
        tag.func_74782_a("pages", (NBTBase)pages);
        ItemStack is = new ItemStack(Items.field_151164_bB);
        is.func_77982_d(tag);
        player.field_71071_by.func_70441_a(is);
    }

    public static void getBookFromFileUnformatted(EntityPlayer player, File file) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList pages = new NBTTagList();
        HashMap<String, String> map = new HashMap<String, String>();
        if (file.isFile() && file.getName().contains(".txt")) {
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                String line = reader.readLine();
                while (line != null) {
                    lines.add(line);
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                OutputHandler.felog.warning("Error reading book: " + file.getName());
            }
            while (lines.size() != 0) {
                String temp = "";
                for (int i = 0; i < 10 && lines.size() > 0; ++i) {
                    temp = temp + (String)lines.get(0) + "\n";
                    lines.remove(0);
                }
                map.put("", temp);
            }
        }
        TreeSet keys = new TreeSet(map.keySet());
        for (String name : keys) {
            pages.func_74742_a((NBTBase)new NBTTagString(name + (String)map.get(name)));
        }
        tag.func_74778_a("author", "ForgeEssentials");
        tag.func_74778_a("title", file.getName().replace(".txt", ""));
        tag.func_74782_a("pages", (NBTBase)pages);
        ItemStack is = new ItemStack(Items.field_151164_bB);
        is.func_77982_d(tag);
        player.field_71071_by.func_70441_a(is);
    }

    public static void getBookFromFileUnformatted(EntityPlayer player, File file, String title) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList pages = new NBTTagList();
        HashMap<String, String> map = new HashMap<String, String>();
        if (file.isFile() && file.getName().contains(".txt")) {
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                String line = reader.readLine();
                while (line != null) {
                    lines.add(line);
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                OutputHandler.felog.warning("Error reading book: " + file.getName());
            }
            while (lines.size() != 0) {
                String temp = "";
                for (int i = 0; i < 10 && lines.size() > 0; ++i) {
                    temp = temp + (String)lines.get(0) + "\n";
                    lines.remove(0);
                }
                map.put("", temp);
            }
        }
        TreeSet keys = new TreeSet(map.keySet());
        for (String name : keys) {
            pages.func_74742_a((NBTBase)new NBTTagString(name + (String)map.get(name)));
        }
        tag.func_74778_a("author", "ForgeEssentials");
        tag.func_74778_a("title", title);
        tag.func_74782_a("pages", (NBTBase)pages);
        ItemStack is = new ItemStack(Items.field_151164_bB);
        is.func_77982_d(tag);
        player.field_71071_by.func_70441_a(is);
    }

    public static void getBookFromFolder(EntityPlayer player, File folder) {
        File[] listOfFiles;
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList pages = new NBTTagList();
        HashMap<String, String> map = new HashMap<String, String>();
        for (File file : listOfFiles = folder.listFiles()) {
            if (!file.isFile() || !file.getName().contains(".txt")) continue;
            ArrayList<String> lines = new ArrayList<String>();
            try {
                lines.add(EnumChatFormatting.GREEN + "START" + EnumChatFormatting.BLACK);
                lines.add("");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                    String line = reader.readLine();
                    while (line != null) {
                        while (line.length() > 21) {
                            lines.add(line.substring(0, 20));
                            line = line.substring(20);
                        }
                        lines.add(line);
                        line = reader.readLine();
                    }
                }
                lines.add("");
                lines.add(EnumChatFormatting.RED + "END" + EnumChatFormatting.BLACK);
            }
            catch (Exception e) {
                OutputHandler.felog.warning("Error reading script: " + file.getName());
            }
            int part = 0;
            int parts = lines.size() / 10 + 1;
            String filename = file.getName().replaceAll(".txt", "");
            if (filename.length() > 13) {
                filename = filename.substring(0, 10) + "...";
            }
            while (lines.size() != 0) {
                ++part;
                String temp = "";
                for (int i = 0; i < 10 && lines.size() > 0; ++i) {
                    temp = temp + (String)lines.get(0) + "\n";
                    lines.remove(0);
                }
                map.put(EnumChatFormatting.GOLD + " File: " + EnumChatFormatting.GRAY + filename + EnumChatFormatting.DARK_GRAY + "\nPart " + part + " of " + parts + EnumChatFormatting.BLACK + "\n\n", temp);
            }
        }
        TreeSet keys = new TreeSet(map.keySet());
        for (String name : keys) {
            pages.func_74742_a((NBTBase)new NBTTagString(name + (String)map.get(name)));
        }
        tag.func_74778_a("author", "ForgeEssentials");
        tag.func_74778_a("title", folder.getName());
        tag.func_74782_a("pages", (NBTBase)pages);
        ItemStack is = new ItemStack(Items.field_151164_bB);
        is.func_77982_d(tag);
        player.field_71071_by.func_70441_a(is);
    }

    public static void getBookFromFolder(EntityPlayer player, File folder, String title) {
        File[] listOfFiles;
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList pages = new NBTTagList();
        HashMap<String, String> map = new HashMap<String, String>();
        for (File file : listOfFiles = folder.listFiles()) {
            if (!file.isFile() || !file.getName().contains(".txt")) continue;
            ArrayList<String> lines = new ArrayList<String>();
            try {
                lines.add(EnumChatFormatting.GREEN + "START" + EnumChatFormatting.BLACK);
                lines.add("");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                    String line = reader.readLine();
                    while (line != null) {
                        while (line.length() > 21) {
                            lines.add(line.substring(0, 20));
                            line = line.substring(20);
                        }
                        lines.add(line);
                        line = reader.readLine();
                    }
                }
                lines.add("");
                lines.add(EnumChatFormatting.RED + "END" + EnumChatFormatting.BLACK);
            }
            catch (Exception e) {
                OutputHandler.felog.warning("Error reading script: " + file.getName());
            }
            int part = 0;
            int parts = lines.size() / 10 + 1;
            String filename = file.getName().replaceAll(".txt", "");
            if (filename.length() > 13) {
                filename = filename.substring(0, 10) + "...";
            }
            while (lines.size() != 0) {
                ++part;
                String temp = "";
                for (int i = 0; i < 10 && lines.size() > 0; ++i) {
                    temp = temp + (String)lines.get(0) + "\n";
                    lines.remove(0);
                }
                map.put(EnumChatFormatting.GOLD + " File: " + EnumChatFormatting.GRAY + filename + EnumChatFormatting.DARK_GRAY + "\nPart " + part + " of " + parts + EnumChatFormatting.BLACK + "\n\n", temp);
            }
        }
        TreeSet keys = new TreeSet(map.keySet());
        for (String name : keys) {
            pages.func_74742_a((NBTBase)new NBTTagString(name + (String)map.get(name)));
        }
        tag.func_74778_a("author", "ForgeEssentials");
        tag.func_74778_a("title", title);
        tag.func_74782_a("pages", (NBTBase)pages);
        ItemStack is = new ItemStack(Items.field_151164_bB);
        is.func_77982_d(tag);
        player.field_71071_by.func_70441_a(is);
    }

    public static JsonObject toJSON(ItemStack stack, Boolean listEnch) throws JsonParseException {
        JsonObject data = new JsonObject();
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("display") && stack.field_77990_d.func_74775_l("display").func_74764_b("Name")) {
            data.add("item", (JsonElement)new JsonPrimitive(stack.func_82833_r().replaceAll("item.", "").replaceAll("tile.", "")));
        }
        if (stack.field_77994_a != 1) {
            data.add("amount", (JsonElement)new JsonPrimitive("" + stack.field_77994_a));
        }
        data.add("id", (JsonElement)new JsonPrimitive("" + stack.func_77977_a()));
        if (stack.func_77960_j() != 0) {
            data.add("dam", (JsonElement)new JsonPrimitive("" + stack.func_77960_j()));
        }
        data.add("name", (JsonElement)new JsonPrimitive(stack.func_82833_r()));
        if (listEnch.booleanValue()) {
            JsonArray tempArgs = new JsonArray();
            NBTTagList var10 = stack.func_77986_q();
            if (var10 != null) {
                for (int var7 = 0; var7 < var10.func_74745_c(); ++var7) {
                    short var8 = var10.func_150305_b(var7).func_74765_d("id");
                    short var9 = var10.func_150305_b(var7).func_74765_d("lvl");
                    if (Enchantment.field_77331_b[var8] == null) continue;
                    tempArgs.add((JsonElement)new JsonPrimitive(Enchantment.field_77331_b[var8].func_77316_c((int)var9)));
                }
                data.add("ench", (JsonElement)tempArgs);
            }
        }
        return data;
    }

    public static void registerServerCommand(ForgeEssentialsCommandBase command) {
        if (command.getPermissionNode() != null && command.getDefaultPermission() != null) {
            CommandHandlerForge.registerCommand((ICommand)command, command.getPermissionNode(), command.getDefaultPermission());
        } else {
            ((CommandHandler)MinecraftServer.func_71276_C().func_71187_D()).func_71560_a((ICommand)command);
        }
    }

    static {
        FE_INTERNAL_EVENTBUS = APIRegistry.getFEEventBus();
    }
}

