/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util;

import com.forgeessentials.util.OutputHandler;
import com.google.common.base.Throwables;
import java.util.IllegalFormatException;

public enum EnumDBType {
    H2_FILE(false, "org.h2.Driver", "jdbc:h2:file:%s;IGNORECASE=TRUE;FILE_LOCK=NO;MODE=MYSQL"),
    MySQL(true, "com.mysql.jdbc.Driver", "jdbc:mysql://%s:%d/%s");

    public boolean isRemote;
    private final String driver;
    private String connect;

    private EnumDBType(boolean isRemote, String driverName, String connectString) {
        this.isRemote = isRemote;
        this.driver = driverName;
        this.connect = connectString;
    }

    public void loadClass() {
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            OutputHandler.felog.severe("Could not load the " + (Object)((Object)this) + " JDBC Driver! Does it exist in the lib directory?");
            Throwables.propagateIfPossible((Throwable)e);
        }
    }

    public String getConnectionString(Object ... data) throws IllegalFormatException {
        String formatted = String.format(this.connect, data);
        return formatted;
    }
}

