/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util;

import com.forgeessentials.util.EnumDBType;
import com.forgeessentials.util.OutputHandler;
import com.google.common.base.Throwables;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.StringUtils;

public class DBConnector {
    EnumDBType loadedType;
    private final DBConnector fallback;
    public final String name;
    private final EnumDBType dType;
    private EnumDBType type;
    private EnumDBType tempType;
    private final String dbDefault;
    private final String dbFileDefault;
    private boolean useParent;
    private HashMap<EnumDBType, HashMap<String, Property>> data;

    public DBConnector(String name, DBConnector fallback, EnumDBType dType, String dbDefault, String dbFileDefault, boolean useFallback) {
        this.name = name;
        this.fallback = fallback;
        this.type = this.tempType = dType;
        this.dType = this.tempType;
        this.dbDefault = dbDefault;
        this.dbFileDefault = dbFileDefault;
        this.data = new HashMap();
        this.useParent = useFallback;
    }

    public void write(Configuration config, String cat) {
        config.get(cat, "chosenType", this.dType.toString(), " valid types: " + StringUtils.join((Object[])EnumDBType.values(), (String)", ")).set(this.type.toString());
        if (this.fallback != null) {
            config.get(cat, "checkParent", this.useParent, "If this is true, settings will be taken from the parent, most probably the Main or Core config. This is only taken into effect with remote databases.").set(this.useParent);
        }
        for (EnumDBType dbType : EnumDBType.values()) {
            String newcat = cat + "." + (Object)((Object)dbType);
            HashMap<String, Property> props = this.data.get((Object)dbType);
            if (props == null) continue;
            if (dbType.isRemote) {
                config.get(newcat, "host", "localhost").set(props.get("host").getString());
                config.get(newcat, "port", 3360).set(props.get("port").getString());
                config.get(newcat, "database", this.dbDefault).set(props.get("database").getString());
                config.get(newcat, "user", "FEUSER").set(props.get("user").getString());
                config.get(newcat, "pass", "password").set(props.get("pass").getString());
                continue;
            }
            config.get(newcat, "database", this.dbFileDefault, "this may be a file path as well.").set(props.get("database").getString());
        }
    }

    public void loadOrGenerate(Configuration config, String cat) {
        try {
            this.tempType = this.type = EnumDBType.valueOf(config.get(cat, "chosenType", this.dType.toString()).getString());
            if (this.fallback != null) {
                this.useParent = config.get(cat, "checkParent", false).getBoolean(false);
            }
        }
        catch (Exception e) {
            this.tempType = this.type = this.dType;
        }
        for (EnumDBType dbType : EnumDBType.values()) {
            String newcat = cat + "." + (Object)((Object)dbType);
            HashMap<String, Object> props = this.data.get((Object)dbType);
            if (props == null) {
                props = new HashMap();
                this.data.put(dbType, props);
            }
            if (dbType.isRemote) {
                props.put("host", config.get(newcat, "host", "localhost"));
                props.put("port", config.get(newcat, "port", 3306));
                props.put("database", config.get(newcat, "database", this.dbDefault));
                props.put("user", config.get(newcat, "user", "FEUSER"));
                props.put("pass", config.get(newcat, "pass", "password"));
                continue;
            }
            props.put("database", config.get(newcat, "database", this.dbFileDefault, "this may be a file path as well."));
        }
        config.get(cat, "chosenType", this.type.toString(), " valid types: " + StringUtils.join((Object[])EnumDBType.values(), (String)", "));
        config.get(cat, "checkParent", this.useParent, "If this is true, settings will be taken from the parent, most probably the Main or Core config. This is only taken into effect with remote databases.");
    }

    public Connection getChosenConnection() {
        try {
            HashMap<String, Property> props = this.data.get((Object)this.type);
            if (this.type.isRemote) {
                Connection con;
                if (this.useParent) {
                    con = this.fallback.getSpecificConnection(this.type);
                    if (con != null) {
                        return con;
                    }
                    OutputHandler.felog.warning("[FE+SQL] " + this.name + " Parent check failed, going to in-house.");
                }
                String host = props.get("host").getString();
                int port = props.get("port").getInt();
                String database = props.get("database").getString();
                String user = props.get("user").getString();
                String pass = props.get("pass").getString();
                this.type.loadClass();
                String connect = this.type.getConnectionString(host, port, database);
                con = DriverManager.getConnection(connect, user, pass);
                return con;
            }
            String database = props.get("database").getString();
            String connect = this.type.getConnectionString(database);
            Connection con = DriverManager.getConnection(connect);
            return con;
        }
        catch (Exception e) {
            OutputHandler.exception(Level.WARNING, "[FE+SQL] " + this.name + " In-House check failed, going to default.", e);
            try {
                this.tempType = this.dType;
                HashMap<String, Property> props = this.data.get((Object)this.dType);
                if (this.dType.isRemote) {
                    String host = props.get("host").getString();
                    int port = props.get("port").getInt();
                    String database = props.get("database").getString();
                    String user = props.get("user").getString();
                    String pass = props.get("pass").getString();
                    this.dType.loadClass();
                    String connect = this.dType.getConnectionString(host, port, database);
                    return DriverManager.getConnection(connect, user, pass);
                }
                String database = props.get("database").getString();
                String connect = this.dType.getConnectionString(database);
                return DriverManager.getConnection(connect);
            }
            catch (SQLException e2) {
                OutputHandler.felog.severe("[FE+SQL] " + this.name + " CATASTROPHIC DATABASE CONNECTION FAILIURE!!!");
                Throwables.propagate((Throwable)e2);
                return null;
            }
        }
    }

    private Connection getSpecificConnection(EnumDBType dbType) throws IllegalArgumentException {
        if (!dbType.isRemote) {
            throw new IllegalArgumentException("Non remote type " + (Object)((Object)dbType) + " is asking for parent config!");
        }
        try {
            HashMap<String, Property> props = this.data.get((Object)dbType);
            String host = props.get("host").getString();
            int port = props.get("port").getInt();
            String database = props.get("database").getString();
            String user = props.get("user").getString();
            String pass = props.get("pass").getString();
            dbType.loadClass();
            String connect = dbType.getConnectionString(host, port, database);
            return DriverManager.getConnection(connect, user, pass);
        }
        catch (Exception e) {
            OutputHandler.felog.severe("[FE+SQL] " + this.name + " Failed parent check: " + e);
            return null;
        }
    }

    public EnumDBType getActiveType() {
        return this.tempType;
    }
}

