/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.TreeSet;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class CommandParserArgs {
    public final String command;
    public final Queue<String> args;
    public final ICommandSender sender;
    public final EntityPlayerMP senderPlayer;
    public final UserIdent userIdent;
    public final boolean isTabCompletion;
    public List<String> tabCompletion = null;

    public CommandParserArgs(String command, String[] args, ICommandSender sender, boolean isTabCompletion) {
        this.command = command;
        this.args = new LinkedList<String>(Arrays.asList(args));
        this.sender = sender;
        this.senderPlayer = sender instanceof EntityPlayerMP ? (EntityPlayerMP)sender : null;
        this.userIdent = this.senderPlayer == null ? null : new UserIdent(this.senderPlayer);
        this.isTabCompletion = isTabCompletion;
    }

    public CommandParserArgs(String commandName, String[] args, ICommandSender sender) {
        this(commandName, args, sender, false);
    }

    public void info(String message2) {
        if (!this.isTabCompletion) {
            OutputHandler.chatConfirmation(this.sender, message2);
        }
    }

    public void warn(String message2) {
        if (!this.isTabCompletion) {
            OutputHandler.chatWarning(this.sender, message2);
        }
    }

    public void error(String message2) {
        if (!this.isTabCompletion) {
            OutputHandler.chatError(this.sender, message2);
        }
    }

    public int size() {
        return this.args.size();
    }

    public String remove() {
        return this.args.remove();
    }

    public String peek() {
        return this.args.peek();
    }

    public boolean isEmpty() {
        return this.args.isEmpty();
    }

    public boolean hasPlayer() {
        return this.senderPlayer != null;
    }

    public UserIdent parsePlayer() {
        if (this.isTabCompletion && this.size() == 1) {
            this.tabCompletion = CommandParserArgs.completePlayer(this.peek());
            return null;
        }
        if (this.isEmpty()) {
            if (this.userIdent != null) {
                return this.userIdent;
            }
            throw new CommandException("Not enough arguments!", new Object[0]);
        }
        String name = this.remove();
        if (name.equalsIgnoreCase("_ME_")) {
            if (this.senderPlayer == null) {
                throw new CommandException("_ME_ cannot be used in console.", new Object[0]);
            }
            return new UserIdent(this.senderPlayer);
        }
        return new UserIdent(name, this.sender);
    }

    public static List<String> completePlayer(String arg) {
        TreeSet<String> result = new TreeSet<String>();
        for (UserIdent knownPlayerIdent : APIRegistry.perms.getServerZone().getKnownPlayers()) {
            if (!CommandBase.func_71523_a((String)arg, (String)knownPlayerIdent.getUsernameOrUUID())) continue;
            result.add(knownPlayerIdent.getUsernameOrUUID());
        }
        for (UserIdent player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!CommandBase.func_71523_a((String)arg, (String)((EntityPlayerMP)player).func_146103_bH().getName())) continue;
            result.add(((EntityPlayerMP)player).func_146103_bH().getName());
        }
        return new ArrayList<String>(result);
    }

    public void checkPermission(String perm) {
        if (this.userIdent != null && !APIRegistry.perms.checkUserPermission(this.userIdent, perm)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
    }
}

