/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.util;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockSaveable {
    private int x;
    private int y;
    private int z;
    private Block blockID;
    private byte metadata;
    private NBTTagCompound tile;

    public BlockSaveable(World world, int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockID = world.func_147439_a(x, y, z);
        this.metadata = (byte)world.func_72805_g(x, y, z);
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null) {
            try {
                NBTTagCompound compound = new NBTTagCompound();
                entity.func_145841_b(compound);
                this.tile = compound;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BlockSaveable) {
            BlockSaveable block = (BlockSaveable)object;
            boolean tileEqual = this.tile == null ? block.tile == null : this.tile.equals((Object)block.tile);
            return tileEqual && this.blockID == block.blockID && this.metadata == block.metadata;
        }
        return false;
    }

    public int hashCode() {
        int h = 11 + this.x;
        h = h * 29 + this.y;
        h = h * 29 + this.z;
        h = h * 29 + this.blockID.hashCode();
        h = h * 29 + this.metadata;
        h = h * 29 + this.tile.hashCode();
        return h;
    }

    public boolean setinWorld(World world) {
        if (this.equals(new BlockSaveable(world, this.x, this.y, this.z))) {
            return false;
        }
        world.func_147465_d(this.x, this.y, this.z, this.blockID, (int)this.metadata, 3);
        TileEntity entity = world.func_147438_o(this.x, this.y, this.z);
        if (entity != null && this.tile != null) {
            entity.func_145839_a(this.tile);
        }
        return true;
    }
}

