/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.tickets;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.tickets.Command;
import com.forgeessentials.tickets.ConfigTickets;
import com.forgeessentials.tickets.Ticket;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.FEModuleEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.permissions.PermissionsManager;

@FEModule(name="Tickets", parentMod=ForgeEssentials.class)
public class ModuleTickets {
    public static final String PERMBASE = "fe.tickets";
    public static ArrayList<Ticket> ticketList = new ArrayList();
    public static List<String> categories = new ArrayList<String>();
    public static int currentID;

    @SubscribeEvent
    public void load(FEModuleEvent.FEModuleInitEvent e) {
        FMLCommonHandler.instance().bus().register((Object)this);
        ForgeEssentials.getConfigManager().registerLoader("Tickets", new ConfigTickets());
    }

    @SubscribeEvent
    public void serverStarting(FEModuleEvent.FEModuleServerInitEvent e) {
        FunctionHelper.registerServerCommand(new Command());
        ModuleTickets.loadAll();
        APIRegistry.perms.registerPermission("fe.tickets.new", PermissionsManager.RegisteredPermValue.TRUE);
        APIRegistry.perms.registerPermission("fe.tickets.view", PermissionsManager.RegisteredPermValue.TRUE);
        APIRegistry.perms.registerPermission("fe.tickets.tp", PermissionsManager.RegisteredPermValue.TRUE);
        APIRegistry.perms.registerPermission("fe.tickets.admin", PermissionsManager.RegisteredPermValue.OP);
    }

    @SubscribeEvent
    public void serverStopping(FEModuleEvent.FEModuleServerStopEvent e) {
        ModuleTickets.saveAll();
    }

    public static int getNextID() {
        return ++currentID;
    }

    public static void loadAll() {
        Map<String, Ticket> loadedTickets = DataManager.getInstance().loadAll(Ticket.class);
        ticketList.clear();
        for (Ticket ticket : loadedTickets.values()) {
            ticketList.add(ticket);
        }
    }

    public static void saveAll() {
        for (Ticket ticket : ticketList) {
            DataManager.getInstance().save(ticket, Integer.toString(ticket.id));
        }
    }

    public static Ticket getID(int i) {
        for (Ticket ticket : ticketList) {
            if (ticket.id != i) continue;
            return ticket;
        }
        return null;
    }

    @SubscribeEvent
    public void loadData(PlayerEvent.PlayerLoggedInEvent e) {
        if (PermissionsManager.checkPermission(e.player, "fe.tickets.admin") && !ticketList.isEmpty()) {
            OutputHandler.sendMessage((ICommandSender)e.player, EnumChatFormatting.DARK_AQUA + "There are " + ticketList.size() + " open tickets.");
        }
    }
}

