/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.tickets;

import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.core.misc.TeleportHelper;
import com.forgeessentials.tickets.ModuleTickets;
import com.forgeessentials.tickets.Ticket;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.permissions.PermissionsManager;

public class Command
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "ticket";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("tickets");
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        this.doStuff((ICommandSender)sender, args);
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        this.doStuff(sender, args);
    }

    public void doStuff(ICommandSender sender, String[] args) {
        Ticket t;
        int id;
        String c = EnumChatFormatting.DARK_AQUA.toString();
        if (args.length == 0) {
            String usage = "list|new|view";
            if (this.permcheck(sender, "tp")) {
                usage = usage + "|tp <id>";
            }
            if (this.permcheck(sender, "admin")) {
                usage = usage + "|del <id>";
            }
            OutputHandler.chatError(sender, "Usage: /ticket <" + usage + ">");
            return;
        }
        if (args[0].equalsIgnoreCase("view") && this.permcheck(sender, "view")) {
            if (args.length != 2) {
                OutputHandler.chatError(sender, "Usage: /ticket view <id>");
                return;
            }
            id = Command.func_71532_a((ICommandSender)sender, (String)args[1], (int)0, (int)(ModuleTickets.currentID + 1));
            t = ModuleTickets.getID(id);
            OutputHandler.chatNotification(sender, c + "#" + t.id + " : " + t.creator + " - " + t.category + " - " + t.message);
        }
        if (args[0].equalsIgnoreCase("list") && this.permcheck(sender, "view")) {
            int page = 0;
            int pages = ModuleTickets.ticketList.size() / 7;
            if (args.length == 2) {
                page = Command.func_71532_a((ICommandSender)sender, (String)args[1], (int)0, (int)pages);
            }
            OutputHandler.chatNotification(sender, c + "--- Ticket List ---");
            for (int i = page * 7; i < (page + 1) * 7; ++i) {
                try {
                    Ticket t2 = ModuleTickets.ticketList.get(i);
                    OutputHandler.chatNotification(sender, "#" + t2.id + ": " + t2.creator + " - " + t2.category + " - " + t2.message);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            OutputHandler.chatNotification(sender, c + String.format("--- Page %1$d of %2$d ---", page, pages));
            return;
        }
        if (args[0].equalsIgnoreCase("new") && this.permcheck(sender, "new")) {
            if (args.length < 3) {
                OutputHandler.chatError(sender, "Usage: /ticket new <category> <message ...>");
                return;
            }
            if (!ModuleTickets.categories.contains(args[1])) {
                OutputHandler.chatError(sender, String.format("message.error.illegalCategory", args[1]));
                return;
            }
            String msg = "";
            for (String var : FunctionHelper.dropFirstString(FunctionHelper.dropFirstString(args))) {
                msg = msg + " " + var;
            }
            msg = msg.substring(1);
            t = new Ticket(sender, args[1], msg);
            ModuleTickets.ticketList.add(t);
            OutputHandler.chatNotification(sender, c + String.format("message.confim.ticketPost", t.id));
            return;
        }
        if (args[0].equalsIgnoreCase("tp") && this.permcheck(sender, "tp")) {
            if (args.length != 2) {
                OutputHandler.chatError(sender, "Usage: /ticket tp <id>");
                return;
            }
            id = Command.func_71532_a((ICommandSender)sender, (String)args[1], (int)0, (int)(ModuleTickets.currentID + 1));
            TeleportHelper.teleport((EntityPlayerMP)sender, ModuleTickets.getID((int)id).point);
        }
        if (args[0].equalsIgnoreCase("del") && this.permcheck(sender, "admin")) {
            if (args.length != 2) {
                OutputHandler.chatError(sender, "Usage: /ticket del <id>");
                return;
            }
            id = Command.func_71532_a((ICommandSender)sender, (String)args[1], (int)0, (int)ModuleTickets.currentID);
            ModuleTickets.ticketList.remove(ModuleTickets.getID(id));
            OutputHandler.chatConfirmation(sender, c + String.format("Your ticket has been posted. ID: %d", id));
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.tickets.command";
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return Command.func_71530_a((String[])args, (String[])new String[]{"list", "new", "view", "tp", "del"});
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("new")) {
            return Command.func_71531_a((String[])args, ModuleTickets.categories);
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("tp") || args[0].equalsIgnoreCase("del"))) {
            ArrayList<String> list = new ArrayList<String>();
            for (Ticket t : ModuleTickets.ticketList) {
                list.add("" + t.id);
            }
            return Command.func_71531_a((String[])args, list);
        }
        return null;
    }

    public boolean permcheck(ICommandSender sender, String perm) {
        if (sender instanceof EntityPlayer) {
            return PermissionsManager.checkPermission((EntityPlayer)sender, "fe.tickets." + perm);
        }
        return true;
    }

    public String func_71518_a(ICommandSender sender) {
        String usage = "list|new|view";
        if (this.permcheck(sender, "tp")) {
            usage = usage + "|tp <id>";
        }
        if (this.permcheck(sender, "admin")) {
            usage = usage + "|del <id>";
        }
        return "Usage: /ticket <" + usage + ">";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }
}

