/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.teleport.util;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.GroupEntry;
import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.PlayerInfo;
import com.forgeessentials.util.UserIdent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class RespawnHandler {
    public RespawnHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static WarpPoint getPlayerSpawn(EntityPlayer player, WarpPoint location) {
        UserIdent ident = new UserIdent(player);
        if (location == null) {
            location = new WarpPoint((Entity)player);
        }
        String spawnProperty = APIRegistry.perms.getPermission(ident, location.toWorldPoint(), null, GroupEntry.toList(APIRegistry.perms.getPlayerGroups(ident)), "fe.internal.spawn", true);
        WorldPoint point = null;
        if (spawnProperty == null) {
            return null;
        }
        if (spawnProperty.equalsIgnoreCase("bed")) {
            if (player.func_70997_bJ() != null) {
                ChunkCoordinates spawn = player.func_70997_bJ();
                EntityPlayer.func_71056_a((World)player.field_70170_p, (ChunkCoordinates)spawn, (boolean)true);
                point = new WorldPoint(player.field_71093_bK, spawn.field_71574_a, spawn.field_71572_b, spawn.field_71573_c);
            }
        } else {
            point = WorldPoint.fromString(spawnProperty);
        }
        if (point == null) {
            return null;
        }
        return new WarpPoint(point, player.field_71109_bG, player.field_70726_aT);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerDeath(LivingDeathEvent e) {
        if (e.entityLiving instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)e.entityLiving;
            PlayerInfo.getPlayerInfo(player.getPersistentID()).setLastDeathLocation(new WarpPoint((Entity)player));
        }
    }

    @SubscribeEvent
    public void doFirstRespawn(EntityJoinWorldEvent e) {
        WarpPoint p;
        EntityPlayerMP player;
        if (e.entity instanceof EntityPlayerMP && !PlayerInfo.playerInfoExists((player = (EntityPlayerMP)e.entity).getPersistentID()) && (p = RespawnHandler.getPlayerSpawn((EntityPlayer)player, null)) != null) {
            FunctionHelper.teleportPlayer(player, p);
            player.field_70165_t = p.getX();
            player.field_70163_u = p.getY();
            player.field_70161_v = p.getZ();
        }
    }

    @SubscribeEvent
    public void doRespawn(PlayerEvent.PlayerRespawnEvent e) {
        WarpPoint p;
        WarpPoint lastDeathLocation = PlayerInfo.getPlayerInfo(e.player.getPersistentID()).getLastDeathLocation();
        if (lastDeathLocation == null) {
            lastDeathLocation = new WarpPoint((Entity)e.player);
        }
        if ((p = RespawnHandler.getPlayerSpawn(e.player, lastDeathLocation)) != null) {
            FunctionHelper.teleportPlayer((EntityPlayerMP)e.player, p);
            e.player.field_70165_t = p.getX();
            e.player.field_70163_u = p.getY();
            e.player.field_70161_v = p.getZ();
        }
    }
}

