/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.teleport.portal;

import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.core.misc.TeleportHelper;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.teleport.portal.Portal;
import com.forgeessentials.util.events.FEModuleEvent;
import com.forgeessentials.util.events.PlayerMoveEvent;
import com.forgeessentials.util.events.ServerEventHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.BlockEvent;

public class PortalManager
extends ServerEventHandler {
    private static PortalManager instance;
    protected Map<String, Portal> portals = new HashMap<String, Portal>();

    public PortalManager() {
        instance = this;
    }

    public static PortalManager getInstance() {
        return instance;
    }

    @Override
    @SubscribeEvent
    public void serverStopped(FEModuleEvent.FEModuleServerStoppedEvent e) {
        super.serverStopped(e);
        this.save();
    }

    public void load() {
        this.portals = DataManager.getInstance().loadAll(Portal.class);
        for (Portal portal : this.portals.values()) {
            PortalManager.buildPortalFrame(portal);
        }
    }

    public void save() {
        for (Map.Entry<String, Portal> portal : this.portals.entrySet()) {
            DataManager.getInstance().save(portal.getValue(), portal.getKey());
        }
    }

    @SubscribeEvent
    public void playerMove(PlayerMoveEvent e) {
        WorldPoint after = e.after.toWorldPoint();
        WorldPoint before = e.before.toWorldPoint();
        for (Portal portal : this.portals.values()) {
            if (!portal.getPortalArea().contains(after) || portal.getPortalArea().contains(before)) continue;
            TeleportHelper.doTeleport((EntityPlayerMP)e.entityPlayer, new WarpPoint(portal.target, e.entityPlayer.field_70125_A, e.entityPlayer.field_70177_z));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void breakEvent(BlockEvent.BreakEvent e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        WorldPoint point = new WorldPoint(e.getPlayer().field_71093_bK, e.x, e.y, e.z);
        for (Portal portal : this.portals.values()) {
            if (!portal.getPortalArea().contains(point)) continue;
            e.setCanceled(true);
            break;
        }
    }

    public void remove(String name) {
        this.portals.remove(name);
        DataManager.getInstance().delete(Portal.class, name);
    }

    public void add(String name, Portal portal) {
        this.portals.put(name, portal);
        DataManager.getInstance().save(portal, name);
        PortalManager.buildPortalFrame(portal);
    }

    private static void buildPortalFrame(Portal portal) {
        WorldServer world = DimensionManager.getWorld((int)portal.getPortalArea().getDimension());
        if (world != null) {
            for (int ix = portal.getPortalArea().getLowPoint().getX(); ix <= portal.getPortalArea().getHighPoint().getX(); ++ix) {
                for (int iy = portal.getPortalArea().getLowPoint().getY(); iy <= portal.getPortalArea().getHighPoint().getY(); ++iy) {
                    for (int iz = portal.getPortalArea().getLowPoint().getZ(); iz <= portal.getPortalArea().getHighPoint().getZ(); ++iz) {
                        if (world.func_147439_a(ix, iy, iz) == Blocks.field_150410_aZ) continue;
                        world.func_147449_b(ix, iy, iz, Blocks.field_150410_aZ);
                    }
                }
            }
        }
    }
}

