/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.teleport.portal;

import com.forgeessentials.commons.selections.AreaBase;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.commons.selections.Selection;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.teleport.portal.Portal;
import com.forgeessentials.teleport.portal.PortalManager;
import com.forgeessentials.util.NamedWorldArea;
import com.forgeessentials.util.NamedWorldPoint;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.selections.SelectionHandler;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandPortal
extends ForgeEssentialsCommandBase {
    public static final String PERM = "fe.teleport.portal";

    public String func_71517_b() {
        return "portal";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "/portal delete|create <name> [width] [height] [x y z]";
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    @Override
    public String getPermissionNode() {
        return PERM;
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] argsArray) {
        String subcommand;
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(argsArray));
        if (args.isEmpty()) {
            OutputHandler.chatConfirmation((ICommandSender)sender, this.func_71518_a((ICommandSender)sender));
            return;
        }
        switch (subcommand = ((String)args.remove()).toLowerCase()) {
            case "create": {
                CommandPortal.parseCreate(sender, args);
                break;
            }
            case "delete": {
                CommandPortal.parseDelete(sender, args);
                break;
            }
            default: {
                throw new CommandException("Unknown subcommand " + subcommand, new Object[0]);
            }
        }
    }

    private static void parseCreate(EntityPlayerMP sender, Queue<String> args) {
        Selection selection;
        if (args.isEmpty()) {
            OutputHandler.chatConfirmation((ICommandSender)sender, "/portal create <name> [width] [height] [x y z]");
            return;
        }
        String name = args.remove();
        if (PortalManager.getInstance().portals.containsKey(name)) {
            throw new CommandException("Portal by that name already exists.", new Object[0]);
        }
        NamedWorldPoint target = new NamedWorldPoint((Entity)sender);
        if (!args.isEmpty()) {
            if (args.size() < 3) {
                throw new CommandException("Expected arguments [x y z]", new Object[0]);
            }
            int x = CommandPortal.func_71526_a((ICommandSender)sender, (String)args.remove());
            int y = CommandPortal.func_71526_a((ICommandSender)sender, (String)args.remove());
            int z = CommandPortal.func_71526_a((ICommandSender)sender, (String)args.remove());
            target = new NamedWorldPoint(sender.field_71093_bK, x, y, z);
        }
        if ((selection = SelectionHandler.selectionProvider.getSelection(sender)) == null) {
            throw new CommandException("Missing selection", new Object[0]);
        }
        Point size = selection.getSize();
        if (size.getX() > 0 && size.getY() > 0 && size.getZ() > 0) {
            throw new CommandException("Portal selection must be flat in one axis", new Object[0]);
        }
        Portal portal = new Portal(new NamedWorldArea(sender.field_71093_bK, (AreaBase)selection), target);
        PortalManager.getInstance().add(name, portal);
        OutputHandler.chatConfirmation((ICommandSender)sender, String.format("Created new portal leading to %s", target.toString()));
    }

    private static void parseDelete(EntityPlayerMP sender, Queue<String> args) {
        if (args.isEmpty()) {
            OutputHandler.chatConfirmation((ICommandSender)sender, "/portal delete <name>");
            return;
        }
        String name = args.remove();
        if (!PortalManager.getInstance().portals.containsKey(name)) {
            throw new CommandException("Portal by that name does not exist.", new Object[0]);
        }
        PortalManager.getInstance().remove(name);
    }
}

