/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.teleport;

import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.core.misc.TeleportHelper;
import com.forgeessentials.teleport.CommandBack;
import com.forgeessentials.teleport.util.TeleportDataManager;
import com.forgeessentials.teleport.util.Warp;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.PlayerInfo;
import com.forgeessentials.util.UserIdent;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandWarp
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "warp";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length == 0) {
            String msg = "";
            for (String warp : TeleportDataManager.warps.keySet()) {
                msg = warp + ", " + msg;
            }
            OutputHandler.chatNotification((ICommandSender)sender, msg);
        } else if (args.length == 1) {
            if (TeleportDataManager.warps.containsKey(args[0].toLowerCase())) {
                if (PermissionsManager.checkPermission((EntityPlayer)sender, this.getPermissionNode() + "." + args[0].toLowerCase())) {
                    Warp warp = TeleportDataManager.warps.get(args[0].toLowerCase());
                    PlayerInfo playerInfo = PlayerInfo.getPlayerInfo(sender.getPersistentID());
                    playerInfo.setLastTeleportOrigin(new WarpPoint((Entity)sender));
                    CommandBack.justDied.remove(sender.getPersistentID());
                    TeleportHelper.teleport(sender, warp.getPoint());
                } else {
                    OutputHandler.chatError((ICommandSender)sender, "You have insufficient permissions to do that. If you believe you received this message in error, please talk to a server admin.");
                }
            } else {
                OutputHandler.chatError((ICommandSender)sender, "That warp doesn't exist!");
            }
        } else if (args.length == 2) {
            if (PermissionsManager.checkPermission((EntityPlayer)sender, "fe.teleport.warp.admin")) {
                if (args[0].equalsIgnoreCase("set")) {
                    if (TeleportDataManager.warps.containsKey(args[1].toLowerCase())) {
                        OutputHandler.chatError((ICommandSender)sender, "That warp already exists. Use '/warp del <name>' to delete.");
                    } else {
                        Warp warp = new Warp(args[1].toLowerCase(), new WarpPoint(sender.field_71093_bK, sender.field_70165_t, sender.field_70163_u, sender.field_70161_v, sender.field_70125_A, sender.field_70177_z));
                        TeleportDataManager.addWarp(warp);
                        if (!TeleportDataManager.warps.containsKey(args[1].toLowerCase())) {
                            OutputHandler.chatError((ICommandSender)sender, "Could not make warp! This is an error!");
                        } else {
                            OutputHandler.chatConfirmation((ICommandSender)sender, "Done!");
                        }
                    }
                } else if (args[0].equalsIgnoreCase("del")) {
                    if (TeleportDataManager.warps.containsKey(args[1].toLowerCase())) {
                        TeleportDataManager.removeWarp(TeleportDataManager.warps.get(args[1]));
                        OutputHandler.chatConfirmation((ICommandSender)sender, "Done!");
                    } else {
                        OutputHandler.chatError((ICommandSender)sender, "That warp doesn't exist!");
                    }
                } else {
                    OutputHandler.chatError((ICommandSender)sender, "Improper syntax. Please try this instead: [name] OR <set|del> <name> ");
                }
            } else {
                OutputHandler.chatError((ICommandSender)sender, "You have insufficient permissions to do that. If you believe you received this message in error, please talk to a server admin.");
            }
        }
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        if (args.length == 2) {
            if (TeleportDataManager.warps.containsKey(args[1].toLowerCase())) {
                EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername(sender, args[0]);
                if (player != null) {
                    Warp warp = TeleportDataManager.warps.get(args[1].toLowerCase());
                    PlayerInfo.getPlayerInfo(player.getPersistentID()).setLastTeleportOrigin(new WarpPoint((Entity)player));
                    TeleportHelper.teleport(player, warp.getPoint());
                } else {
                    OutputHandler.chatError(sender, String.format("Player %s does not exist, or is not online.", args[0]));
                }
            } else {
                OutputHandler.felog.info("CommandBlock Error: That warp doesn't exist!");
            }
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    @Override
    public boolean canCommandBlockUseCommand(TileEntityCommandBlock te) {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.teleport.warp";
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandWarp.func_71531_a((String[])args, TeleportDataManager.warps.keySet());
        }
        if (args.length == 2) {
            return CommandWarp.func_71530_a((String[])args, (String[])new String[]{"set", "del"});
        }
        return null;
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/warp [name] OR <set|del> <name> Teleports you to a warp point. You can also manipulate warps if you have permissions.";
    }
}

