/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.teleport;

import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.core.misc.TeleportHelper;
import com.forgeessentials.teleport.CommandBack;
import com.forgeessentials.teleport.TeleportModule;
import com.forgeessentials.teleport.util.TPAdata;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.PlayerInfo;
import com.forgeessentials.util.UserIdent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandTPA
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "tpa";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length == 0) {
            OutputHandler.chatError((ICommandSender)sender, "Improper syntax. Please try this instead: /tpa [player] <player|<x> <y> <z>|accept|decline>");
            return;
        }
        if (args[0].equalsIgnoreCase("accept")) {
            for (TPAdata data : TeleportModule.tpaList) {
                if (data.tphere || data.receiver != sender) continue;
                OutputHandler.chatNotification((ICommandSender)data.sender, "Teleport request accepted.");
                OutputHandler.chatConfirmation((ICommandSender)data.receiver, "Teleport request accepted by other party. Teleporting..");
                PlayerInfo playerInfo = PlayerInfo.getPlayerInfo(data.sender.getPersistentID());
                playerInfo.setLastTeleportOrigin(new WarpPoint((Entity)data.sender));
                CommandBack.justDied.remove(data.sender.getPersistentID());
                TeleportModule.tpaListToRemove.add(data);
                TeleportHelper.teleport(data.sender, new WarpPoint((Entity)data.receiver));
                return;
            }
            return;
        }
        if (args[0].equalsIgnoreCase("decline")) {
            for (TPAdata data : TeleportModule.tpaList) {
                if (data.tphere || data.receiver != sender) continue;
                OutputHandler.chatNotification((ICommandSender)data.sender, "Teleport request declined.");
                OutputHandler.chatError((ICommandSender)data.receiver, "Teleport request declined by other party.");
                TeleportModule.tpaListToRemove.add(data);
                return;
            }
            return;
        }
        if (!PermissionsManager.checkPermission((EntityPlayer)sender, "fe.teleport.tpa.sendrequest")) {
            OutputHandler.chatError((ICommandSender)sender, "You have insufficient permissions to do that. If you believe you received this message in error, please talk to a server admin.");
            return;
        }
        EntityPlayerMP receiver = UserIdent.getPlayerByMatchOrUsername((ICommandSender)sender, args[0]);
        if (receiver == null) {
            OutputHandler.chatError((ICommandSender)sender, args[0] + " not found.");
        } else {
            TeleportModule.tpaListToAdd.add(new TPAdata(sender, receiver, false));
            OutputHandler.chatNotification((ICommandSender)sender, String.format("Teleport request sent to %s", receiver.func_70005_c_()));
            OutputHandler.chatNotification((ICommandSender)receiver, String.format("Received teleport request from %s. Enter '/tpa accept' to accept, '/tpa decline' to decline.", sender.func_70005_c_()));
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    @Override
    public String getPermissionNode() {
        return "fe.teleport.tpa";
    }

    public List<String> func_71516_a(ICommandSender par1ICommandSender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("accept");
            list.add("decline");
            list.addAll(Arrays.asList(MinecraftServer.func_71276_C().func_71213_z()));
            return CommandTPA.func_71531_a((String[])args, list);
        }
        return null;
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/tpa [player] <player|<x> <y> <z>|accept|decline> Request to teleport yourself or another player.";
    }
}

