/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.teleport;

import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.core.misc.TeleportHelper;
import com.forgeessentials.teleport.util.RespawnHandler;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.PlayerInfo;
import com.forgeessentials.util.UserIdent;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionContext;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandSpawn
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "spawn";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length >= 1) {
            if (!PermissionsManager.checkPermission((EntityPlayer)sender, "fe.teleport.spawn.others")) {
                throw new CommandException("You don't have permissions to use this command!", new Object[0]);
            }
            EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername((ICommandSender)sender, args[0]);
            if (player == null) {
                throw new CommandException(String.format("Player %s does not exist, or is not online.", args[0]), new Object[0]);
            }
            WarpPoint point = RespawnHandler.getPlayerSpawn((EntityPlayer)player, null);
            if (point == null) {
                throw new CommandException("There is no spawnpoint set for that player.", new Object[0]);
            }
            PlayerInfo.getPlayerInfo(player.getPersistentID()).setLastTeleportOrigin(new WarpPoint((Entity)player));
            OutputHandler.chatNotification((ICommandSender)player, "Teleporting to spawn.");
            TeleportHelper.teleport(player, point);
        } else if (args.length == 0) {
            EntityPlayerMP player = sender;
            WarpPoint point = RespawnHandler.getPlayerSpawn((EntityPlayer)player, null);
            if (point == null) {
                throw new CommandException("There is no spawnpoint set for that player.", new Object[0]);
            }
            PlayerInfo.getPlayerInfo(player.getPersistentID()).setLastTeleportOrigin(new WarpPoint((Entity)player));
            OutputHandler.chatConfirmation((ICommandSender)player, "Teleporting to spawn.");
            TeleportHelper.teleport(player, point);
        }
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        if (args.length < 1) {
            throw new CommandException("Not enough arguments!", new Object[0]);
        }
        if (!PermissionsManager.checkPermission(new PermissionContext().setCommandSender(sender).setCommand((ICommand)this), "fe.teleport.spawn.others")) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername(sender, args[0]);
        if (player == null) {
            throw new CommandException(String.format("Player %s does not exist, or is not online.", args[0]), new Object[0]);
        }
        WarpPoint point = RespawnHandler.getPlayerSpawn((EntityPlayer)player, null);
        if (point == null) {
            throw new CommandException("There is no spawnpoint set for that player.", new Object[0]);
        }
        PlayerInfo.getPlayerInfo(player.getPersistentID()).setLastTeleportOrigin(new WarpPoint((Entity)player));
        OutputHandler.chatNotification((ICommandSender)player, "Teleporting to spawn.");
        TeleportHelper.teleport(player, point);
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.teleport.spawn";
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandSpawn.func_71530_a((String[])args, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z());
        }
        return null;
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }

    public String func_71518_a(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return "/spawn [player] Teleport you or another player to their spawn point.";
        }
        return "/spawn <player> Teleport a player to their spawn point.";
    }
}

